/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.FilterFunction_minimumRectangle;
import org.geotools.filter.function.FunctionTestFixture;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.algorithm.MinimumDiameter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class FilterFunction_minimumRectangleTest {
    @Test
    public void testGetArgCount() {
        FilterFunction_minimumRectangle f = new FilterFunction_minimumRectangle();
        Assert.assertEquals((long)1L, (long)f.getFunctionName().getArgumentCount());
    }

    @Test
    public void getName() {
        FilterFunction_minimumRectangle f = new FilterFunction_minimumRectangle();
        Assert.assertEquals((Object)"minrectangle", (Object)f.getName());
    }

    @Test
    public void testEvaluate() throws Exception {
        SimpleFeatureCollection featureCollection = FunctionTestFixture.polygons();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        Function exp = ff.function("minrectangle", new Expression[]{ff.property("geom")});
        try (SimpleFeatureIterator iter = featureCollection.features();){
            while (iter.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iter.next();
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                Geometry rectangle = new MinimumDiameter(geom).getMinimumRectangle();
                Object value = exp.evaluate((Object)feature);
                Assert.assertTrue((boolean)(value instanceof Polygon));
                Assert.assertEquals((Object)rectangle, (Object)value);
            }
        }
        Assert.assertNull((Object)exp.evaluate(null));
    }
}

