/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.HashMap;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CRSFactory;
import org.geotools.api.referencing.crs.CompoundCRS;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.function.NorthFix;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class NorthFixTest {
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    public static final Literal ANGLE_LT = FF.literal(10);
    public static final Literal WGS84_LT = FF.literal((Object)DefaultGeographicCRS.WGS84);
    static final GeometryFactory GF = new GeometryFactory();
    static final Point POINT = GF.createPoint();
    public static final Literal POINT_LT = FF.literal((Object)POINT);
    public static final String NORTH_FIX = "northFix";
    private static final double EPS = 1.0;

    @Test
    public void testLookup() throws Exception {
        Function function = FF.function(NORTH_FIX, new Expression[]{WGS84_LT, POINT_LT});
        MatcherAssert.assertThat((Object)function, (Matcher)Matchers.instanceOf(NorthFix.class));
    }

    @Test
    public void testGeographic() throws Exception {
        Function function = FF.function(NORTH_FIX, new Expression[]{WGS84_LT, POINT_LT});
        MatcherAssert.assertThat((Object)((Double)function.evaluate(null)), (Matcher)Matchers.equalTo((Object)0.0));
        Assert.assertFalse((boolean)NorthFix.fixRequired((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
    }

    @Test
    public void testGeographicAngle() throws Exception {
        Function function = FF.function(NORTH_FIX, new Expression[]{WGS84_LT, POINT_LT, ANGLE_LT});
        MatcherAssert.assertThat((Object)((Double)function.evaluate(null)), (Matcher)Matchers.equalTo((Object)10.0));
        Assert.assertFalse((boolean)NorthFix.fixRequired((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
    }

    @Test
    public void testCompound() throws Exception {
        CoordinateReferenceSystem compoundCRS = NorthFixTest.getCompoundCRS();
        Function function = FF.function(NORTH_FIX, new Expression[]{FF.literal((Object)compoundCRS), POINT_LT});
        MatcherAssert.assertThat((Object)((Double)function.evaluate(null)), (Matcher)Matchers.equalTo((Object)0.0));
        Assert.assertFalse((boolean)NorthFix.fixRequired((CoordinateReferenceSystem)compoundCRS));
    }

    private static CoordinateReferenceSystem getCompoundCRS() throws FactoryException {
        CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
        CoordinateReferenceSystem sourceHorizontalCRS = CRS.decode((String)"EPSG:4326");
        CoordinateReferenceSystem sourceVerticalCRS = CRS.decode((String)"EPSG:5783");
        HashMap<String, NamedIdentifier> properties = new HashMap<String, NamedIdentifier>();
        properties.put("name", new NamedIdentifier(Citations.fromName((String)"TEST"), "Compound 4326+5783"));
        CoordinateReferenceSystem[] elements = new CoordinateReferenceSystem[]{sourceHorizontalCRS, sourceVerticalCRS};
        CompoundCRS compoundCRS = crsFactory.createCompoundCRS(properties, elements);
        return compoundCRS;
    }

    @Test
    public void testEngineering() throws Exception {
        Function function = FF.function(NORTH_FIX, new Expression[]{FF.literal((Object)DefaultEngineeringCRS.CARTESIAN_2D), POINT_LT});
        MatcherAssert.assertThat((Object)((Double)function.evaluate(null)), (Matcher)Matchers.equalTo((Object)0.0));
        Assert.assertFalse((boolean)NorthFix.fixRequired((CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D));
    }

    @Test
    public void testPolar() throws Exception {
        CoordinateReferenceSystem polarCRS = CRS.decode((String)"EPSG:3976");
        Assert.assertTrue((boolean)NorthFix.fixRequired((CoordinateReferenceSystem)polarCRS));
        Assert.assertEquals((double)0.0, (double)NorthFixTest.getNorthFix(polarCRS, NorthFixTest.getPoint(0.0, 10000.0)), (double)1.0);
        Assert.assertEquals((double)90.0, (double)NorthFixTest.getNorthFix(polarCRS, NorthFixTest.getPoint(10000.0, 0.0)), (double)1.0);
        Assert.assertEquals((double)180.0, (double)NorthFixTest.getNorthFix(polarCRS, NorthFixTest.getPoint(0.0, -10000.0)), (double)1.0);
        Assert.assertEquals((double)270.0, (double)NorthFixTest.getNorthFix(polarCRS, NorthFixTest.getPoint(-10000.0, 0.0)), (double)1.0);
        Assert.assertEquals((double)45.0, (double)NorthFixTest.getNorthFix(polarCRS, NorthFixTest.getPoint(10000.0, 10000.0)), (double)1.0);
        Assert.assertEquals((double)135.0, (double)NorthFixTest.getNorthFix(polarCRS, NorthFixTest.getPoint(10000.0, -10000.0)), (double)1.0);
        Assert.assertEquals((double)225.0, (double)NorthFixTest.getNorthFix(polarCRS, NorthFixTest.getPoint(-10000.0, -10000.0)), (double)1.0);
        Assert.assertEquals((double)315.0, (double)NorthFixTest.getNorthFix(polarCRS, NorthFixTest.getPoint(-10000.0, 10000.0)), (double)1.0);
    }

    @Test
    public void testPolarExplicitSourceCRS() throws Exception {
        CoordinateReferenceSystem polarCRS = CRS.decode((String)"EPSG:3976");
        Point pt = NorthFixTest.getPoint(-102.0, -73.0);
        Function function = FF.function(NORTH_FIX, new Expression[]{FF.literal((Object)polarCRS), FF.literal((Object)pt), FF.literal(195), WGS84_LT});
        Assert.assertEquals((double)93.0, (double)((Double)function.evaluate(null, Double.class)), (double)1.0);
    }

    @Test
    public void testPolarMetadataSourceCRS() throws Exception {
        CoordinateReferenceSystem polarCRS = CRS.decode((String)"EPSG:3976");
        Point pt = NorthFixTest.getPoint(-102.0, -73.0);
        pt.setUserData((Object)DefaultGeographicCRS.WGS84);
        Function function = FF.function(NORTH_FIX, new Expression[]{FF.literal((Object)polarCRS), FF.literal((Object)pt), FF.literal(195)});
        Assert.assertEquals((double)93.0, (double)((Double)function.evaluate(null, Double.class)), (double)1.0);
    }

    @Test
    public void testPolarSridCRS() throws Exception {
        CoordinateReferenceSystem polarCRS = CRS.decode((String)"EPSG:3976");
        Point pt = NorthFixTest.getPoint(-102.0, -73.0);
        pt.setSRID(4326);
        Function function = FF.function(NORTH_FIX, new Expression[]{FF.literal((Object)polarCRS), FF.literal((Object)pt), FF.literal(195)});
        Assert.assertEquals((double)93.0, (double)((Double)function.evaluate(null, Double.class)), (double)1.0);
    }

    @Test
    public void testPolarFeatureCRS() throws Exception {
        CoordinateReferenceSystem polarCRS = CRS.decode((String)"EPSG:3976");
        SimpleFeature feature = NorthFixTest.buildWGS84Feature();
        Function function = FF.function(NORTH_FIX, new Expression[]{FF.literal((Object)polarCRS), FF.property("geom"), FF.literal(195)});
        Assert.assertEquals((double)93.0, (double)((Double)function.evaluate((Object)feature, Double.class)), (double)1.0);
    }

    private static SimpleFeature buildWGS84Feature() {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.add("geom", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        tb.setName("points");
        SimpleFeatureType ft = tb.buildFeatureType();
        SimpleFeature feature = DataUtilities.createFeature((SimpleFeatureType)ft, (String)"POINT(-102 -73)");
        return feature;
    }

    private static Point getPoint(double x, double y) {
        return GF.createPoint(new Coordinate(x, y));
    }

    private static Double getNorthFix(CoordinateReferenceSystem crs, Point point) {
        Function function = FF.function(NORTH_FIX, new Expression[]{FF.literal((Object)crs), FF.literal((Object)point)});
        return (Double)function.evaluate(null);
    }

    @Test
    public void testSimplifyNoConversion() throws Exception {
        PropertyName angle = FF.property("myAngle");
        NorthFix function = (NorthFix)FF.function(NORTH_FIX, new Expression[]{WGS84_LT, POINT_LT, angle});
        Expression simplified = function.simplify(FF, null);
        Assert.assertSame((Object)angle, (Object)simplified);
    }

    @Test
    public void testSimplifyNoAngle() throws Exception {
        NorthFix function = (NorthFix)FF.function(NORTH_FIX, new Expression[]{WGS84_LT, POINT_LT});
        Expression simplified = function.simplify(FF, null);
        Assert.assertEquals((Object)FF.literal(0.0), (Object)simplified);
    }

    @Test
    public void testSimplifyCRSConversions() throws Exception {
        NorthFix function = (NorthFix)FF.function(NORTH_FIX, new Expression[]{FF.literal((Object)"EPSG:3976"), POINT_LT, ANGLE_LT, FF.literal((Object)"CRS:84")});
        NorthFix simplified = (NorthFix)function.simplify(FF, null);
        Expression targetCRSParameter = (Expression)simplified.getParameters().get(0);
        MatcherAssert.assertThat((Object)targetCRSParameter, (Matcher)Matchers.instanceOf(Literal.class));
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:3976"), (Object)((Literal)targetCRSParameter).getValue());
        Expression sourceCRSParameter = (Expression)simplified.getParameters().get(3);
        MatcherAssert.assertThat((Object)sourceCRSParameter, (Matcher)Matchers.instanceOf(Literal.class));
        Assert.assertEquals((Object)CRS.decode((String)"CRS:84"), (Object)((Literal)sourceCRSParameter).getValue());
    }

    @Test
    public void testSimplifyFromFeatureType() throws Exception {
        SimpleFeature feature = NorthFixTest.buildWGS84Feature();
        PropertyName angle = FF.property("myAngle");
        NorthFix function = (NorthFix)FF.function(NORTH_FIX, new Expression[]{FF.literal((Object)"EPSG:3976"), FF.property("geom"), angle});
        Assert.assertEquals((long)3L, (long)function.getParameters().size());
        NorthFix simplified = (NorthFix)function.simplify(FF, (FeatureType)feature.getFeatureType());
        Assert.assertEquals((long)4L, (long)simplified.getParameters().size());
        Assert.assertEquals((Object)WGS84_LT, simplified.getParameters().get(3));
    }
}

