/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.function.Classifier;
import org.geotools.filter.function.ExplicitClassifier;
import org.geotools.filter.function.FunctionTestSupport;
import org.geotools.filter.function.QuantileFunction;
import org.geotools.filter.function.RangedClassifier;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class QuantileFunctionTest
extends FunctionTestSupport {
    @Test
    public void testInstance() {
        Function equInt = this.ff.function("Quantile", new Expression[]{this.ff.literal((Object)new DefaultFeatureCollection())});
        Assert.assertNotNull((Object)equInt);
    }

    @Test
    public void testGetName() {
        Function qInt = this.ff.function("Quantile", new Expression[]{this.ff.literal((Object)new DefaultFeatureCollection())});
        Assert.assertEquals((Object)"Quantile", (Object)qInt.getName());
    }

    @Test
    public void testSetParameters() throws Exception {
        Literal classes = this.ff.literal(3);
        PropertyName expr = this.ff.property("foo");
        QuantileFunction func = (QuantileFunction)this.ff.function("Quantile", new Expression[]{expr, classes});
        Assert.assertEquals((long)3L, (long)func.getClasses());
        classes = this.ff.literal(12);
        func = (QuantileFunction)this.ff.function("Quantile", new Expression[]{expr, classes});
        Assert.assertEquals((long)12L, (long)func.getClasses());
        classes = this.ff.literal(5);
        func = (QuantileFunction)this.ff.function("Quantile", new Expression[]{expr, classes});
        Assert.assertEquals((long)5L, (long)func.getClasses());
    }

    @Test
    public void testEvaluateWithExpressions() throws Exception {
        Literal classes = this.ff.literal(2);
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function("Quantile", new Expression[]{exp, classes});
        Object value = func.evaluate((Object)this.featureCollection);
        Assert.assertTrue((boolean)(value instanceof RangedClassifier));
        RangedClassifier ranged = (RangedClassifier)value;
        Assert.assertEquals((long)2L, (long)ranged.getSize());
        Assert.assertEquals((Object)"4..29", (Object)ranged.getTitle(0));
        Assert.assertEquals((Object)"29..90", (Object)ranged.getTitle(1));
    }

    @Test
    public void testSingleBin() throws Exception {
        SimpleFeatureType dataType = DataUtilities.createType((String)"classification.test1", (String)"id:0,value:int");
        int[] iVal = new int[]{1, 2, 3, 4, 5};
        SimpleFeature[] myfeatures = new SimpleFeature[iVal.length];
        for (int i = 0; i < iVal.length; ++i) {
            myfeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)dataType, (Object[])new Object[]{i + 1, iVal[i]}, (String)("classification.test1" + (i + 1)));
        }
        SimpleFeatureCollection myFeatureCollection = DataUtilities.collection((SimpleFeature[])myfeatures);
        Function function = this.ff.function("Quantile", new Expression[]{this.ff.property("value"), this.ff.literal(5)});
        Classifier classifier = (Classifier)function.evaluate((Object)myFeatureCollection);
        Assert.assertNotNull((Object)classifier);
        Assert.assertEquals(classifier.getClass(), RangedClassifier.class);
        RangedClassifier range = (RangedClassifier)classifier;
        Assert.assertEquals((long)5L, (long)range.getSize());
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((double)((double)i + 1.0), (double)((Number)range.getMin(i)).doubleValue(), (double)0.0);
            if (i != 4) {
                Assert.assertEquals((double)((double)i + 2.0), (double)((Number)range.getMax(i)).doubleValue(), (double)0.0);
                Assert.assertEquals((Object)(i + 1 + ".." + (i + 2)), (Object)range.getTitle(i));
                continue;
            }
            Assert.assertEquals((double)((double)i + 1.0), (double)((Number)range.getMax(i)).doubleValue(), (double)0.0);
            Assert.assertEquals((Object)(i + 1 + ".." + (i + 1)), (Object)range.getTitle(i));
        }
    }

    @Test
    public void test2() throws Exception {
        SimpleFeatureType dataType = DataUtilities.createType((String)"classification.test1", (String)"id:0,value:int");
        int[] iVal = new int[]{1, 2, 3, 4, 5, 6};
        SimpleFeature[] myfeatures = new SimpleFeature[iVal.length];
        for (int i = 0; i < iVal.length; ++i) {
            myfeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)dataType, (Object[])new Object[]{i + 1, iVal[i]}, (String)("classification.t" + (i + 1)));
        }
        SimpleFeatureCollection myFeatureCollection = DataUtilities.collection((SimpleFeature[])myfeatures);
        Function function = this.ff.function("Quantile", new Expression[]{this.ff.property("value"), this.ff.literal(5)});
        Classifier classifier = (Classifier)function.evaluate((Object)myFeatureCollection);
        Assert.assertTrue((boolean)(classifier instanceof RangedClassifier));
    }

    @Test
    public void testEvaluateWithStrings() throws Exception {
        Function function = this.ff.function("Quantile", new Expression[]{this.ff.property("group"), this.ff.literal(2)});
        Classifier classifier = (Classifier)function.evaluate((Object)this.featureCollection);
        Assert.assertNotNull((Object)classifier);
        Classifier classifier2 = (Classifier)function.evaluate((Object)this.featureCollection, Classifier.class);
        Assert.assertNotNull((Object)classifier2);
        Integer number = (Integer)function.evaluate((Object)this.featureCollection, Integer.class);
        Assert.assertNull((Object)number);
    }

    @Test
    @Ignore
    public void testNullNaNHandling() throws Exception {
        SimpleFeatureType ft = DataUtilities.createType((String)"classification.nullnan", (String)"id:0,foo:int,bar:double");
        Integer[] iVal = new Integer[]{0, 0, 0, 13, 13, 13, null, null, null};
        Double[] dVal = new Double[]{0.0, 50.01, null, 0.0, 50.01, null, 0.0, 50.01, null};
        SimpleFeature[] testFeatures = new SimpleFeature[iVal.length];
        for (int i = 0; i < iVal.length; ++i) {
            testFeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)ft, (Object[])new Object[]{i + 1, iVal[i], dVal[i]}, (String)("nantest.t" + (i + 1)));
        }
        SimpleFeatureCollection thisFC = DataUtilities.collection((SimpleFeature[])testFeatures);
        Divide divide = this.ff.divide((Expression)this.ff.property("foo"), (Expression)this.ff.property("bar"));
        QuantileFunction qf = (QuantileFunction)this.ff.function("Quantile", new Expression[]{divide, this.ff.literal(3)});
        RangedClassifier range = (RangedClassifier)qf.evaluate((Object)thisFC);
        Assert.assertEquals((long)2L, (long)range.getSize());
        Assert.assertEquals((Object)"0..0", (Object)range.getTitle(0));
        Assert.assertEquals((Object)"0..0.25995", (Object)range.getTitle(1));
    }

    @Test
    public void testConstantValuesNumeric() {
        Function function = this.ff.function("quantile", new Expression[]{this.ff.property("v"), this.ff.literal(12)});
        RangedClassifier classifier = (RangedClassifier)function.evaluate((Object)this.constantCollection);
        Assert.assertNotNull((Object)classifier);
        Assert.assertEquals((long)1L, (long)classifier.getSize());
        Assert.assertEquals((double)123.123, (double)((Double)classifier.getMin(0)), (double)0.0);
        Assert.assertEquals((double)123.123, (double)((Double)classifier.getMax(0)), (double)0.0);
    }

    @Test
    public void testConstantValuesString() {
        Function function = this.ff.function("quantile", new Expression[]{this.ff.property("s"), this.ff.literal(12)});
        ExplicitClassifier classifier = (ExplicitClassifier)function.evaluate((Object)this.constantCollection);
        Assert.assertNotNull((Object)classifier);
        Assert.assertEquals((long)1L, (long)classifier.getSize());
        Assert.assertEquals((long)1L, (long)classifier.getValues(0).size());
        Assert.assertEquals((Object)"abc", classifier.getValues(0).iterator().next());
    }

    @Test
    public void testEvaluateNumericalWithPercentages() {
        Literal classes = this.ff.literal(2);
        PropertyName exp = this.ff.property("foo");
        Function func = this.ff.function("Quantile", new Expression[]{exp, classes, this.ff.literal(true)});
        Object value = func.evaluate((Object)this.featureCollection);
        Assert.assertTrue((boolean)(value instanceof RangedClassifier));
        RangedClassifier ranged = (RangedClassifier)value;
        double[] percentages = ranged.getPercentages();
        Assert.assertEquals((long)percentages.length, (long)2L);
        Assert.assertEquals((double)percentages[0], (double)50.0, (double)0.0);
        Assert.assertEquals((double)percentages[1], (double)50.0, (double)0.0);
    }

    @Test
    public void testEvaluateNotNumericalWithPercentages() throws SchemaException {
        SimpleFeatureType dataType = DataUtilities.createType((String)"classification.test1", (String)"id:0,value:String");
        String[] sVal = new String[]{"a", "b", "c", "d", "e", "f"};
        SimpleFeature[] myfeatures = new SimpleFeature[sVal.length];
        for (int i = 0; i < sVal.length; ++i) {
            myfeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)dataType, (Object[])new Object[]{i + 1, sVal[i]}, (String)("classification.test1" + (i + 1)));
        }
        SimpleFeatureCollection myFeatureCollection = DataUtilities.collection((SimpleFeature[])myfeatures);
        Function func2 = this.ff.function("Quantile", new Expression[]{this.ff.property("value"), this.ff.literal(6), this.ff.literal(true)});
        Object value2 = func2.evaluate((Object)myFeatureCollection);
        Classifier ranged2 = (Classifier)value2;
        double[] percentages2 = ranged2.getPercentages();
        Assert.assertEquals((long)percentages2.length, (long)6L);
        for (double v : percentages2) {
            Assert.assertEquals((double)Math.floor(v), (double)16.0, (double)0.0);
        }
    }

    @Test
    public void testPercentagesConsistencyWithUnevenDistributedValues() throws SchemaException {
        SimpleFeatureType dataType = DataUtilities.createType((String)"classification.test1", (String)"id:0,value:int");
        int[] iVal = new int[]{1, 1, 2, 3, 4, 5};
        SimpleFeature[] myfeatures = new SimpleFeature[iVal.length];
        for (int i = 0; i < iVal.length; ++i) {
            myfeatures[i] = SimpleFeatureBuilder.build((SimpleFeatureType)dataType, (Object[])new Object[]{i + 1, iVal[i]}, (String)("classification.test1" + (i + 1)));
        }
        SimpleFeatureCollection myFeatureCollection = DataUtilities.collection((SimpleFeature[])myfeatures);
        Function func = this.ff.function("Quantile", new Expression[]{this.ff.property("value"), this.ff.literal(5), this.ff.literal(true)});
        Object value = func.evaluate((Object)myFeatureCollection);
        Assert.assertTrue((boolean)(value instanceof RangedClassifier));
        RangedClassifier ranged = (RangedClassifier)value;
        double[] percentages = ranged.getPercentages();
        Assert.assertEquals((long)percentages.length, (long)5L);
        Assert.assertEquals((double)Math.floor(percentages[0]), (double)33.0, (double)0.0);
        for (int i = 1; i < percentages.length; ++i) {
            Assert.assertEquals((double)Math.floor(percentages[i]), (double)16.0, (double)0.0);
        }
    }

    @Test
    public void testPercentagesConsistencyWithMoreClassThanIntervals() {
        Function func = this.ff.function("Quantile", new Expression[]{this.ff.property("foo"), this.ff.literal(10), this.ff.literal(true)});
        Object value = func.evaluate((Object)this.featureCollection);
        Assert.assertTrue((boolean)(value instanceof RangedClassifier));
        RangedClassifier ranged = (RangedClassifier)value;
        double[] percentages = ranged.getPercentages();
        Assert.assertEquals((long)percentages.length, (long)8L);
        for (double percentage : percentages) {
            Assert.assertEquals((double)12.5, (double)percentage, (double)0.0);
        }
    }
}

