/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.Arrays;
import org.geotools.geometry.jts.GeometryBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeometryBuilderTest {
    private static final double EPS = 1.0E-8;
    private static final Envelope RECT_ENV = new Envelope(-1.2, 3.4, -5.6, 7.8);
    private static final Envelope SQUARE_ENV = new Envelope(-1.2, 1.2, -1.2, 1.2);
    private static final GeometryBuilder builder = new GeometryBuilder();

    @Test
    public void box() throws Exception {
        Polygon p = builder.box(RECT_ENV.getMinX(), RECT_ENV.getMinY(), RECT_ENV.getMaxX(), RECT_ENV.getMaxY());
        this.assertBounds(RECT_ENV, p.getEnvelopeInternal(), 1.0E-8);
    }

    @Test
    public void boxZ() throws Exception {
        Polygon p = builder.boxZ(RECT_ENV.getMinX(), RECT_ENV.getMinY(), RECT_ENV.getMaxX(), RECT_ENV.getMaxY(), 42.0);
        this.assertBounds(RECT_ENV, p.getEnvelopeInternal(), 1.0E-8);
        Assert.assertEquals((long)42L, (long)((int)p.getCoordinate().getZ()));
    }

    @Test
    public void circle() throws Exception {
        double radius = SQUARE_ENV.getWidth() / 2.0;
        Polygon p = builder.circle(SQUARE_ENV.getMinX() + radius, SQUARE_ENV.getMinY() + radius, radius, this.getNumSides(SQUARE_ENV));
        this.assertBounds(SQUARE_ENV, p.getEnvelopeInternal(), 0.01);
    }

    @Test
    public void ellipse() throws Exception {
        Polygon p = builder.ellipse(RECT_ENV.getMinX(), RECT_ENV.getMinY(), RECT_ENV.getMaxX(), RECT_ENV.getMaxY(), this.getNumSides(RECT_ENV));
        this.assertBounds(RECT_ENV, p.getEnvelopeInternal(), 0.01);
    }

    @Test
    public void emptyLineString() throws Exception {
        LineString line = builder.lineString();
        Assert.assertTrue((boolean)line.isEmpty());
        Assert.assertEquals((long)2L, (long)line.getCoordinateSequence().getDimension());
    }

    @Test
    public void emptyLineStringZ() throws Exception {
        LineString line = builder.lineStringZ();
        Assert.assertEquals((long)3L, (long)line.getCoordinateSequence().getDimension());
    }

    @Test
    public void lineStringFromOrdinates() throws Exception {
        double[] ordinates = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0, 0.0};
        LineString line = builder.lineString(ordinates);
        Coordinate[] coords = line.getCoordinates();
        this.assertCoordinates(coords, ordinates, 2);
    }

    @Test
    public void lineStringZFromOrdinates() throws Exception {
        double[] ordinates = new double[]{1.0, 2.0, -3.0, 4.0, 5.0, -6.0, 7.0, 8.0, -9.0};
        LineString line = builder.lineStringZ(ordinates);
        Coordinate[] coords = line.getCoordinates();
        this.assertCoordinates(coords, ordinates, 3);
    }

    @Test
    public void linearRing() throws Exception {
        LinearRing ring = builder.linearRing();
        Assert.assertTrue((boolean)ring.isEmpty());
        Assert.assertEquals((long)2L, (long)ring.getCoordinateSequence().getDimension());
    }

    @Test
    public void linearRingZ() throws Exception {
        LinearRing ring = builder.linearRingZ();
        Assert.assertTrue((boolean)ring.isEmpty());
        Assert.assertEquals((long)3L, (long)ring.getCoordinateSequence().getDimension());
    }

    @Test
    public void linearRingFromOrdinates() throws Exception {
        double[] closedOrdinates = new double[]{1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 1.0, 1.0, 1.0};
        double[] openOrdinates = Arrays.copyOf(closedOrdinates, closedOrdinates.length - 2);
        LinearRing ring = builder.linearRing(openOrdinates);
        Assert.assertTrue((boolean)ring.isClosed());
        this.assertCoordinates(ring.getCoordinates(), closedOrdinates, 2);
    }

    @Test
    public void linearRingZFromOrdinates() throws Exception {
        double[] closedOrdinates = new double[]{1.0, 1.0, -1.0, 1.0, 2.0, -2.0, 2.0, 2.0, -2.0, 2.0, 1.0, -1.0, 1.0, 1.0, -1.0};
        double[] openOrdinates = Arrays.copyOf(closedOrdinates, closedOrdinates.length - 3);
        LinearRing ring = builder.linearRingZ(openOrdinates);
        Assert.assertTrue((boolean)ring.isClosed());
        this.assertCoordinates(ring.getCoordinates(), closedOrdinates, 3);
    }

    @Test
    public void multiPoint() throws Exception {
        double[] ords = new double[]{1.0, 2.0, 3.0, 4.0};
        MultiPoint mp = builder.multiPoint(ords[0], ords[1], ords[2], ords[3]);
        Assert.assertEquals((long)2L, (long)mp.getNumGeometries());
        Point p = (Point)mp.getGeometryN(0);
        Assert.assertEquals((long)2L, (long)p.getCoordinateSequence().getDimension());
    }

    @Test
    public void multiPointZ() throws Exception {
        double[] ords = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
        MultiPoint mp = builder.multiPointZ(ords[0], ords[1], ords[2], ords[3], ords[4], ords[5]);
        Assert.assertEquals((long)2L, (long)mp.getNumGeometries());
        Point p = (Point)mp.getGeometryN(0);
        Assert.assertEquals((long)3L, (long)p.getCoordinateSequence().getDimension());
    }

    private int getNumSides(Envelope env) {
        return (int)(10.0 * (env.getWidth() + env.getHeight()));
    }

    private void assertBounds(Envelope e1, Envelope e2, double tol) {
        if (e1.isNull()) {
            Assert.assertTrue((boolean)e2.isNull());
        }
        Assert.assertEquals((double)e1.getMinX(), (double)e2.getMinX(), (double)tol);
        Assert.assertEquals((double)e1.getMinY(), (double)e2.getMinY(), (double)tol);
        Assert.assertEquals((double)e1.getMaxX(), (double)e2.getMaxX(), (double)tol);
        Assert.assertEquals((double)e1.getMaxY(), (double)e2.getMaxY(), (double)tol);
    }

    private void assertCoordinates(Coordinate[] coords, double[] expectedOrdinates, int dim) {
        Assert.assertEquals((long)(expectedOrdinates.length / dim), (long)coords.length);
        for (int i = 0; i < expectedOrdinates.length; i += dim) {
            Coordinate c = coords[i / dim];
            for (int j = 0; j < dim; ++j) {
                Assert.assertEquals((double)expectedOrdinates[i + j], (double)c.getOrdinate(j), (double)1.0E-8);
            }
        }
    }
}

