/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.Map;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.style.ContrastMethod;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.NormalizeContrastMethodStrategy;
import org.junit.Assert;
import org.junit.Test;

public class ContrastEnhancementImplTest {
    private static FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);

    @Test
    public void testGetSetGammaValue() {
        ContrastEnhancementImpl contrastEnhancementImpl = new ContrastEnhancementImpl();
        double expected = 1.5;
        contrastEnhancementImpl.setGammaValue((Expression)filterFactory.literal(expected));
        double actual = (Double)((Literal)contrastEnhancementImpl.getGammaValue()).getValue();
        Assert.assertEquals((double)expected, (double)actual, (double)0.1);
    }

    @Test
    public void testGetSetMethod() {
        ContrastMethod expected = ContrastMethod.HISTOGRAM;
        ContrastEnhancementImpl contrastEnhancementImpl = new ContrastEnhancementImpl();
        contrastEnhancementImpl.setMethod(expected);
        ContrastMethod actual = contrastEnhancementImpl.getMethod();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testNormalize() {
        NormalizeContrastMethodStrategy normalize = new NormalizeContrastMethodStrategy();
        normalize.setAlgorithm((Expression)filterFactory.literal((Object)"ClipToMinimumMaximum"));
        Map params = normalize.getParameters();
        Assert.assertNotNull((String)"Null parameters returned by Normalize", (Object)params);
        normalize.addParameter("min", (Expression)filterFactory.literal(45.9));
        params = normalize.getParameters();
        Assert.assertEquals((String)"Wrong number of parameters returned", (long)1L, (long)params.size());
        normalize.addParameter("max", (Expression)filterFactory.function("env", new Expression[]{filterFactory.literal((Object)"arg1"), filterFactory.literal((Object)"arg2")}));
        params = normalize.getParameters();
        Expression max = (Expression)params.get("max");
        Assert.assertEquals((String)"mangled the function in normalize", (Object)"env([arg1], [arg2])", (Object)max.toString());
    }
}

