/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.awt.Color;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.visitor.DpiRescaleStyleVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import si.uom.SI;
import systems.uom.common.USCustomary;

public class DpiRescaleStyleVisitorTest {
    StyleBuilder sb;
    StyleFactory sf;
    FilterFactory ff;
    DpiRescaleStyleVisitor visitor;
    double scale;

    @Before
    public void setUp() throws Exception {
        this.sf = CommonFactoryFinder.getStyleFactory(null);
        this.ff = CommonFactoryFinder.getFilterFactory(null);
        this.sb = new StyleBuilder(this.sf, this.ff);
        this.scale = 2.0;
        this.visitor = new DpiRescaleStyleVisitor(this.scale);
    }

    @Test
    public void testNoUnit() throws Exception {
        Stroke original = this.sb.createStroke(Color.RED, 2.0, new float[]{5.0f, 10.0f});
        LineSymbolizer ls = this.sb.createLineSymbolizer(original);
        ls.accept((StyleVisitor)this.visitor);
        Stroke clone = ((LineSymbolizer)this.visitor.getCopy()).getStroke();
        Assert.assertEquals((double)4.0, (double)((Double)clone.getWidth().evaluate(null, Double.class)), (double)0.0);
        Assert.assertEquals((float)10.0f, (float)clone.getDashArray()[0], (float)0.0f);
        Assert.assertEquals((float)20.0f, (float)clone.getDashArray()[1], (float)0.0f);
        TextSymbolizer ts = this.sb.createTextSymbolizer();
        ts.getOptions().put("spaceAround", "10");
        ts.accept((StyleVisitor)this.visitor);
        TextSymbolizer clonedTs = (TextSymbolizer)this.visitor.getCopy();
        Assert.assertEquals((Object)"20.0", clonedTs.getOptions().get("spaceAround"));
    }

    @Test
    public void testAllMeters() throws Exception {
        Stroke original = this.sb.createStroke(Color.RED, 2.0, new float[]{5.0f, 10.0f});
        LineSymbolizer ls = this.sb.createLineSymbolizer(original);
        ls.setUnitOfMeasure(SI.METRE);
        ls.accept((StyleVisitor)this.visitor);
        Stroke clone = ((LineSymbolizer)this.visitor.getCopy()).getStroke();
        Assert.assertEquals((double)2.0, (double)((Double)clone.getWidth().evaluate(null, Double.class)), (double)0.0);
        Assert.assertEquals((float)5.0f, (float)clone.getDashArray()[0], (float)0.0f);
        Assert.assertEquals((float)10.0f, (float)clone.getDashArray()[1], (float)0.0f);
        TextSymbolizer ts = this.sb.createTextSymbolizer();
        ts.getOptions().put("spaceAround", "10");
        ts.setUnitOfMeasure(SI.METRE);
        ts.accept((StyleVisitor)this.visitor);
        TextSymbolizer clonedTs = (TextSymbolizer)this.visitor.getCopy();
        Assert.assertEquals((Object)"10.0", clonedTs.getOptions().get("spaceAround"));
    }

    @Test
    public void testAllFeet() throws Exception {
        Stroke original = this.sb.createStroke(Color.RED, 2.0, new float[]{5.0f, 10.0f});
        LineSymbolizer ls = this.sb.createLineSymbolizer(original);
        ls.setUnitOfMeasure(USCustomary.FOOT);
        ls.accept((StyleVisitor)this.visitor);
        Stroke clone = ((LineSymbolizer)this.visitor.getCopy()).getStroke();
        Assert.assertEquals((double)2.0, (double)((Double)clone.getWidth().evaluate(null, Double.class)), (double)0.0);
        Assert.assertEquals((float)5.0f, (float)clone.getDashArray()[0], (float)0.0f);
        Assert.assertEquals((float)10.0f, (float)clone.getDashArray()[1], (float)0.0f);
        TextSymbolizer ts = this.sb.createTextSymbolizer();
        ts.getOptions().put("spaceAround", "10");
        ts.setUnitOfMeasure(USCustomary.FOOT);
        ts.accept((StyleVisitor)this.visitor);
        TextSymbolizer clonedTs = (TextSymbolizer)this.visitor.getCopy();
        Assert.assertEquals((Object)"10.0", clonedTs.getOptions().get("spaceAround"));
    }

    @Test
    public void testSymbolizerMeterOverrideInPixels() throws Exception {
        Stroke original = this.sb.createStroke(Color.RED, 2.0, new float[]{5.0f, 10.0f});
        original.setWidth((Expression)this.ff.literal((Object)"2px"));
        LineSymbolizer ls = this.sb.createLineSymbolizer(original);
        ls.setUnitOfMeasure(SI.METRE);
        ls.accept((StyleVisitor)this.visitor);
        Stroke clone = ((LineSymbolizer)this.visitor.getCopy()).getStroke();
        Assert.assertEquals((double)4.0, (double)((Double)clone.getWidth().evaluate(null, Double.class)), (double)0.0);
        Assert.assertEquals((float)5.0f, (float)clone.getDashArray()[0], (float)0.0f);
        Assert.assertEquals((float)10.0f, (float)clone.getDashArray()[1], (float)0.0f);
        TextSymbolizer ts = this.sb.createTextSymbolizer();
        ts.getOptions().put("spaceAround", "10px");
        ts.setUnitOfMeasure(SI.METRE);
        ts.accept((StyleVisitor)this.visitor);
        TextSymbolizer clonedTs = (TextSymbolizer)this.visitor.getCopy();
        Assert.assertEquals((Object)"20.0", clonedTs.getOptions().get("spaceAround"));
    }

    @Test
    public void testSymbolizerPixelOverrideInMeters() throws Exception {
        Stroke original = this.sb.createStroke(Color.RED, 2.0, new float[]{5.0f, 10.0f});
        original.setWidth((Expression)this.ff.literal((Object)"2m"));
        LineSymbolizer ls = this.sb.createLineSymbolizer(original);
        ls.accept((StyleVisitor)this.visitor);
        Stroke clone = ((LineSymbolizer)this.visitor.getCopy()).getStroke();
        Assert.assertEquals((Object)"2m", (Object)clone.getWidth().evaluate(null, String.class));
        Assert.assertEquals((float)10.0f, (float)clone.getDashArray()[0], (float)0.0f);
        Assert.assertEquals((float)20.0f, (float)clone.getDashArray()[1], (float)0.0f);
        TextSymbolizer ts = this.sb.createTextSymbolizer();
        ts.getOptions().put("spaceAround", "10m");
        ts.accept((StyleVisitor)this.visitor);
        TextSymbolizer clonedTs = (TextSymbolizer)this.visitor.getCopy();
        Assert.assertEquals((Object)"10.0m", clonedTs.getOptions().get("spaceAround"));
    }
}

