/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.temporal.ClockTime;
import org.geotools.api.temporal.TemporalReferenceSystem;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.temporal.object.DefaultClockTime;
import org.geotools.temporal.reference.DefaultTemporalReferenceSystem;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultClockTimeTest {
    private ClockTime clockTime1;
    private ClockTime clockTime2;

    @Before
    public void setUp() {
        NamedIdentifier name = new NamedIdentifier(Citations.CRS, "Gregorian calendar");
        DefaultTemporalReferenceSystem frame = new DefaultTemporalReferenceSystem((ReferenceIdentifier)name, null);
        Number[] clck1 = new Number[]{8, 16, 25};
        Number[] clck2 = new Number[]{15, 55, 1};
        this.clockTime1 = new DefaultClockTime((TemporalReferenceSystem)frame, null, clck1);
        this.clockTime2 = new DefaultClockTime((TemporalReferenceSystem)frame, null, clck2);
    }

    @After
    public void tearDown() {
        this.clockTime1 = null;
        this.clockTime2 = null;
    }

    @Test
    public void testGetClockTime() {
        Number[] result = this.clockTime1.getClockTime();
        MatcherAssert.assertThat((Object)this.clockTime2.getClockTime(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)result)));
    }

    @Test
    public void testSetClockTime() {
        Number[] result = this.clockTime1.getClockTime();
        Number[] clcktime = new Number[]{14, 15, 0};
        ((DefaultClockTime)this.clockTime1).setClockTime(clcktime);
        MatcherAssert.assertThat((Object)this.clockTime1.getClockTime(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)result)));
    }

    @Test
    public void testEquals() {
        Assert.assertNotEquals(null, (Object)this.clockTime1);
        Assert.assertEquals((Object)this.clockTime1, (Object)this.clockTime1);
    }

    @Test
    public void testHashCode() {
        int result = this.clockTime1.hashCode();
        Assert.assertNotEquals((long)this.clockTime2.hashCode(), (long)result);
    }

    @Test
    public void testToString() {
        String result = this.clockTime1.toString();
        Assert.assertNotEquals((Object)this.clockTime2, (Object)result);
    }
}

