/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import java.util.GregorianCalendar;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.temporal.IndeterminateValue;
import org.geotools.api.temporal.TemporalCoordinate;
import org.geotools.api.temporal.TemporalReferenceSystem;
import org.geotools.api.util.InternationalString;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.temporal.object.DefaultTemporalCoordinate;
import org.geotools.temporal.reference.DefaultTemporalCoordinateSystem;
import org.geotools.util.SimpleInternationalString;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultTemporalCoordinateTest {
    private TemporalCoordinate temporalCoordinate1;
    private TemporalCoordinate temporalCoordinate2;

    @Before
    public void setUp() {
        GregorianCalendar gc = new GregorianCalendar(-4713, 1, 1);
        Integer coordinateValue = 100;
        DefaultTemporalCoordinateSystem frame1 = new DefaultTemporalCoordinateSystem((ReferenceIdentifier)new NamedIdentifier(Citations.CRS, (InternationalString)new SimpleInternationalString("Julian calendar")), null, gc.getTime(), (InternationalString)new SimpleInternationalString("day"));
        DefaultTemporalCoordinateSystem frame2 = new DefaultTemporalCoordinateSystem((ReferenceIdentifier)new NamedIdentifier(Citations.CRS, (InternationalString)new SimpleInternationalString("Julian calendar")), null, gc.getTime(), (InternationalString)new SimpleInternationalString("hour"));
        this.temporalCoordinate1 = new DefaultTemporalCoordinate((TemporalReferenceSystem)frame1, IndeterminateValue.NOW, (Number)coordinateValue);
        this.temporalCoordinate2 = new DefaultTemporalCoordinate((TemporalReferenceSystem)frame2, IndeterminateValue.AFTER, (Number)coordinateValue);
    }

    @After
    public void tearDown() {
        this.temporalCoordinate1 = null;
        this.temporalCoordinate2 = null;
    }

    @Test
    public void testGetCoordinateValue() {
        Number result = this.temporalCoordinate1.getCoordinateValue();
        Assert.assertSame((Object)this.temporalCoordinate2.getCoordinateValue(), (Object)result);
    }

    @Test
    public void testSetCoordinateValue() {
        Number result = this.temporalCoordinate1.getCoordinateValue();
        ((DefaultTemporalCoordinate)this.temporalCoordinate1).setCoordinateValue((Number)250);
        Assert.assertNotSame((Object)this.temporalCoordinate1.getCoordinateValue(), (Object)result);
    }

    @Test
    public void testEquals() {
        Assert.assertNotEquals(null, (Object)this.temporalCoordinate1);
        Assert.assertEquals((Object)this.temporalCoordinate1, (Object)this.temporalCoordinate1);
        Assert.assertNotEquals((Object)this.temporalCoordinate1, (Object)this.temporalCoordinate2);
    }

    @Test
    public void testHashCode() {
        int result = this.temporalCoordinate1.hashCode();
        Assert.assertNotEquals((long)this.temporalCoordinate2.hashCode(), (long)result);
    }

    @Test
    public void testToString() {
        String result = this.temporalCoordinate1.toString();
        Assert.assertNotEquals((Object)this.temporalCoordinate2.toString(), (Object)result);
    }
}

