/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.api.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataAccessFinder;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.util.factory.FactoryCreator;
import org.geotools.util.factory.FactoryRegistry;

public final class DataStoreFinder {
    private static volatile FactoryRegistry registry;

    private DataStoreFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataStore getDataStore(Map<String, ?> params) throws IOException {
        Class<DataAccessFinder> clazz = DataAccessFinder.class;
        synchronized (DataAccessFinder.class) {
            Iterator<DataStoreFactorySpi> ps = DataStoreFinder.getAvailableDataStores();
            DataAccess<? extends FeatureType, ? extends Feature> dataStore = DataAccessFinder.getDataStore(params, ps);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (DataStore)dataStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<DataStoreFactorySpi> getAllDataStores() {
        Class<DataAccessFinder> clazz = DataAccessFinder.class;
        synchronized (DataAccessFinder.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return DataAccessFinder.getAllDataStores(DataStoreFinder.getServiceRegistry(), DataStoreFactorySpi.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<DataStoreFactorySpi> getAvailableDataStores() {
        Class<DataAccessFinder> clazz = DataAccessFinder.class;
        synchronized (DataAccessFinder.class) {
            FactoryRegistry serviceRegistry = DataStoreFinder.getServiceRegistry();
            Set<DataStoreFactorySpi> availableDS = DataAccessFinder.getAvailableDataStores(serviceRegistry, DataStoreFactorySpi.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return availableDS.iterator();
        }
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(DataAccessFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(DataStoreFactorySpi.class));
        }
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanForPlugins() {
        Class<DataAccessFinder> clazz = DataAccessFinder.class;
        synchronized (DataAccessFinder.class) {
            DataStoreFinder.getServiceRegistry().scanForPlugins();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void reset() {
        FactoryRegistry copy = registry;
        registry = null;
        if (copy != null) {
            copy.deregisterAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerFactory(DataStoreFactorySpi factorySpi) {
        Class<DataAccessFinder> clazz = DataAccessFinder.class;
        synchronized (DataAccessFinder.class) {
            DataStoreFinder.getServiceRegistry().registerFactory((Object)factorySpi);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterFactory(DataStoreFactorySpi factorySpi) {
        Class<DataAccessFinder> clazz = DataAccessFinder.class;
        synchronized (DataAccessFinder.class) {
            DataStoreFinder.getServiceRegistry().deregisterFactory((Object)factorySpi);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Deprecated
    public static void registerFactrory(DataStoreFactorySpi factorySpi) {
        DataStoreFinder.registerFactory(factorySpi);
    }

    @Deprecated
    public static void deregisterFactrory(DataStoreFactorySpi factorySpi) {
        DataStoreFinder.deregisterFactory(factorySpi);
    }
}

