/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.text.MessageFormat;
import java.util.Map;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.metadata.citation.CitationFactory;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.crs.CRSFactory;
import org.geotools.api.referencing.cs.CSAuthorityFactory;
import org.geotools.api.referencing.cs.CSFactory;
import org.geotools.api.referencing.datum.DatumAuthorityFactory;
import org.geotools.api.referencing.datum.DatumFactory;
import org.geotools.api.referencing.operation.CoordinateOperationAuthorityFactory;
import org.geotools.api.referencing.operation.CoordinateOperationFactory;
import org.geotools.api.util.NameFactory;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.util.Classes;
import org.geotools.util.factory.FactoryNotFoundException;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.Hints;

public class BasicFactories {
    private static final String DEFAULT_AUTHORITY = "EPSG";
    private static BasicFactories DEFAULT;
    protected final Hints hints;

    public BasicFactories(Map hints) {
        this.hints = hints != null ? new Hints(hints) : null;
    }

    public static synchronized BasicFactories getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new BasicFactories((Map)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
        }
        return DEFAULT;
    }

    private static String unsupportedFactory(Class type) {
        String arg0 = Classes.getShortName((Class)type);
        return MessageFormat.format("No factory of kind \"{0}\" found.", arg0);
    }

    public FilterFactory getFilterFactory() throws FactoryRegistryException {
        throw new FactoryNotFoundException(BasicFactories.unsupportedFactory(FilterFactory.class));
    }

    public NameFactory getNameFactory() throws FactoryRegistryException {
        throw new FactoryNotFoundException(BasicFactories.unsupportedFactory(NameFactory.class));
    }

    public CitationFactory getCitationFactory() throws FactoryRegistryException {
        throw new FactoryNotFoundException(BasicFactories.unsupportedFactory(CitationFactory.class));
    }

    public CRSAuthorityFactory getCRSAuthorityFactory() throws FactoryRegistryException {
        return ReferencingFactoryFinder.getCRSAuthorityFactory((String)DEFAULT_AUTHORITY, (Hints)this.hints);
    }

    public CRSFactory getCRSFactory() throws FactoryRegistryException {
        return ReferencingFactoryFinder.getCRSFactory((Hints)this.hints);
    }

    public CSAuthorityFactory getCSAuthorityFactory() throws FactoryRegistryException {
        return ReferencingFactoryFinder.getCSAuthorityFactory((String)DEFAULT_AUTHORITY, (Hints)this.hints);
    }

    public CSFactory getCSFactory() throws FactoryRegistryException {
        return ReferencingFactoryFinder.getCSFactory((Hints)this.hints);
    }

    public DatumAuthorityFactory getDatumAuthorityFactory() throws FactoryRegistryException {
        return ReferencingFactoryFinder.getDatumAuthorityFactory((String)DEFAULT_AUTHORITY, (Hints)this.hints);
    }

    public DatumFactory getDatumFactory() throws FactoryRegistryException {
        return ReferencingFactoryFinder.getDatumFactory((Hints)this.hints);
    }

    public CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory() throws FactoryRegistryException {
        return ReferencingFactoryFinder.getCoordinateOperationAuthorityFactory((String)DEFAULT_AUTHORITY, (Hints)this.hints);
    }

    public CoordinateOperationFactory getCoordinateOperationFactory() throws FactoryRegistryException {
        return ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)this.hints);
    }
}

