/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CalcUtil;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.feature.visitor.LimitingVisitor;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.Converters;

public class UniqueVisitor
implements FeatureCalc,
FeatureAttributeVisitor,
LimitingVisitor {
    private List<Expression> expressions = new LinkedList<Expression>();
    Set<Object> set = new HashSet<Object>();
    Set<Object> skipped = new HashSet<Object>();
    int startIndex = 0;
    int maxFeatures = Integer.MAX_VALUE;
    int currentItem = 0;
    boolean preserveOrder = false;
    static FilterFactory factory = CommonFactoryFinder.getFilterFactory();

    public UniqueVisitor(int attributeTypeIndex, SimpleFeatureType type) throws IllegalFilterException {
        this(type, attributeTypeIndex);
    }

    public UniqueVisitor(String attrName, SimpleFeatureType type) throws IllegalFilterException {
        this(type, attrName);
    }

    public UniqueVisitor(String ... attributeTypeNames) {
        for (String atn : attributeTypeNames) {
            this.expressions.add((Expression)factory.property(atn));
        }
    }

    public UniqueVisitor(SimpleFeatureType type, Integer ... indexes) throws IllegalFilterException {
        for (Integer i : indexes) {
            String attrName = type.getDescriptor(i.intValue()).getLocalName();
            this.expressions.add((Expression)factory.property(attrName));
        }
    }

    public UniqueVisitor(SimpleFeatureType type, String ... attributeNames) throws IllegalFilterException {
        for (String an : attributeNames) {
            String attrName = type.getDescriptor(an).getLocalName();
            this.expressions.add((Expression)factory.property(attrName));
        }
    }

    public UniqueVisitor(Expression ... expressions) {
        for (Expression e : expressions) {
            this.expressions.add(e);
        }
    }

    public void init(SimpleFeatureCollection collection) {
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public void setMaxFeatures(int maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    public void setPreserveOrder(boolean preserveOrder) {
        this.preserveOrder = preserveOrder;
        this.set = this.createNewSet(Collections.emptyList());
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    @Override
    public List<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public Optional<List<Class>> getResultType(List<Class> inputTypes) {
        return CalcUtil.reflectInputTypes(inputTypes.size(), inputTypes);
    }

    public void visit(SimpleFeature feature) {
        this.visit((Feature)feature);
    }

    public void visit(Feature feature) {
        if (!this.isMultiAttr()) {
            this.visitWithSingleAttribute(feature);
        } else {
            this.visitWithMultiAttributes(feature);
        }
    }

    private void visitWithSingleAttribute(Feature feature) {
        Expression expr = this.expressions.get(0);
        Object value = expr.evaluate((Object)feature);
        if (value != null && !this.set.contains(value) && !this.skipped.contains(value)) {
            if (this.currentItem >= this.startIndex && this.currentItem < this.startIndex + this.maxFeatures) {
                this.set.add(value);
            } else {
                this.skipped.add(value);
            }
            ++this.currentItem;
        }
    }

    private void visitWithMultiAttributes(Feature feature) {
        LinkedList<Object> uniqueVal = new LinkedList<Object>();
        for (Expression expr : this.expressions) {
            Object value = expr.evaluate((Object)feature);
            uniqueVal.add(value);
        }
        if (this.skipped == null) {
            this.skipped = new LinkedHashSet<Object>();
        }
        if (!this.set.contains(uniqueVal) && !this.skipped.contains(uniqueVal)) {
            if (this.currentItem >= this.startIndex && this.currentItem < this.startIndex + this.maxFeatures) {
                this.set.add(uniqueVal);
            } else {
                this.skipped.add(uniqueVal);
            }
            ++this.currentItem;
        }
    }

    private boolean isMultiAttr() {
        return this.expressions.size() > 1;
    }

    public Expression getExpression() {
        return this.expressions.get(0);
    }

    public Set getUnique() {
        return this.set;
    }

    public void setValue(Object value) {
        if (value instanceof Collection) {
            Collection cast = (Collection)value;
            this.set = this.createNewSet(cast);
        } else {
            List collection = (List)Converters.convert((Object)value, List.class);
            this.set = collection != null ? this.createNewSet(collection) : this.createNewSet(Collections.singleton(value));
        }
    }

    private Set<Object> createNewSet(Collection<Object> collection) {
        return UniqueResult.createNewSet(collection, this.preserveOrder);
    }

    public void reset() {
        this.set = this.createNewSet(Collections.emptyList());
        this.skipped = new HashSet<Object>();
        this.currentItem = 0;
    }

    @Override
    public CalcResult getResult() {
        if (this.set.isEmpty()) {
            return CalcResult.NULL_RESULT;
        }
        return new UniqueResult(this.set, this.preserveOrder);
    }

    public List<String> getAttrNames() {
        LinkedList<String> attributes = new LinkedList<String>();
        for (Expression e : this.expressions) {
            attributes.add(this.getPropertyName(e));
        }
        return attributes;
    }

    private String getPropertyName(Expression e) {
        String name = null;
        if (e instanceof PropertyName) {
            name = ((PropertyName)e).getPropertyName();
        } else {
            FilterAttributeExtractor extractor = new FilterAttributeExtractor();
            e.accept((ExpressionVisitor)extractor, null);
            String[] attrs = extractor.getAttributeNames();
            if (attrs != null && attrs.length > 0) {
                name = extractor.getAttributeNames()[0];
            }
        }
        return name;
    }

    @Override
    public boolean hasLimits() {
        return this.startIndex > 0 || this.maxFeatures < Integer.MAX_VALUE;
    }

    public boolean isPreserveOrder() {
        return this.preserveOrder;
    }

    public static class UniqueResult
    extends AbstractCalcResult {
        private Set<Object> unique;
        private boolean preserveOrder = false;

        public UniqueResult(Set<Object> newSet) {
            this(newSet, false);
        }

        public UniqueResult(Set<Object> newSet, boolean preserveOrder) {
            this.unique = newSet;
            this.preserveOrder = preserveOrder;
        }

        public static <T> Set<T> createNewSet(Collection<T> collection, boolean preserveOrder) {
            if (preserveOrder) {
                return new LinkedHashSet<T>(collection);
            }
            return new HashSet<T>(collection);
        }

        @Override
        public Object getValue() {
            if (this.unique == null) {
                return Collections.emptySet();
            }
            return UniqueResult.createNewSet(this.unique, this.preserveOrder);
        }

        @Override
        public boolean isCompatible(CalcResult targetResults) {
            return targetResults instanceof UniqueResult || targetResults == CalcResult.NULL_RESULT;
        }

        @Override
        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd == CalcResult.NULL_RESULT) {
                return this;
            }
            if (resultsToAdd instanceof UniqueResult) {
                Set<Object> newSet = UniqueResult.createNewSet(this.unique, this.preserveOrder);
                Set other = (Set)resultsToAdd.getValue();
                newSet.addAll(other);
                return new UniqueResult(newSet, this.preserveOrder);
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }
}

