/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.parameter.Parameter;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.util.DateRange;
import org.geotools.util.DateTimeParser;

public class ParseTimeFunction
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("parseTime", FunctionNameImpl.parameter("string", String.class), new Parameter[0]);
    DateTimeParser parser = new DateTimeParser(1, 65793);

    public ParseTimeFunction() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object object) {
        Date dateTime = null;
        try {
            Object value = (String)((LiteralExpressionImpl)this.params.get(0)).getValue();
            if (((String)value).startsWith("P")) {
                value = (String)value + "/PRESENT";
            }
            dateTime = this.getDate((String)value, dateTime);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return dateTime;
    }

    private Date getDate(String value, Date dateTime) throws ParseException {
        Collection parsedCollection = this.parser.parse(value);
        Object parsedObject = parsedCollection.iterator().next();
        if (parsedObject instanceof DateRange) {
            dateTime = ((DateRange)parsedObject).getMinValue();
        } else if (parsedObject instanceof Date) {
            dateTime = (Date)parsedObject;
        }
        return dateTime;
    }
}

