/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.function;

import java.util.List;
import java.util.logging.Logger;
import org.geotools.data.Parameter;
import org.geotools.filter.FunctionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.text.Text;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;

public class DefaultIfNullFunction
extends FunctionImpl {
    public static final FunctionName NAME;
    private static final Logger LOGGER;

    public DefaultIfNullFunction() {
        this.functionName = NAME;
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, null);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        Object inputEvaluated;
        List parameters = this.getParameters();
        Expression input = (Expression)parameters.get(0);
        Expression fallback = (Expression)parameters.get(1);
        Object fallbackEvaluated = context == null ? fallback.evaluate(object) : fallback.evaluate(object, context);
        try {
            inputEvaluated = context == null ? input.evaluate(object) : input.evaluate(object, context);
        }
        catch (Exception e) {
            inputEvaluated = null;
            LOGGER.warning("Exception evaluating expression, falling back to default value. Exception was: " + e.getClass().getSimpleName() + " (message: " + e.getMessage() + ")");
        }
        if (inputEvaluated != null) {
            return (T)inputEvaluated;
        }
        return (T)fallbackEvaluated;
    }

    static {
        LOGGER = Logger.getLogger(DefaultIfNullFunction.class.getName());
        Parameter result = new Parameter("result", Object.class, 1, 1);
        Parameter input = new Parameter("input", Object.class, 1, 1);
        Parameter fallback = new Parameter("DefaultIfNull", Object.class, Text.text((String)"DefaultIfNull"), Text.text((String)"The value to return if the input is null"), true, 0, 1, (Object)1.0, null);
        NAME = new FunctionNameImpl("DefaultIfNull", (org.opengis.parameter.Parameter)result, new org.opengis.parameter.Parameter[]{input, fallback});
    }
}

