/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.function;

import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.geotools.util.logging.Logging;

public class FontAttributesExtractor {
    private static final Pattern SPACE_SPLITTER = Pattern.compile("\\s+");
    private static final Logger LOGGER = Logging.getLogger(FontAttributesExtractor.class);
    private boolean bold;
    private boolean italic;
    private String baseName;

    public FontAttributesExtractor(String name) {
        String[] split = SPACE_SPLITTER.split(name);
        int maxIdx = split.length - 1;
        for (int i = 0; i < 3; ++i) {
            String term = split[maxIdx];
            if (term.equalsIgnoreCase("Bold")) {
                this.bold = true;
                --maxIdx;
            }
            if (term.equalsIgnoreCase("Italic")) {
                this.italic = true;
                --maxIdx;
            }
            if (!term.equalsIgnoreCase("Regular")) continue;
            --maxIdx;
        }
        if (maxIdx > 0) {
            StringJoiner sj = new StringJoiner(" ");
            for (int i = 0; i <= maxIdx; ++i) {
                sj.add(split[i]);
            }
            this.baseName = sj.toString();
        } else {
            LOGGER.log(Level.FINE, "Seems the name was formed only with Bold, Italic and Regular, falling back to use the orignal names");
            this.baseName = name;
            this.bold = false;
            this.italic = false;
        }
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public String getBaseName() {
        return this.baseName;
    }
}

