/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.layer;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.geotools.mbstyle.MBStyle;
import org.geotools.mbstyle.layer.MBLayer;
import org.geotools.mbstyle.parse.MBObjectParser;
import org.geotools.mbstyle.transform.MBStyleTransformer;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.json.simple.JSONObject;
import org.opengis.filter.expression.Expression;
import org.opengis.style.GraphicFill;
import org.opengis.style.SemanticType;

public class BackgroundMBLayer
extends MBLayer {
    private JSONObject paint = this.paint();
    private static String TYPE = "background";

    public BackgroundMBLayer(JSONObject json) {
        super(json, new MBObjectParser(BackgroundMBLayer.class));
    }

    @Override
    protected SemanticType defaultSemanticType() {
        return SemanticType.POLYGON;
    }

    public Color getBackgroundColor() {
        return this.parse.convertToColor(this.parse.optional(String.class, this.paint, "background-color", "#000000"));
    }

    public Expression backgroundColor() {
        return this.parse.color(this.paint, "background-color", Color.BLACK);
    }

    public String getBackgroundPattern() {
        return this.parse.optional(String.class, this.paint, "background-pattern", null);
    }

    public boolean hasBackgroundPattern() {
        return this.parse.isDefined(this.paint, "background-pattern");
    }

    public Expression backgroundPattern() {
        return this.parse.string(this.paint, "background-pattern", null);
    }

    public Number getBackgroundOpacity() {
        return this.parse.optional(Number.class, this.paint, "background-opacity", 1.0);
    }

    public Expression backgroundOpacity() {
        return this.parse.percentage(this.paint, "background-opacity", 1.0);
    }

    @Override
    public List<FeatureTypeStyle> transformInternal(MBStyle styleContext) {
        throw new UnsupportedOperationException("This layer is not meant to be transformed, but converted in a Style background fill");
    }

    public Fill getFill(MBStyle styleContext) {
        return this.getFill(styleContext, new MBStyleTransformer(new MBObjectParser(BackgroundMBLayer.class)));
    }

    private Fill getFill(MBStyle styleContext, MBStyleTransformer transformer) {
        if (this.hasBackgroundPattern()) {
            ExternalGraphic eg = transformer.createExternalGraphicForSprite(this.backgroundPattern(), styleContext);
            Graphic gf = this.sf.graphicFill(Arrays.asList(eg), this.backgroundOpacity(), null, null, null, null);
            return this.sf.fill((GraphicFill)gf, this.backgroundColor(), this.backgroundOpacity());
        }
        return this.sf.fill(null, this.backgroundColor(), this.backgroundOpacity());
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

