/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.layer;

import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.geotools.mbstyle.MBStyle;
import org.geotools.mbstyle.function.FontAlternativesFunction;
import org.geotools.mbstyle.function.FontAttributesExtractor;
import org.geotools.mbstyle.function.MapBoxFontBaseNameFunction;
import org.geotools.mbstyle.function.MapBoxFontStyleFunction;
import org.geotools.mbstyle.function.MapBoxFontWeightFunction;
import org.geotools.mbstyle.layer.MBLayer;
import org.geotools.mbstyle.parse.MBFilter;
import org.geotools.mbstyle.parse.MBFormatException;
import org.geotools.mbstyle.parse.MBObjectParser;
import org.geotools.mbstyle.transform.MBStyleTransformer;
import org.geotools.measure.Units;
import org.geotools.renderer.label.LabelCacheItem;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.Mark;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.text.Text;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.style.AnchorPoint;
import org.opengis.style.Description;
import org.opengis.style.Fill;
import org.opengis.style.LabelPlacement;
import org.opengis.style.SemanticType;

public class SymbolMBLayer
extends MBLayer {
    private static final Color DEFAULT_HALO_COLOR = new Color(0, 0, 0, 0);
    private JSONObject layout;
    private JSONObject paint = super.getPaint();
    private static String TYPE = "symbol";
    private Integer labelPriority;
    protected static final Set<String> MARK_SHEET_ALIASES = ImmutableSet.of((Object)"geotoolsmarks", (Object)"geoservermarks", (Object)"");
    protected static final int MARK_ICON_DEFAULT_SIZE = 32;

    public SymbolMBLayer(JSONObject json) {
        super(json, new MBObjectParser(SymbolMBLayer.class));
        this.layout = super.getLayout();
    }

    @Override
    protected SemanticType defaultSemanticType() {
        return SemanticType.ANY;
    }

    public SymbolPlacement getSymbolPlacement() {
        Object value = this.layout.get((Object)"symbol-placement");
        if (value != null && "line".equalsIgnoreCase((String)value)) {
            return SymbolPlacement.LINE;
        }
        return SymbolPlacement.POINT;
    }

    public Expression symbolPlacement() {
        return this.parse.string(this.layout, "symbol-placement", "point");
    }

    public Number getSymbolSpacing() throws MBFormatException {
        return this.parse.optional(Number.class, this.layout, "symbol-spacing", 250);
    }

    public Expression symbolSpacing() throws MBFormatException {
        return this.parse.percentage(this.layout, "symbol-spacing", 250);
    }

    public Boolean getSymbolAvoidEdges() throws MBFormatException {
        return this.parse.getBoolean(this.layout, "symbol-avoid-edges", false);
    }

    public Expression symbolAvoidEdges() {
        return this.parse.bool(this.layout, "symbol-avoid-edges", false);
    }

    public Boolean getIconAllowOverlap() throws MBFormatException {
        return this.parse.getBoolean(this.layout, "icon-allow-overlap", false);
    }

    public Expression iconAllowOverlap() throws MBFormatException {
        return this.parse.bool(this.layout, "icon-allow-overlap", false);
    }

    public Boolean getIconIgnorePlacement() throws MBFormatException {
        return this.parse.getBoolean(this.layout, "icon-ignore-placement", false);
    }

    public Expression iconIgnorePlacement() {
        return this.parse.bool(this.layout, "icon-ignore-placement", false);
    }

    public Boolean getIconOptional() throws MBFormatException {
        return this.parse.getBoolean(this.layout, "icon-optional", false);
    }

    public Expression iconOptional() {
        return this.parse.bool(this.layout, "icon-optional", false);
    }

    public Alignment getIconRotationAlignment() {
        Object value = this.layout.get((Object)"icon-rotation-alignment");
        if (value != null && "map".equalsIgnoreCase((String)value)) {
            return Alignment.MAP;
        }
        if (value != null && "viewport".equalsIgnoreCase((String)value)) {
            return Alignment.VIEWPORT;
        }
        return Alignment.AUTO;
    }

    public Expression iconRotationAlignment() {
        return this.parse.enumToExpression(this.layout, "icon-rotation-alignment", Alignment.class, Alignment.AUTO);
    }

    public Number getIconSize() throws MBFormatException {
        return this.parse.optional(Number.class, this.layout, "icon-size", 1.0);
    }

    public Expression iconSize() {
        return this.parse.percentage(this.layout, "icon-size", 1.0);
    }

    public IconTextFit getIconTextFit() {
        Object value = this.layout.get((Object)"icon-text-fit");
        if (value != null && "width".equalsIgnoreCase((String)value)) {
            return IconTextFit.WIDTH;
        }
        if (value != null && "height".equalsIgnoreCase((String)value)) {
            return IconTextFit.HEIGHT;
        }
        if (value != null && "both".equalsIgnoreCase((String)value)) {
            return IconTextFit.BOTH;
        }
        return IconTextFit.NONE;
    }

    public Expression iconTextFit() {
        return this.parse.string(this.layout, "icon-text-fit", "none");
    }

    public List<Number> getIconTextFitPadding() {
        return null;
    }

    public Expression iconTextFitPadding() {
        return null;
    }

    public String getIconImage() throws MBFormatException {
        return this.parse.optional(String.class, this.layout, "icon-image", null);
    }

    public boolean hasIconImage() throws MBFormatException {
        return this.parse.isDefined(this.layout, "icon-image");
    }

    public Expression iconImage() {
        return this.parse.string(this.layout, "icon-image", "");
    }

    public Number getIconRotate() throws MBFormatException {
        return this.parse.optional(Number.class, this.layout, "icon-rotate", 0.0);
    }

    public Expression iconRotate() throws MBFormatException {
        return this.parse.percentage(this.layout, "icon-rotate", 0);
    }

    public Number getIconPadding() throws MBFormatException {
        return this.parse.optional(Number.class, this.layout, "icon-padding", 2.0);
    }

    public Expression iconPadding() throws MBFormatException {
        return this.parse.percentage(this.layout, "icon-padding", 2.0);
    }

    public Boolean getIconKeepUpright() throws MBFormatException {
        return this.parse.getBoolean(this.layout, "icon-keep-upright", false);
    }

    public Expression iconKeepUpright() {
        return this.parse.bool(this.layout, "icon-keep-upright", false);
    }

    public double[] getIconOffset() throws MBFormatException {
        return this.parse.array(this.layout, "icon-offset", new double[]{0.0, 0.0});
    }

    public Point iconOffset() throws MBFormatException {
        if (this.layout.get((Object)"icon-offset") != null) {
            JSONArray array = (JSONArray)this.layout.get((Object)"icon-offset");
            Number x = (Number)array.get(0);
            Number y = (Number)array.get(1);
            return new Point(x.intValue(), y.intValue());
        }
        return new Point(0, 0);
    }

    public Displacement iconOffsetDisplacement() {
        return this.parse.displacement(this.layout, "icon-offset", this.sf.displacement((Expression)this.ff.literal(0), (Expression)this.ff.literal(0)));
    }

    public Alignment getTextPitchAlignment() {
        Object value = this.layout.get((Object)"text-pitch-alignment");
        if (value != null && "map".equalsIgnoreCase((String)value)) {
            return Alignment.MAP;
        }
        if (value != null && "viewport".equalsIgnoreCase((String)value)) {
            return Alignment.VIEWPORT;
        }
        return Alignment.AUTO;
    }

    public Expression textPitchAlignment() {
        return this.parse.enumToExpression(this.layout, "text-pitch-alignment", Alignment.class, Alignment.AUTO);
    }

    public Alignment getTextRotationAlignment() {
        Object value = this.layout.get((Object)"text-rotation-alignment");
        if (value != null && "map".equalsIgnoreCase((String)value)) {
            return Alignment.MAP;
        }
        if (value != null && "viewport".equalsIgnoreCase((String)value)) {
            return Alignment.VIEWPORT;
        }
        return Alignment.AUTO;
    }

    public Expression textRotationAlignment() {
        return this.parse.enumToExpression(this.layout, "text-rotation-alignment", Alignment.class, Alignment.AUTO);
    }

    public String getTextField() throws MBFormatException {
        return this.parse.optional(String.class, this.layout, "text-field", "");
    }

    public Expression textField() throws MBFormatException {
        return this.parse.string(this.layout, "text-field", "");
    }

    private boolean hasTextField() throws MBFormatException {
        return this.parse.isDefined(this.layout, "text-field");
    }

    public List<String> getTextFont() {
        if (this.layout.get((Object)"text-font") instanceof JSONObject) {
            return null;
        }
        String[] fonts = this.parse.array(String.class, this.layout, "text-font", new String[]{"Open Sans Regular", "Arial Unicode MS Regular"});
        return Arrays.asList(fonts);
    }

    public Expression textFont() throws MBFormatException {
        return this.parse.font(this.layout, "text-font");
    }

    public Number getTextSize() throws MBFormatException {
        return this.parse.optional(Number.class, this.layout, "text-size", 16.0);
    }

    public Expression textSize() throws MBFormatException {
        return this.parse.percentage(this.layout, "text-size", 16.0);
    }

    public Number getTextMaxWidth() throws MBFormatException {
        return this.parse.optional(Number.class, this.layout, "text-max-width", 10.0);
    }

    public Expression textMaxWidth() throws MBFormatException {
        return this.parse.percentage(this.layout, "text-max-width", 10.0);
    }

    public boolean hasTextMaxWidth() throws MBFormatException {
        return this.parse.isDefined(this.layout, "text-max-width");
    }

    public Number getTextLineHeight() throws MBFormatException {
        return this.parse.optional(Number.class, this.layout, "text-line-height", 1.2);
    }

    public Expression textLineHeight() throws MBFormatException {
        return this.parse.percentage(this.layout, "text-line-height", 1.2);
    }

    public Number getTextLetterSpacing() throws MBFormatException {
        return this.parse.optional(Number.class, this.layout, "text-letter-spacing", 0.0);
    }

    public Expression textLetterSpacing() throws MBFormatException {
        return this.parse.percentage(this.layout, "text-letter-spacing", 0.0);
    }

    public Justification getTextJustify() {
        Object value = this.layout.get((Object)"text-justify");
        if (value != null && "left".equalsIgnoreCase((String)value)) {
            return Justification.LEFT;
        }
        if (value != null && "right".equalsIgnoreCase((String)value)) {
            return Justification.RIGHT;
        }
        return Justification.CENTER;
    }

    public Expression textJustify() {
        return this.parse.enumToExpression(this.layout, "text-justify", Justification.class, Justification.CENTER);
    }

    public TextAnchor getTextAnchor() {
        String json = this.parse.get(this.layout, "text-anchor", "center");
        if (json == null) {
            return null;
        }
        return TextAnchor.parse(json);
    }

    public Expression textAnchor() {
        return this.parse.enumToExpression(this.layout, "text-anchor", TextAnchor.class, TextAnchor.CENTER);
    }

    public org.geotools.styling.AnchorPoint anchorPoint() {
        return this.anchorPointByProperty("text-anchor");
    }

    public org.geotools.styling.AnchorPoint iconAnchorPoint() {
        return this.anchorPointByProperty("icon-anchor");
    }

    public org.geotools.styling.AnchorPoint anchorPointByProperty(String propertyName) {
        Expression expression = this.parse.string(this.layout, propertyName, TextAnchor.CENTER.name());
        if (expression == null) {
            return null;
        }
        if (expression instanceof Literal) {
            TextAnchor anchor = TextAnchor.parse((String)expression.evaluate(null, String.class));
            return this.sf.anchorPoint((Expression)this.ff.literal(anchor.getX()), (Expression)this.ff.literal(anchor.getY()));
        }
        return this.sf.anchorPoint((Expression)this.ff.function("mbAnchor", new Expression[]{expression, this.ff.literal((Object)"x")}), (Expression)this.ff.function("mbAnchor", new Expression[]{expression, this.ff.literal((Object)"y")}));
    }

    public Number getTextMaxAngle() throws MBFormatException {
        return this.parse.optional(Number.class, this.layout, "text-max-angle", 45.0);
    }

    public Expression textMaxAngle() {
        return this.parse.percentage(this.layout, "text-max-angle", 45.0);
    }

    private boolean hasTextMaxAngle() throws MBFormatException {
        return this.parse.isDefined(this.layout, "text-max-angle");
    }

    public Number getTextRotate() throws MBFormatException {
        return this.parse.optional(Number.class, this.layout, "text-rotate", 0.0);
    }

    public Expression textRotate() throws MBFormatException {
        return this.parse.percentage(this.layout, "text-rotate", 0.0);
    }

    public Number getTextPadding() throws MBFormatException {
        return this.parse.optional(Number.class, this.layout, "text-padding", 2.0);
    }

    public Expression textPadding() throws MBFormatException {
        return this.parse.percentage(this.layout, "text-padding", 2.0);
    }

    public Boolean getTextKeepUpright() throws MBFormatException {
        return this.parse.getBoolean(this.layout, "text-keep-upright", true);
    }

    public Expression textKeepUpright() {
        return this.parse.bool(this.layout, "text-keep-upright", true);
    }

    public TextTransform getTextTransform() {
        Object value = this.layout.get((Object)"text-transform");
        if (value != null && "uppercase".equalsIgnoreCase((String)value)) {
            return TextTransform.UPPERCASE;
        }
        if (value != null && "lowercase".equalsIgnoreCase((String)value)) {
            return TextTransform.LOWERCASE;
        }
        return TextTransform.NONE;
    }

    public boolean hasTextTransform() {
        return this.parse.isDefined(this.layout, "text-transform");
    }

    public Expression textTransform() {
        return this.parse.enumToExpression(this.layout, "text-transform", TextTransform.class, TextTransform.NONE);
    }

    public double[] getTextOffset() throws MBFormatException {
        return this.parse.array(this.layout, "text-offset", new double[]{0.0, 0.0});
    }

    public Point textOffset() throws MBFormatException {
        if (this.layout.get((Object)"text-offset") != null) {
            JSONArray array = (JSONArray)this.layout.get((Object)"text-offset");
            Number x = (Number)array.get(0);
            Number y = (Number)array.get(1);
            return new Point(x.intValue(), y.intValue());
        }
        return new Point(0, 0);
    }

    public Displacement textOffsetDisplacement() {
        return this.parse.displacement(this.layout, "text-offset", this.sf.displacement((Expression)this.ff.literal(0), (Expression)this.ff.literal(0)));
    }

    private boolean hasTextOffset() {
        return this.parse.isDefined(this.layout, "text-offset");
    }

    public Boolean getTextAllowOverlap() throws MBFormatException {
        return this.parse.getBoolean(this.layout, "text-allow-overlap", false);
    }

    public Expression textAllowOverlap() throws MBFormatException {
        return this.parse.bool(this.layout, "text-allow-overlap", false);
    }

    public Boolean getTextIgnorePlacement() throws MBFormatException {
        return this.parse.getBoolean(this.layout, "text-ignore-placement", false);
    }

    public Expression textIgnorePlacement() {
        return this.parse.bool(this.layout, "text-ignore-placement", false);
    }

    public Boolean getTextOptional() throws MBFormatException {
        return this.parse.getBoolean(this.layout, "text-optional", false);
    }

    public Expression textOptional() {
        return this.parse.bool(this.layout, "text-optional", false);
    }

    public Number getIconOpacity() throws MBFormatException {
        return this.parse.optional(Number.class, this.paint, "icon-opacity", 1.0);
    }

    public Expression iconOpacity() throws MBFormatException {
        return this.parse.percentage(this.paint, "icon-opacity", 1.0);
    }

    public Color getIconColor() {
        return this.parse.optional(Color.class, this.paint, "icon-color", Color.BLACK);
    }

    public Expression iconColor() {
        return this.parse.color(this.paint, "icon-color", Color.BLACK);
    }

    public Color getIconHaloColor() {
        return this.parse.optional(Color.class, this.paint, "icon-halo-color", new Color(0, 0, 0, 0));
    }

    public Expression iconHaloColor() {
        return this.parse.color(this.paint, "icon-halo-color", Color.BLACK);
    }

    public Number getIconHaloWidth() throws MBFormatException {
        return this.parse.optional(Number.class, this.paint, "icon-halo-width", 0.0);
    }

    public Expression iconHaloWidth() {
        return this.parse.percentage(this.paint, "icon-halo-width", 0.0);
    }

    public Number getIconHaloBlur() throws MBFormatException {
        return this.parse.optional(Number.class, this.paint, "icon-halo-blur", 0.0);
    }

    public Expression iconHaloBlur() {
        return this.parse.percentage(this.paint, "icon-halo-blur", 0.0);
    }

    public int[] getIconTranslate() throws MBFormatException {
        return this.parse.array(this.paint, "icon-translate", new int[]{0, 0});
    }

    public Point iconTranslate() {
        int[] translate = this.getIconTranslate();
        return new Point(translate[0], translate[1]);
    }

    public Displacement iconTranslateDisplacement() {
        return this.parse.displacement(this.paint, "icon-translate", this.sf.displacement((Expression)this.ff.literal(0), (Expression)this.ff.literal(0)));
    }

    public TranslateAnchor getIconTranslateAnchor() {
        Object value = this.paint.get((Object)"icon-translate-anchor");
        if (value != null && "viewport".equalsIgnoreCase((String)value)) {
            return TranslateAnchor.VIEWPORT;
        }
        return TranslateAnchor.MAP;
    }

    public Expression iconTranslateAnchor() {
        return this.parse.enumToExpression(this.layout, "icon-translate-anchor", TranslateAnchor.class, TranslateAnchor.MAP);
    }

    public Number getTextOpacity() throws MBFormatException {
        return this.parse.optional(Number.class, this.paint, "text-opacity", 1.0);
    }

    public Expression textOpacity() throws MBFormatException {
        return this.parse.percentage(this.paint, "text-opacity", 1.0);
    }

    public Color getTextColor() throws MBFormatException {
        return this.parse.convertToColor(this.parse.optional(String.class, this.paint, "text-color", "#000000"));
    }

    public Expression textColor() {
        return this.parse.color(this.paint, "text-color", Color.BLACK);
    }

    public Color getTextHaloColor() throws MBFormatException {
        if (!this.paint.containsKey((Object)"text-halo-color")) {
            return DEFAULT_HALO_COLOR;
        }
        return this.parse.convertToColor(this.parse.optional(String.class, this.paint, "text-halo-color", "#000000"));
    }

    public Expression textHaloColor() {
        return this.parse.color(this.paint, "text-halo-color", DEFAULT_HALO_COLOR);
    }

    public Number getTextHaloWidth() throws MBFormatException {
        return this.parse.optional(Number.class, this.paint, "text-halo-width", 0.0);
    }

    public Expression textHaloWidth() throws MBFormatException {
        return this.parse.percentage(this.paint, "text-halo-width", 0.0);
    }

    public Number getTextHaloBlur() throws MBFormatException {
        return this.parse.optional(Number.class, this.paint, "text-halo-blur", 0.0);
    }

    public Expression textHaloBlur() throws MBFormatException {
        return this.parse.percentage(this.paint, "text-halo-blur", 0.0);
    }

    public int[] getTextTranslate() {
        return this.parse.array(this.paint, "text-translate", new int[]{0, 0});
    }

    public Point textTranslate() {
        int[] translate = this.getTextTranslate();
        return new Point(translate[0], translate[1]);
    }

    private boolean hasTextTranslate() {
        return this.parse.isDefined(this.layout, "text-translate");
    }

    public Displacement textTranslateDisplacement() {
        return this.parse.displacement(this.paint, "text-translate", this.sf.displacement((Expression)this.ff.literal(0), (Expression)this.ff.literal(0)));
    }

    public TranslateAnchor getTextTranslateAnchor() {
        Object value = this.paint.get((Object)"text-translate-anchor");
        if (value != null && "viewport".equalsIgnoreCase((String)value)) {
            return TranslateAnchor.VIEWPORT;
        }
        return TranslateAnchor.MAP;
    }

    public Expression textTranslateAnchor() {
        return this.parse.enumToExpression(this.layout, "text-translate-anchor", TranslateAnchor.class, TranslateAnchor.MAP);
    }

    @Override
    public List<FeatureTypeStyle> transformInternal(MBStyle styleContext) {
        Object textExpression;
        LinePlacement labelPlacement;
        MBStyleTransformer transformer = new MBStyleTransformer(this.parse);
        StyleBuilder sb = new StyleBuilder();
        ArrayList<TextSymbolizer2> symbolizers = new ArrayList<TextSymbolizer2>();
        String symbolPlacementVal = MBStyleTransformer.requireLiteral(this.symbolPlacement(), String.class, "point", "symbol-placement", this.getId());
        Expression fontSize = this.textSize();
        if ("point".equalsIgnoreCase(symbolPlacementVal.trim())) {
            PointPlacement pointP = sb.createPointPlacement();
            pointP.setAnchorPoint((AnchorPoint)this.anchorPoint());
            Displacement displacement = null;
            if (this.hasTextTranslate()) {
                Displacement textTranslate = this.textTranslateDisplacement();
                textTranslate.setDisplacementY((Expression)this.ff.multiply((Expression)this.ff.literal(-1), textTranslate.getDisplacementY()));
                displacement = textTranslate;
            }
            Displacement textOffset = null;
            if (this.hasTextOffset()) {
                textOffset = this.textOffsetDisplacement();
                textOffset.setDisplacementX((Expression)this.ff.multiply(fontSize, textOffset.getDisplacementX()));
                textOffset.setDisplacementY((Expression)this.ff.multiply(fontSize, (Expression)this.ff.multiply((Expression)this.ff.literal(-1), textOffset.getDisplacementY())));
                if (displacement == null) {
                    displacement = textOffset;
                } else {
                    displacement.setDisplacementX((Expression)this.ff.add(displacement.getDisplacementX(), textOffset.getDisplacementX()));
                    displacement.setDisplacementY((Expression)this.ff.add(displacement.getDisplacementY(), textOffset.getDisplacementY()));
                }
            }
            pointP.setDisplacement(displacement);
            pointP.setRotation(this.textRotate());
            labelPlacement = pointP;
        } else {
            LinePlacement lineP = sb.createLinePlacement(null);
            lineP.setRepeated(true);
            lineP.setPerpendicularOffset((Expression)this.ff.multiply(fontSize, (Expression)this.ff.multiply((Expression)this.ff.literal(-1), this.textOffsetDisplacement().getDisplacementY())));
            labelPlacement = lineP;
        }
        Expression haloColor = this.textHaloColor();
        Halo halo = null;
        if (!(haloColor instanceof Literal) || ((Color)haloColor.evaluate(null, Color.class)).getAlpha() > 0) {
            halo = this.sf.halo((Fill)this.sf.fill(null, haloColor, null), this.textHaloWidth());
        }
        org.geotools.styling.Fill fill = this.sf.fill(null, this.textColor(), this.textOpacity());
        ArrayList<Font> fonts = new ArrayList<Font>();
        List<String> staticFonts = this.getTextFont();
        if (staticFonts != null) {
            for (String textFont : staticFonts) {
                FontAttributesExtractor fae = new FontAttributesExtractor(textFont);
                Font font = sb.createFont((Expression)this.ff.function(FontAlternativesFunction.NAME.getName(), new Expression[]{this.ff.literal((Object)fae.getBaseName())}), (Expression)this.ff.literal((Object)(fae.isItalic() ? "italic" : "normal")), (Expression)this.ff.literal((Object)(fae.isBold() ? "bold" : "normal")), fontSize);
                fonts.add(font);
            }
        } else if (this.textFont() != null) {
            Expression dynamicFont = this.textFont();
            Font font = sb.createFont((Expression)this.ff.function(FontAlternativesFunction.NAME.getName(), new Expression[]{this.ff.function(MapBoxFontBaseNameFunction.NAME.getName(), new Expression[]{dynamicFont})}), (Expression)this.ff.function(MapBoxFontStyleFunction.NAME.getName(), new Expression[]{dynamicFont}), (Expression)this.ff.function(MapBoxFontWeightFunction.NAME.getName(), new Expression[]{dynamicFont}), fontSize);
            fonts.add(font);
        }
        if ((textExpression = this.textField()) instanceof Literal) {
            String text = (String)textExpression.evaluate(null, String.class);
            textExpression = text.trim().isEmpty() ? this.ff.literal((Object)" ") : transformer.cqlExpressionFromTokens(text);
        }
        if (this.hasTextTransform()) {
            textExpression = this.ff.function("StringTransform", new Expression[]{textExpression, this.textTransform()});
        }
        TextSymbolizer2 symbolizer = (TextSymbolizer2)this.sf.textSymbolizer(this.getId(), (Expression)this.ff.property((String)null), (Description)this.sf.description(Text.text((String)"text"), null), Units.PIXEL, textExpression, null, (LabelPlacement)labelPlacement, (org.opengis.style.Halo)halo, (Fill)fill);
        symbolizer.fonts().clear();
        symbolizer.fonts().addAll(fonts);
        Number symbolSpacing = MBStyleTransformer.requireLiteral(this.symbolSpacing(), Number.class, 250, "symbol-spacing", this.getId());
        symbolizer.getOptions().put("repeat", String.valueOf(symbolSpacing));
        if (labelPlacement instanceof LinePlacement) {
            symbolizer.getOptions().put("forceLeftToRight", String.valueOf(this.textKeepUpright()));
            symbolizer.getOptions().put("followLine", "true");
            symbolizer.getOptions().put("maxAngleDelta", String.valueOf(this.getTextMaxAngle()));
            symbolizer.getOptions().put("group", "true");
            symbolizer.getOptions().put("labelAllGroup", "true");
        } else if (this.hasTextMaxAngle()) {
            throw new MBFormatException("Property text-max-angle requires symbol-placement = line but symbol-placement = " + symbolPlacementVal);
        }
        Boolean textAllowOverlap = MBStyleTransformer.requireLiteral(this.textAllowOverlap(), Boolean.class, false, "text-allow-overlap", this.getId());
        Boolean iconAllowOverlap = MBStyleTransformer.requireLiteral(this.iconAllowOverlap(), Boolean.class, false, "icon-allow-overlap", this.getId());
        symbolizer.getOptions().put("conflictResolution", String.valueOf(textAllowOverlap == false && iconAllowOverlap == false));
        String textFitVal = MBStyleTransformer.requireLiteral(this.iconTextFit(), String.class, "none", "icon-text-fit", this.getId()).trim();
        if ("height".equalsIgnoreCase(textFitVal) || "width".equalsIgnoreCase(textFitVal)) {
            symbolizer.getOptions().put("graphic-resize", LabelCacheItem.GraphicResize.STRETCH.name());
        } else if ("both".equalsIgnoreCase(textFitVal)) {
            symbolizer.getOptions().put("graphic-resize", LabelCacheItem.GraphicResize.PROPORTIONAL.name());
        } else {
            symbolizer.getOptions().put("graphic-resize", LabelCacheItem.GraphicResize.NONE.name());
        }
        symbolizer.getOptions().put("partials", "false");
        if (this.getIconTextFitPadding() != null && !this.getIconTextFitPadding().isEmpty()) {
            symbolizer.getOptions().put("graphic-margin", String.valueOf(this.getIconTextFitPadding().get(0)));
        } else {
            symbolizer.getOptions().put("graphic-margin", "0");
        }
        if (!this.hasIconImage() || "point".equalsIgnoreCase(symbolPlacementVal.trim()) || this.getTextPadding().doubleValue() >= this.getIconPadding().doubleValue()) {
            symbolizer.getOptions().put("spaceAround", String.valueOf(this.getTextPadding()));
        }
        if (this.hasTextMaxWidth()) {
            double textMaxWidth = MBStyleTransformer.requireLiteral(this.textMaxWidth(), Double.class, 10.0, "text-max-width", this.getId());
            double textSize = MBStyleTransformer.requireLiteral(fontSize, Double.class, 16.0, "text-size (when text-max-width is specified)", this.getId());
            symbolizer.getOptions().put("autoWrap", String.valueOf(textMaxWidth * textSize));
        }
        if (this.hasIconImage()) {
            if (!this.hasTextField() || this.getIconPadding().doubleValue() > this.getTextPadding().doubleValue() && !"point".equalsIgnoreCase(symbolPlacementVal.trim())) {
                symbolizer.getOptions().put("spaceAround", String.valueOf(this.getIconPadding()));
            }
            Graphic graphic = this.getGraphic(transformer, styleContext);
            if ("point".equalsIgnoreCase(symbolPlacementVal.trim())) {
                symbolizer.getOptions().put("graphicPlacement", TextSymbolizer.GraphicPlacement.INDEPENDENT.name());
            }
            symbolizer.getOptions().put("fallbackOnDefaultMark", "false");
            symbolizer.setGraphic(graphic);
        }
        if (this.labelPriority != null) {
            symbolizer.setPriority((Expression)this.ff.literal((Object)this.labelPriority));
        }
        symbolizers.add(symbolizer);
        MBFilter filter = this.getFilter();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        Rule rule = this.sf.rule(this.getId(), null, null, 0.0, Double.POSITIVE_INFINITY, symbolizers, filter.filter());
        rules.add(rule);
        return Collections.singletonList(this.sf.featureTypeStyle(this.getId(), (Description)this.sf.description(Text.text((String)("MBStyle " + this.getId())), Text.text((String)("Generated for " + this.getSourceLayer()))), null, Collections.emptySet(), filter.semanticTypeIdentifiers(), rules));
    }

    private Graphic getGraphic(MBStyleTransformer transformer, MBStyle styleContext) {
        ExternalGraphic gs;
        Expression iconExpression = this.iconImage();
        if (iconExpression instanceof Literal) {
            iconExpression = transformer.cqlExpressionFromTokens((String)iconExpression.evaluate(null, String.class));
        }
        Multiply graphicSize = null;
        String spriteSheetLocation = styleContext.getSprite() == null ? "" : styleContext.getSprite().trim().toLowerCase();
        Expression iconSize = this.iconSize();
        if (MARK_SHEET_ALIASES.contains(spriteSheetLocation)) {
            org.geotools.styling.Fill f = this.sf.fill(null, this.iconColor(), null);
            Stroke s = this.sf.stroke(this.iconColor(), null, null, null, null, null, null);
            gs = this.sf.mark(iconExpression, (Fill)f, (org.opengis.style.Stroke)s);
        } else {
            gs = transformer.createExternalGraphicForSprite(iconExpression, iconSize, styleContext);
        }
        if (gs instanceof Mark) {
            graphicSize = this.ff.multiply((Expression)this.ff.literal(32), iconSize);
        }
        Graphic g = this.sf.graphic(Arrays.asList(gs), this.iconOpacity(), (Expression)graphicSize, this.iconRotate(), null, null);
        Displacement d = this.iconOffsetDisplacement();
        d.setDisplacementY((Expression)this.ff.multiply(iconSize, (Expression)this.ff.multiply((Expression)this.ff.literal(-1), d.getDisplacementY())));
        d.setDisplacementX((Expression)this.ff.multiply(iconSize, d.getDisplacementX()));
        g.setDisplacement((org.opengis.style.Displacement)d);
        g.setAnchorPoint((AnchorPoint)this.iconAnchorPoint());
        return g;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public Integer getLabelPriority() {
        return this.labelPriority;
    }

    public void setLabelPriority(Integer labelPriority) {
        this.labelPriority = labelPriority;
    }

    public static enum TranslateAnchor {
        MAP,
        VIEWPORT;

    }

    public static enum TextTransform {
        NONE,
        UPPERCASE,
        LOWERCASE;

    }

    public static enum TextAnchor {
        CENTER(0.5, 0.5),
        LEFT(0.0, 0.5),
        RIGHT(1.0, 0.5),
        TOP(0.5, 1.0),
        BOTTOM(0.5, 0.0),
        TOP_LEFT(0.0, 1.0),
        TOP_RIGHT(1.0, 1.0),
        BOTTOM_LEFT(0.0, 0.0),
        BOTTOM_RIGHT(1.0, 0.0);

        private final double x;
        private final double y;

        private TextAnchor(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public static TextAnchor parse(String jsonString) {
            if (jsonString == null) {
                return CENTER;
            }
            String name = jsonString.toUpperCase().trim().replace('-', '_');
            try {
                return TextAnchor.valueOf(name);
            }
            catch (IllegalArgumentException invalid) {
                throw new MBFormatException("Invalid text-alginment '" + jsonString + "' expected one ofcenter, left, right, top, bottom, top-left, top-right, bottom-left, bottom-right");
            }
        }

        public String json() {
            return this.name().toLowerCase().replace('_', '-');
        }

        public static double getAnchorY(String jsonString) {
            return TextAnchor.parse(jsonString).getY();
        }

        public static double getAnchorX(String jsonString) {
            return TextAnchor.parse(jsonString).getX();
        }
    }

    public static enum Justification {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum IconTextFit {
        NONE,
        WIDTH,
        HEIGHT,
        BOTH;

    }

    public static enum Alignment {
        MAP,
        VIEWPORT,
        AUTO;

    }

    public static enum SymbolPlacement {
        POINT,
        LINE;

    }
}

