/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.source;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.geotools.mbstyle.parse.MBFormatException;
import org.geotools.mbstyle.parse.MBObjectParser;
import org.geotools.mbstyle.source.MBSource;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class MediaMBSource
extends MBSource {
    public MediaMBSource(JSONObject json) {
        this(json, null);
    }

    public MediaMBSource(JSONObject json, MBObjectParser parser) {
        super(json, parser);
    }

    public List<Point2D.Double> getCoordinates() {
        JSONArray arr = this.parser.getJSONArray(this.json, "coordinates");
        if (arr.size() != 4) {
            throw new MBFormatException("image/video/canvas source \"coordinates\" tag requires JSONArray of size 4");
        }
        ArrayList<Point2D.Double> coords = new ArrayList<Point2D.Double>();
        for (Object o : arr) {
            if (o instanceof JSONArray) {
                coords.add(this.parsePoint((JSONArray)o));
                continue;
            }
            throw new MBFormatException("image/video/canvas source \"coordinates\" values must be JSONArrays");
        }
        return coords;
    }

    private Double parseDouble(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            return Double.valueOf((String)o);
        }
        throw new MBFormatException("image/video/canvas source \"coordinates\" tags must contain Numbers");
    }

    private Point2D.Double parsePoint(JSONArray arr) {
        if (arr == null || arr.size() != 2) {
            throw new MBFormatException("image/video/canvas source \"coordinates\" tags must each be JSONArray of size 2");
        }
        Double x = this.parseDouble(arr.get(0));
        Double y = this.parseDouble(arr.get(1));
        return new Point2D.Double(x, y);
    }
}

