/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.expression;

import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.mbstyle.expression.MBExpression;
import org.geotools.mbstyle.parse.MBFormatException;
import org.json.simple.JSONArray;

public class MBMath
extends MBExpression {
    public MBMath(JSONArray json) {
        super(json);
    }

    public Expression mathSubtract() {
        Expression e1 = this.parse.string(this.json, 1);
        Expression e2 = this.parse.string(this.json, 2);
        return this.ff.subtract(e1, e2);
    }

    public Expression mathMultiply() {
        Expression first = this.parse.string(this.json, 1);
        Multiply multiplyFunction = this.ff.multiply(first, (Expression)this.ff.literal(1));
        for (int i = 2; i < this.json.size(); ++i) {
            Expression next = this.parse.string(this.json, i);
            multiplyFunction = this.ff.multiply((Expression)multiplyFunction, next);
        }
        return multiplyFunction;
    }

    public Expression mathDivide() {
        Expression e1 = this.parse.string(this.json, 1);
        Expression e2 = this.parse.string(this.json, 2);
        return this.ff.divide(e1, e2);
    }

    public Expression mathRemainder() {
        Expression e1 = this.parse.string(this.json, 1);
        Expression e2 = this.parse.string(this.json, 2);
        return this.ff.function("remainder", new Expression[]{e1, e2});
    }

    public Expression mathExponent() {
        Expression e1 = this.parse.string(this.json, 1);
        Expression e2 = this.parse.string(this.json, 2);
        return this.ff.function("pow", new Expression[]{e1, e2});
    }

    public Expression mathAdd() {
        Expression first = this.parse.string(this.json, 1);
        Add sumFunction = this.ff.add(first, (Expression)this.ff.literal(0));
        for (int i = 2; i < this.json.size(); ++i) {
            Expression next = this.parse.string(this.json, i);
            sumFunction = this.ff.add((Expression)sumFunction, next);
        }
        return sumFunction;
    }

    public Expression mathAcos() {
        Expression e1 = this.parse.string(this.json, 1);
        return this.ff.function("acos", new Expression[]{e1});
    }

    public Expression mathAsin() {
        Expression e1 = this.parse.string(this.json, 1);
        return this.ff.function("asin", new Expression[]{e1});
    }

    public Expression mathAtan() {
        Expression e1 = this.parse.string(this.json, 1);
        return this.ff.function("atan", new Expression[]{e1});
    }

    public Expression mathCos() {
        Expression e1 = this.parse.string(this.json, 1);
        return this.ff.function("cos", new Expression[]{e1});
    }

    public Expression mathE() {
        return this.ff.literal(Math.E);
    }

    public Expression mathLn() {
        Expression e1 = this.parse.string(this.json, 1);
        return this.ff.function("log", new Expression[]{e1});
    }

    public Expression mathLn2() {
        return this.ff.literal(Math.log(2.0));
    }

    public Expression mathLog10() {
        Expression e1 = this.parse.string(this.json, 1);
        return this.ff.divide((Expression)this.ff.function("log", new Expression[]{e1}), (Expression)this.ff.function("log", new Expression[]{this.ff.literal(10)}));
    }

    public Expression mathLog2() {
        Expression e1 = this.parse.string(this.json, 1);
        return this.ff.divide((Expression)this.ff.function("log", new Expression[]{e1}), (Expression)this.ff.function("log", new Expression[]{this.ff.literal(2)}));
    }

    public Expression mathMax() {
        Expression first = this.parse.string(this.json, 1);
        Function maxFunction = this.ff.function("max", new Expression[]{first, first});
        for (int i = 2; i < this.json.size(); ++i) {
            Expression next = this.parse.string(this.json, i);
            maxFunction = this.ff.function("max", new Expression[]{maxFunction, next});
        }
        return maxFunction;
    }

    public Expression mathMin() {
        Expression first = this.parse.string(this.json, 1);
        Function minFunction = this.ff.function("min", new Expression[]{first, first});
        for (int i = 2; i < this.json.size(); ++i) {
            Expression next = this.parse.string(this.json, i);
            minFunction = this.ff.function("min", new Expression[]{minFunction, next});
        }
        return minFunction;
    }

    public Expression mathPi() {
        return this.ff.function("pi", new Expression[0]);
    }

    public Expression mathSin() {
        Expression e1 = this.parse.string(this.json, 1);
        return this.ff.function("sin", new Expression[]{e1});
    }

    public Expression mathSqrt() {
        Expression e1 = this.parse.string(this.json, 1);
        return this.ff.function("sqrt", new Expression[]{e1});
    }

    public Expression mathTan() {
        Expression e1 = this.parse.string(this.json, 1);
        return this.ff.function("tan", new Expression[]{e1});
    }

    @Override
    public Expression getExpression() throws MBFormatException {
        switch (this.name) {
            case "-": {
                return this.mathSubtract();
            }
            case "*": {
                return this.mathMultiply();
            }
            case "/": {
                return this.mathDivide();
            }
            case "%": {
                return this.mathRemainder();
            }
            case "^": {
                return this.mathExponent();
            }
            case "+": {
                return this.mathAdd();
            }
            case "acos": {
                return this.mathAcos();
            }
            case "asin": {
                return this.mathAsin();
            }
            case "atan": {
                return this.mathAtan();
            }
            case "cos": {
                return this.mathCos();
            }
            case "e": {
                return this.mathE();
            }
            case "ln": {
                return this.mathLn();
            }
            case "ln2": {
                return this.mathLn2();
            }
            case "log10": {
                return this.mathLog10();
            }
            case "log2": {
                return this.mathLog2();
            }
            case "max": {
                return this.mathMax();
            }
            case "min": {
                return this.mathMin();
            }
            case "pi": {
                return this.mathPi();
            }
            case "sin": {
                return this.mathSin();
            }
            case "sqrt": {
                return this.mathSqrt();
            }
            case "tan": {
                return this.mathTan();
            }
        }
        throw new MBFormatException(this.name + " is an unsupported math expression");
    }
}

