/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.sprite;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.geotools.api.feature.Feature;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.ows.URLCheckers;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFinder;
import org.geotools.http.HTTPResponse;
import org.geotools.image.io.ImageIOExt;
import org.geotools.mbstyle.sprite.MBSpriteException;
import org.geotools.mbstyle.sprite.SpriteIndex;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.geotools.renderer.style.GraphicCache;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SpriteGraphicFactory
implements ExternalGraphicFactory,
GraphicCache {
    public static final String FORMAT = "mbsprite";
    final JSONParser jsonParser = new JSONParser();
    protected static final Map<URL, BufferedImage> imageCache = Collections.synchronizedMap(new SoftValueHashMap());
    protected static final Map<URL, SpriteIndex> indexCache = Collections.synchronizedMap(new SoftValueHashMap());
    private static final Logger LOGGER = Logging.getLogger(SpriteGraphicFactory.class);
    private static final String ICON_NAME_DELIMITER = "#";

    public Icon getIcon(Feature feature, Expression url, String format, int size) throws Exception {
        Double sizeMultiplier;
        if (!FORMAT.equalsIgnoreCase(format.trim())) {
            return null;
        }
        URL loc = (URL)url.evaluate((Object)feature, URL.class);
        URL baseUrl = SpriteGraphicFactory.parseBaseUrl(loc);
        URLCheckers.confirm((URL)loc);
        Map<String, String> paramsMap = SpriteGraphicFactory.parseFragmentParams(loc);
        String iconName = paramsMap.get("icon");
        String sizeStr = paramsMap.get("size");
        sizeStr = sizeStr == null ? "1.0" : sizeStr;
        try {
            sizeMultiplier = Double.parseDouble(sizeStr);
            if (sizeMultiplier < 0.0) {
                sizeMultiplier = 1.0;
            }
        }
        catch (NumberFormatException e) {
            throw new MBSpriteException("Exception parsing size parameter from Sprite External Graphic URL. URL was: " + loc, e);
        }
        SpriteIndex spriteIndex = this.getSpriteIndex(baseUrl);
        SpriteIndex.IconInfo iconInfo = spriteIndex.getIcon(iconName);
        BufferedImage spriteImg = this.getSpriteSheet(baseUrl);
        BufferedImage iconSubImg = spriteImg.getSubimage(iconInfo.getX(), iconInfo.getY(), iconInfo.getWidth(), iconInfo.getHeight());
        if (size > 0 && iconSubImg.getHeight() != size) {
            double scaleY;
            double scaleX = scaleY = (double)size / (double)iconSubImg.getHeight();
            AffineTransform scaleTx = AffineTransform.getScaleInstance(scaleX, scaleY);
            AffineTransformOp ato = new AffineTransformOp(scaleTx, 2);
            iconSubImg = ato.filter(iconSubImg, null);
        }
        if (sizeMultiplier != 1.0) {
            AffineTransform scaleTx = AffineTransform.getScaleInstance(sizeMultiplier, sizeMultiplier);
            AffineTransformOp ato = new AffineTransformOp(scaleTx, 2);
            iconSubImg = ato.filter(iconSubImg, null);
        }
        return new ImageIcon(iconSubImg);
    }

    protected static Map<String, String> parseFragmentParams(URL url) {
        String urlStr = url.toExternalForm();
        int fragmentIdx = urlStr.indexOf(ICON_NAME_DELIMITER);
        if (fragmentIdx == -1) {
            throw new IllegalArgumentException("Sprite external graphics must have url with fragment of the form #icon=test&size=1.5. URL was: " + urlStr);
        }
        String fragment = urlStr.substring(fragmentIdx + 1);
        if (fragment.trim().length() == 0) {
            throw new IllegalArgumentException("Sprite external graphics must have url with non-empty fragment of the form #icon=test&size=1.5. URL was: " + urlStr);
        }
        String[] nvps = fragment.split("&");
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        for (String s : nvps) {
            try {
                String[] nvp = s.split("=");
                if (nvp.length == 1 && nvps.length == 1) {
                    paramsMap.put("icon", URLDecoder.decode(nvp[0], "utf-8"));
                    continue;
                }
                String k = URLDecoder.decode(nvp[0], "utf-8").trim().toLowerCase();
                String v = URLDecoder.decode(nvp[1], "utf-8");
                paramsMap.put(k, v);
            }
            catch (UnsupportedEncodingException uee) {
                throw new MBSpriteException("Exception decoding URL fragment for external graphic URL. URL was: " + urlStr, uee);
            }
        }
        if (paramsMap.get("icon") == null || ((String)paramsMap.get("icon")).trim().isEmpty()) {
            throw new IllegalArgumentException("Sprite external graphics must provide an icon name using a URL fragment of the form #icon=test&size=1.5 . URL was: " + urlStr);
        }
        return paramsMap;
    }

    protected static String parseIconName(URL url) {
        String urlStr = url.toExternalForm();
        if (!urlStr.contains(ICON_NAME_DELIMITER)) {
            throw new IllegalArgumentException("Mapbox-style sprite external graphics must have url#{iconName}. URL was: " + urlStr);
        }
        String[] splitStr = url.toExternalForm().split(ICON_NAME_DELIMITER);
        String iconName = splitStr[splitStr.length - 1];
        if (iconName.trim().length() == 0) {
            throw new IllegalArgumentException("Mapbox-style sprite external graphics must have non-empty url#{iconName}. URL was: " + urlStr);
        }
        return iconName;
    }

    protected static URL parseBaseUrl(URL loc) throws MalformedURLException {
        String urlStr = loc.toExternalForm();
        int idx = urlStr.indexOf(ICON_NAME_DELIMITER);
        if (idx == -1) {
            return new URL(urlStr);
        }
        return new URL(urlStr.substring(0, idx));
    }

    protected SpriteIndex getSpriteIndex(URL baseUrl) throws IOException {
        SpriteIndex spriteIndex;
        block9: {
            spriteIndex = indexCache.get(baseUrl);
            if (spriteIndex == null) {
                String indexUrlStr = baseUrl.toExternalForm() + ".json";
                URL url = new URL(indexUrlStr);
                HTTPClient client = this.getHttpClient();
                HTTPResponse response = client.get(url);
                String charset = Optional.ofNullable(response.getResponseCharset()).orElse("UTF-8");
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.getResponseStream(), charset));){
                    Object parsed = this.jsonParser.parse((Reader)reader);
                    if (parsed instanceof JSONObject) {
                        spriteIndex = new SpriteIndex(indexUrlStr, (JSONObject)parsed);
                        indexCache.put(baseUrl, spriteIndex);
                        break block9;
                    }
                    throw new MBSpriteException("Exception parsing sprite index file from: " + indexUrlStr + ". Expected JSONObject, but was: " + parsed.getClass().getSimpleName());
                }
                catch (ParseException e) {
                    throw new MBSpriteException("Exception parsing sprite index file from: " + indexUrlStr, e);
                }
            }
        }
        return spriteIndex;
    }

    protected HTTPClient getHttpClient() {
        return HTTPClientFinder.createClient();
    }

    private BufferedImage getSpriteSheet(URL baseUrl) {
        BufferedImage image = imageCache.get(baseUrl);
        if (image == null) {
            HTTPClient client = this.getHttpClient();
            try (InputStream is = client.get(new URL(baseUrl.toExternalForm() + ".png")).getResponseStream();){
                image = ImageIOExt.readBufferedImage((Object)is);
            }
            catch (Exception e) {
                LOGGER.warning("Unable to retrieve sprite sheet from location: " + baseUrl.toExternalForm() + " (" + e.getMessage() + ")");
                throw new MBSpriteException("Failed to retrieve sprite sheet for baseUrl: " + baseUrl.toExternalForm(), e);
            }
            imageCache.put(baseUrl, image);
        }
        return image;
    }

    public void clearCache() {
        imageCache.clear();
        indexCache.clear();
    }
}

