/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.mbstyle.MBStyle;
import org.geotools.mbstyle.layer.MBLayer;
import org.geotools.mbstyle.parse.MBFormatException;
import org.geotools.mbstyle.parse.MBStyleParser;
import org.json.simple.parser.ParseException;

public class MapBoxStyle {
    public static StyledLayerDescriptor parse(Reader reader) throws IOException, ParseException {
        MBStyleParser parser = new MBStyleParser();
        MBStyle style = parser.parse(reader);
        StyledLayerDescriptor sld = style.transform();
        return sld;
    }

    public static StyledLayerDescriptor parse(InputStream stream) throws IOException, ParseException {
        MBStyleParser parser = new MBStyleParser();
        MBStyle style = parser.parse(stream);
        StyledLayerDescriptor sld = style.transform();
        return sld;
    }

    public static List<Exception> validate(Reader reader) {
        MBStyle style;
        ArrayList<Exception> problems = new ArrayList<Exception>();
        MBStyleParser parser = new MBStyleParser();
        try {
            style = parser.parse(reader);
        }
        catch (Exception invalid) {
            problems.add(invalid);
            return problems;
        }
        List<Object> layers = Collections.emptyList();
        try {
            layers = style.layers();
            if (layers.isEmpty()) {
                problems.add(new MBFormatException("No layers defined"));
            }
        }
        catch (MBFormatException layersUnavailable) {
            problems.add(layersUnavailable);
        }
        boolean hasVisibleLayer = false;
        for (MBLayer mBLayer : layers) {
            if (!mBLayer.visibility()) continue;
            try {
                List<FeatureTypeStyle> featureTypeStyle = mBLayer.transform(style);
                if (featureTypeStyle == null) continue;
                hasVisibleLayer = true;
            }
            catch (Exception invalid) {
                problems.add(new MBFormatException("Layer " + mBLayer.getId() + ":" + invalid.getMessage(), invalid));
                return problems;
            }
        }
        if (!hasVisibleLayer) {
            problems.add(new MBFormatException("No layers were visible"));
        } else {
            try {
                StyledLayerDescriptor sld = style.transform();
                if (sld.getStyledLayers().length == 0) {
                    problems.add(new MBFormatException("Generated sld for " + sld.getName() + " is empty."));
                } else {
                    for (StyledLayer layer : sld.getStyledLayers()) {
                        if (!(layer instanceof NamedLayer)) continue;
                        MapBoxStyle.validateLayer(problems, (NamedLayer)layer);
                    }
                }
            }
            catch (MBFormatException invalid) {
                problems.add(invalid);
            }
            catch (Exception problem) {
                problems.add(new MBFormatException("Style " + style.getName() + ":" + problem.getMessage(), problem));
            }
        }
        return problems;
    }

    private static void validateLayer(List<Exception> problems, NamedLayer layer) {
        NamedLayer named = layer;
        if (named.styles().isEmpty()) {
            problems.add(new MBFormatException("Generated named layer for " + named.getName() + " is empty."));
        } else {
            for (Style layerStyle : named.styles()) {
                FeatureTypeStyle fts;
                if (!(layerStyle instanceof FeatureTypeStyle) || !(fts = (FeatureTypeStyle)layerStyle).rules().isEmpty()) continue;
                problems.add(new MBFormatException("Generated feature type style " + fts.getName() + " is empty."));
            }
        }
    }
}

