/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.parse;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.function.BiFunction;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.mbstyle.parse.MBArrayStop;
import org.geotools.mbstyle.parse.MBFormatException;
import org.geotools.mbstyle.parse.MBObjectParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class MBFunction {
    protected final MBObjectParser parse;
    protected final JSONObject json;
    private final FilterFactory ff;
    final JSONParser parser = new JSONParser();

    public MBFunction(JSONObject json) {
        this(new MBObjectParser(MBFunction.class), json);
    }

    public MBFunction(MBObjectParser parse, JSONObject json) {
        this.parse = parse;
        this.ff = parse.getFilterFactory();
        this.json = json;
    }

    public FunctionType getType() {
        String type = this.parse.get(this.json, "type", null);
        if (type == null) {
            return null;
        }
        switch (type) {
            case "identity": {
                return FunctionType.IDENTITY;
            }
            case "exponential": {
                return FunctionType.EXPONENTIAL;
            }
            case "interval": {
                return FunctionType.INTERVAL;
            }
            case "categorical": {
                return FunctionType.CATEGORICAL;
            }
        }
        throw new MBFormatException("Function type \"" + type + "\" invalid - expected identity, exponential, interval, categorical");
    }

    public Object getDefault() {
        if (this.json == null || !this.json.containsKey((Object)"default")) {
            return null;
        }
        return this.json.get((Object)"default");
    }

    public FunctionType getTypeWithDefault(Class<?> clazz) {
        FunctionType declaredType = this.getType();
        if (declaredType != null) {
            return declaredType;
        }
        if (Color.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz)) {
            return FunctionType.EXPONENTIAL;
        }
        return FunctionType.INTERVAL;
    }

    public String getProperty() {
        return this.parse.optional(String.class, this.json, "property", null);
    }

    public EnumSet<FunctionCategory> category() {
        String property = this.getProperty();
        JSONArray stops = this.getStops();
        if (property != null && stops == null) {
            return EnumSet.of(FunctionCategory.PROPERTY);
        }
        JSONArray first = this.parse.jsonArray(stops.get(0));
        if (property == null) {
            return EnumSet.of(FunctionCategory.ZOOM);
        }
        if (first.get(0) instanceof JSONObject) {
            return EnumSet.of(FunctionCategory.ZOOM, FunctionCategory.PROPERTY);
        }
        return EnumSet.of(FunctionCategory.PROPERTY);
    }

    public JSONArray getStops() {
        return this.parse.getJSONArray(this.json, "stops", null);
    }

    public Number getBase() {
        return this.parse.optional(Number.class, this.json, "base", 1);
    }

    private Expression input() {
        EnumSet<FunctionCategory> category = this.category();
        if (category.containsAll(EnumSet.of(FunctionCategory.ZOOM, FunctionCategory.PROPERTY))) {
            throw new IllegalStateException("Reduce zoom and property function prior to use.");
        }
        if (category.contains((Object)FunctionCategory.ZOOM)) {
            return this.ff.function("zoomLevel", new Expression[]{this.ff.function("env", new Expression[]{this.ff.literal((Object)"wms_scale_denominator")}), this.ff.literal((Object)"EPSG:3857")});
        }
        return this.ff.property(this.getProperty());
    }

    public Expression color() {
        Expression value = this.input();
        FunctionType type = this.getTypeWithDefault(Color.class);
        if (type == FunctionType.EXPONENTIAL) {
            double base = this.parse.optional(Double.class, this.json, "base", 1.0);
            if (base == 1.0) {
                return this.colorGenerateInterpolation(value);
            }
            return this.colorGenerateExponential(value, base);
        }
        if (type == null || type == FunctionType.CATEGORICAL) {
            return this.colorGenerateRecode(value);
        }
        if (type == FunctionType.INTERVAL) {
            return this.colorGenerateCategorize(value);
        }
        if (type == FunctionType.IDENTITY) {
            return this.withFallback((Expression)this.ff.function("css", new Expression[]{value}));
        }
        throw new UnsupportedOperationException("Color unavailable for '" + type + "' function");
    }

    private Expression colorGenerateCategorize(Expression expression) {
        return this.generateCategorize(expression, (value, stop) -> {
            Literal color = this.parse.color((String)value);
            if (color == null) {
                throw new MBFormatException("Could not convert stop " + stop + " color " + value + " into a color");
            }
            return color;
        });
    }

    private Expression colorGenerateRecode(Expression input) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(input);
        for (Object obj : this.getStops()) {
            JSONArray entry = this.parse.jsonArray(obj);
            Object stop = entry.get(0);
            Object value = entry.get(1);
            Literal color = this.parse.color((String)value);
            if (color == null) {
                throw new MBFormatException("Could not convert stop " + stop + " color " + value + " into a color");
            }
            parameters.add(this.ff.literal(stop));
            parameters.add(color);
        }
        return this.withFallback((Expression)this.ff.function("Recode", parameters.toArray(new Expression[parameters.size()])));
    }

    private Expression colorGenerateInterpolation(Expression expression) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(expression);
        for (Object obj : this.getStops()) {
            JSONArray entry = this.parse.jsonArray(obj);
            Object stop = entry.get(0);
            Object value = entry.get(1);
            Literal color = this.parse.color((String)value);
            if (color == null) {
                throw new MBFormatException("Could not convert stop " + stop + " color " + value + " into a color");
            }
            parameters.add(this.ff.literal(stop));
            parameters.add(color);
        }
        parameters.add(this.ff.literal((Object)"color"));
        return this.withFallback((Expression)this.ff.function("Interpolate", parameters.toArray(new Expression[parameters.size()])));
    }

    private Expression colorGenerateExponential(Expression expression, double base) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(expression);
        parameters.add(this.ff.literal(base));
        for (Object obj : this.getStops()) {
            JSONArray entry = this.parse.jsonArray(obj);
            Object stop = entry.get(0);
            Object value = entry.get(1);
            Literal color = this.parse.color((String)value);
            if (color == null) {
                throw new MBFormatException("Could not convert stop " + stop + " color " + value + " into a color");
            }
            parameters.add(this.ff.literal(stop));
            parameters.add(color);
        }
        return this.withFallback((Expression)this.ff.function("Exponential", parameters.toArray(new Expression[parameters.size()])));
    }

    public Expression font() {
        Expression input = this.input();
        return this.fontGenerateCategorize(input);
    }

    private Expression fontGenerateCategorize(Expression expression) {
        return this.generateCategorize(expression, (value, stop) -> {
            Literal font = this.parse.ff.literal(((JSONArray)value).get(0));
            if (font == null) {
                throw new MBFormatException("Could not convert stop " + stop + " font " + value + " into a font");
            }
            return font;
        });
    }

    public Expression numeric() {
        Expression input = this.input();
        FunctionType type = this.getTypeWithDefault(Number.class);
        if (type == FunctionType.EXPONENTIAL) {
            double base = this.parse.optional(Double.class, this.json, "base", 1.0);
            if (base == 1.0) {
                return this.numericGenerateInterpolation(input);
            }
            return this.numericGenerateExponential(input, base);
        }
        if (type == FunctionType.CATEGORICAL) {
            return this.generateRecode(input);
        }
        if (type == FunctionType.INTERVAL) {
            return this.generateCategorize(input);
        }
        if (type == FunctionType.IDENTITY) {
            return this.withFallback(input);
        }
        throw new UnsupportedOperationException("Numeric unavailable for '" + type + "' function");
    }

    private Expression numericGenerateInterpolation(Expression input) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(input);
        for (Object obj : this.getStops()) {
            JSONArray entry = this.parse.jsonArray(obj);
            Object stop = entry.get(0);
            Object value = entry.get(1);
            if (!(value instanceof Number)) {
                throw new MBFormatException("Could not convert stop " + stop + " color " + value + " into a numeric");
            }
            parameters.add(this.ff.literal(stop));
            parameters.add(this.ff.literal(value));
        }
        parameters.add(this.ff.literal((Object)"numeric"));
        return this.withFallback((Expression)this.ff.function("Interpolate", parameters.toArray(new Expression[parameters.size()])));
    }

    private Expression numericGenerateExponential(Expression input, double base) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(input);
        parameters.add(this.ff.literal(base));
        for (Object obj : this.getStops()) {
            JSONArray entry = this.parse.jsonArray(obj);
            Object stop = entry.get(0);
            Object value = entry.get(1);
            if (!(value instanceof Number)) {
                throw new MBFormatException("Could not convert stop " + stop + " color " + value + " into a numeric");
            }
            parameters.add(this.ff.literal(stop));
            parameters.add(this.ff.literal(value));
        }
        return this.withFallback((Expression)this.ff.function("Exponential", parameters.toArray(new Expression[parameters.size()])));
    }

    public Expression function(Class<?> clazz) {
        if (clazz.isAssignableFrom(Color.class)) {
            return this.color();
        }
        if (clazz.isAssignableFrom(Number.class)) {
            return this.numeric();
        }
        if (clazz.isAssignableFrom(Enum.class)) {
            return this.enumeration(clazz);
        }
        Expression input = this.input();
        FunctionType type = this.getTypeWithDefault(clazz);
        if (type == null || type == FunctionType.INTERVAL) {
            return this.generateCategorize(input);
        }
        if (type == FunctionType.CATEGORICAL) {
            return this.generateRecode(input);
        }
        if (type == FunctionType.IDENTITY) {
            return this.withFallback(input);
        }
        throw new UnsupportedOperationException("Function unavailable for '" + type + "' function with " + clazz.getSimpleName());
    }

    private Expression generateCategorize(Expression expression) {
        return this.generateCategorize(expression, (value, stop) -> this.ff.literal(value));
    }

    private Expression withFallback(Expression expression) {
        Object defaultValue = this.getDefault();
        if (defaultValue != null) {
            return this.ff.function("DefaultIfNull", new Expression[]{expression, this.ff.literal(defaultValue)});
        }
        return expression;
    }

    private Expression generateCategorize(Expression expression, BiFunction<Object, Object, Expression> parseValue) {
        JSONArray stopsJson = this.getStops();
        ArrayList<Object> parameters = new ArrayList<Object>(stopsJson.size() * 2 + 3);
        parameters.add(expression);
        for (int i = 0; i < stopsJson.size(); ++i) {
            JSONArray entry = this.parse.jsonArray(stopsJson.get(i));
            Object stop = entry.get(0);
            Expression value = parseValue.apply(entry.get(1), stop);
            if (i == 0) {
                Object defaultValue = this.getDefault();
                Object initialValue = defaultValue != null ? this.ff.literal(defaultValue) : value;
                parameters.add(initialValue);
            }
            parameters.add(this.ff.literal(stop));
            parameters.add(value);
        }
        parameters.add(this.ff.literal((Object)"succeeding"));
        Function categorizeFunction = this.ff.function("Categorize", parameters.toArray(new Expression[parameters.size()]));
        return this.withFallback((Expression)categorizeFunction);
    }

    private Expression generateRecode(Expression input) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(input);
        for (Object obj : this.getStops()) {
            JSONArray entry = this.parse.jsonArray(obj);
            Object stop = entry.get(0);
            Object value = entry.get(1);
            parameters.add(this.ff.literal(stop));
            parameters.add(this.ff.literal(value));
        }
        Function recodeFn = this.ff.function("Recode", parameters.toArray(new Expression[parameters.size()]));
        return this.withFallback((Expression)recodeFn);
    }

    public Expression enumeration(Class<? extends Enum<?>> enumeration) {
        Expression input = this.input();
        FunctionType type = this.getTypeWithDefault(Enumeration.class);
        if (type == FunctionType.INTERVAL) {
            return this.enumGenerateCategorize(input, enumeration);
        }
        if (type == FunctionType.CATEGORICAL) {
            return this.enumGenerateRecode(input, enumeration);
        }
        if (type == FunctionType.IDENTITY) {
            return this.withFallback(this.enumGenerateIdentity(input, enumeration));
        }
        throw new UnsupportedOperationException("Unable to support '" + type + "' function for " + enumeration.getSimpleName());
    }

    private Expression enumGenerateRecode(Expression input, Class<? extends Enum<?>> enumeration) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(input);
        for (Object obj : this.getStops()) {
            JSONArray entry = this.parse.jsonArray(obj);
            Object stop = entry.get(0);
            Object value = entry.get(1);
            parameters.add(this.ff.literal(stop));
            parameters.add(this.parse.constant(value, enumeration));
        }
        return this.withFallback((Expression)this.ff.function("Recode", parameters.toArray(new Expression[parameters.size()])));
    }

    private Expression enumGenerateCategorize(Expression input, Class<? extends Enum<?>> enumeration) {
        return this.withFallback(this.generateCategorize(input, (value, stop) -> this.parse.constant(value, enumeration)));
    }

    private Expression enumGenerateIdentity(Expression input, Class<? extends Enum<?>> enumeration) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(input);
        for (Enum<?> constant : enumeration.getEnumConstants()) {
            String value = constant.name().toLowerCase();
            parameters.add(this.ff.literal((Object)value));
            parameters.add(this.parse.constant(value, enumeration));
        }
        return this.withFallback((Expression)this.ff.function("Recode", parameters.toArray(new Expression[parameters.size()])));
    }

    public boolean isArrayFunction() {
        if (this.getStops() == null) {
            return false;
        }
        for (Object o : this.getStops()) {
            if (!(o instanceof JSONArray)) {
                return false;
            }
            JSONArray stop = (JSONArray)o;
            if (stop.size() == 2 && stop.get(1) instanceof JSONArray) continue;
            return false;
        }
        return true;
    }

    public List<MBFunction> splitArrayFunction() throws ParseException {
        JSONArray arr = this.getStops();
        if (arr.isEmpty()) {
            return Arrays.asList(this);
        }
        ArrayList<MBArrayStop> parsedStops = new ArrayList<MBArrayStop>();
        for (Object o : arr) {
            if (o instanceof JSONArray) {
                parsedStops.add(new MBArrayStop((JSONArray)o));
                continue;
            }
            throw new MBFormatException("Exception handling array function: encountered non-array stop value.");
        }
        int dimensionCount = ((MBArrayStop)parsedStops.get(0)).getStopValueCount();
        boolean allStopsSameDimension = parsedStops.stream().allMatch(stop -> stop.getStopValueCount() == dimensionCount);
        if (!allStopsSameDimension) {
            throw new MBFormatException("Exception handling array function: all stops arrays must have the same length.");
        }
        JSONArray defaultStopValues = null;
        if (this.getDefault() != null) {
            Object def = this.getDefault();
            if (def instanceof JSONArray && ((JSONArray)def).size() == dimensionCount) {
                defaultStopValues = (JSONArray)def;
            } else {
                throw new MBFormatException("Exception handling array function: the default value must also be an array of length " + dimensionCount);
            }
        }
        ArrayList<MBFunction> functions = new ArrayList<MBFunction>();
        for (int i = 0; i < dimensionCount; ++i) {
            Integer n = i;
            JSONArray newStops = new JSONArray();
            for (MBArrayStop stop2 : parsedStops) {
                JSONArray jsonArray = stop2.reducedToIndex(n);
                newStops.add((Object)jsonArray);
            }
            JSONObject newObj = (JSONObject)this.parser.parse(this.json.toJSONString());
            newObj.put((Object)"stops", (Object)newStops);
            if (defaultStopValues != null) {
                newObj.put((Object)"default", defaultStopValues.get(n.intValue()));
            }
            MBFunction reduced = new MBFunction(newObj);
            functions.add(reduced);
        }
        return functions;
    }

    public static enum FunctionCategory {
        PROPERTY,
        ZOOM;

    }

    public static enum FunctionType {
        IDENTITY,
        EXPONENTIAL,
        INTERVAL,
        CATEGORICAL;

    }
}

