/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.StyleFactory;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.mbstyle.MBStyle;
import org.geotools.mbstyle.layer.SymbolMBLayer;
import org.geotools.mbstyle.parse.MBObjectParser;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.styling.StyleBuilder;
import org.geotools.util.logging.Logging;

public class MBStyleTransformer {
    private final FilterFactory ff;
    private final StyleFactory sf;
    private final StyleBuilder sb;
    private final List<String> defaultFonts = new ArrayList<String>();
    protected static final Pattern mapboxTokenPattern = Pattern.compile("\\{(.*?)\\}");
    private static final Logger LOGGER = Logging.getLogger(MBStyleTransformer.class);

    public MBStyleTransformer(MBObjectParser parse) {
        this.defaultFonts.add("Open Sans Regular");
        this.defaultFonts.add("Arial Unicode MS Regular");
        this.ff = parse.getFilterFactory();
        this.sf = parse.getStyleFactory();
        this.sb = new StyleBuilder();
    }

    public ExternalGraphic createExternalGraphicForSprite(Expression iconName, Expression iconSize, MBStyle styleContext) {
        Object spriteUrl;
        String iconNameCql = ECQL.toCQL((Expression)this.ff.function("strURLEncode", new Expression[]{iconName}));
        String iconSizeCql = null;
        if (iconSize != null) {
            iconSizeCql = ECQL.toCQL((Expression)this.ff.function("strURLEncode", new Expression[]{iconSize}));
        }
        if (styleContext != null && styleContext.getSprite() != null) {
            String spriteBase = styleContext.getSprite().trim();
            String fragment = iconSizeCql != null ? "icon=${" + iconNameCql + "}&size=${" + iconSizeCql + "}" : "icon=${" + iconNameCql + "}";
            spriteUrl = spriteBase + "#" + fragment;
        } else {
            spriteUrl = iconNameCql;
        }
        return this.sf.createExternalGraphic((String)spriteUrl, "mbsprite");
    }

    public ExternalGraphic createExternalGraphicForSprite(Expression iconName, MBStyle styleContext) {
        return this.createExternalGraphicForSprite(iconName, (Expression)this.ff.literal((Object)"1"), styleContext);
    }

    AnchorPoint getAnchorPoint(String textAnchor) {
        SymbolMBLayer.TextAnchor anchor = SymbolMBLayer.TextAnchor.parse(textAnchor);
        return this.sb.createAnchorPoint(anchor.getX(), anchor.getY());
    }

    public String cqlStringFromTokens(String tokenStr) {
        Matcher m = mapboxTokenPattern.matcher(tokenStr);
        return m.replaceAll("\\${$1}");
    }

    public Expression cqlExpressionFromTokens(String tokenStr) {
        try {
            return ExpressionExtractor.extractCqlExpressions((String)this.cqlStringFromTokens(tokenStr));
        }
        catch (IllegalArgumentException iae) {
            LOGGER.warning("Exception converting Mapbox token string to CQL expression. Mapbox token string was: \"" + tokenStr + "\". Exception was: " + iae.getMessage());
            return this.ff.literal((Object)tokenStr);
        }
    }

    public static <T> T requireLiteral(Expression expression, Class<T> clazz, T fallback, String propertyName, String layerId) {
        if (expression instanceof Literal) {
            Object value = expression.evaluate(null, clazz);
            if (value != null) {
                return (T)value;
            }
            return fallback;
        }
        LOGGER.warning("Mapbox '" + propertyName + "' property: functions not yet supported for this property, falling back to default value. (layerId = '" + layerId + "')");
        return fallback;
    }

    public List<String> getDefaultFonts() {
        return this.defaultFonts;
    }
}

