/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.function;

import java.awt.Color;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;

class ToStringFunction
extends FunctionExpressionImpl {
    private static final String NULL = "null";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    public static final FunctionName NAME = new FunctionNameImpl("toString", new String[0]);

    ToStringFunction() {
        super(NAME);
    }

    public Object evaluate(Object feature) {
        Object arg0;
        try {
            arg0 = this.getExpression(0).evaluate(feature);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function \"toString\" argument #0 - expected type Object");
        }
        if (arg0 == null) {
            return NULL;
        }
        if (arg0 instanceof Boolean) {
            if (arg0 == Boolean.TRUE) {
                return TRUE;
            }
            if (arg0 == Boolean.FALSE) {
                return FALSE;
            }
        }
        if (arg0 instanceof Number) {
            return String.valueOf(arg0);
        }
        if (arg0 instanceof Color) {
            Color c = (Color)arg0;
            return "rgba(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "," + (double)c.getAlpha() / 255.0 + ")";
        }
        if (arg0 instanceof String) {
            return String.valueOf(arg0);
        }
        return arg0.toString();
    }
}

