/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.layer;

import java.awt.Color;
import java.awt.Point;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Fill;
import org.geotools.api.style.GraphicFill;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.SemanticType;
import org.geotools.api.style.Stroke;
import org.geotools.mbstyle.MBStyle;
import org.geotools.mbstyle.layer.MBLayer;
import org.geotools.mbstyle.parse.MBFilter;
import org.geotools.mbstyle.parse.MBFormatException;
import org.geotools.mbstyle.parse.MBObjectParser;
import org.geotools.mbstyle.transform.MBStyleTransformer;
import org.geotools.measure.Units;
import org.geotools.text.Text;
import org.json.simple.JSONObject;

public class FillMBLayer
extends MBLayer {
    private final JSONObject paint = this.paint();
    private static final String TYPE = "fill";

    public FillMBLayer(JSONObject json) {
        super(json, new MBObjectParser(FillMBLayer.class));
    }

    @Override
    protected SemanticType defaultSemanticType() {
        return SemanticType.POLYGON;
    }

    public Expression getFillAntialias() {
        return this.parse.bool(this.paint, "fill-antialias", true);
    }

    public Number getFillOpacity() throws MBFormatException {
        return this.parse.optional(Double.class, this.paint, "fill-opacity", 1.0);
    }

    public Expression fillOpacity() throws MBFormatException {
        return this.parse.percentage(this.paint, "fill-opacity", 1);
    }

    public Color getFillColor() {
        return this.parse.convertToColor(this.parse.optional(String.class, this.paint, "fill-color", "#000000"));
    }

    public Expression fillColor() {
        return this.parse.color(this.paint, "fill-color", Color.BLACK);
    }

    public Color getFillOutlineColor() {
        if (this.paint.get((Object)"fill-outline-color") != null) {
            return this.parse.convertToColor(this.parse.optional(String.class, this.paint, "fill-outline-color", "#000000"));
        }
        return this.getFillColor();
    }

    public Expression fillOutlineColor() {
        if (this.paint.get((Object)"fill-outline-color") != null) {
            return this.parse.color(this.paint, "fill-outline-color", Color.BLACK);
        }
        return this.fillColor();
    }

    public int[] getFillTranslate() {
        return this.parse.array(this.paint, "fill-translate", new int[]{0, 0});
    }

    public Point fillTranslate() {
        int[] translate = this.getFillTranslate();
        return new Point(translate[0], translate[1]);
    }

    public Displacement fillTranslateDisplacement() {
        return this.parse.displacement(this.paint, "fill-translate", this.sf.displacement((Expression)this.ff.literal(0), (Expression)this.ff.literal(0)));
    }

    public FillTranslateAnchor getFillTranslateAnchor() {
        Object value = this.paint.get((Object)"fill-translate-anchor");
        if (value != null && "viewport".equalsIgnoreCase((String)value)) {
            return FillTranslateAnchor.VIEWPORT;
        }
        return FillTranslateAnchor.MAP;
    }

    public Expression fillPattern() {
        return this.parse.string(this.paint, "fill-pattern", null);
    }

    public boolean hasFillPattern() {
        return this.parse.isDefined(this.paint, "fill-pattern");
    }

    @Override
    public List<FeatureTypeStyle> transformInternal(MBStyle styleContext) {
        Fill fill;
        MBStyleTransformer transformer = new MBStyleTransformer(this.parse);
        Stroke stroke = this.sf.stroke(this.fillOutlineColor(), this.fillOpacity(), (Expression)this.ff.literal(1), (Expression)this.ff.literal((Object)"miter"), (Expression)this.ff.literal((Object)"butt"), null, null);
        if (this.hasFillPattern()) {
            Object fillPatternExpr = this.fillPattern();
            if (fillPatternExpr instanceof Literal) {
                String text = (String)fillPatternExpr.evaluate(null, String.class);
                fillPatternExpr = text.trim().isEmpty() ? this.ff.literal((Object)" ") : transformer.cqlExpressionFromTokens(text);
            }
            ExternalGraphic eg = transformer.createExternalGraphicForSprite((Expression)fillPatternExpr, styleContext);
            GraphicFill gf = this.sf.graphicFill(Arrays.asList(eg), this.fillOpacity(), null, null, null, this.fillTranslateDisplacement());
            stroke.setOpacity((Expression)this.ff.literal(0));
            fill = this.sf.fill(gf, null, null);
        } else {
            fill = this.sf.fill(null, this.fillColor(), this.fillOpacity());
        }
        PolygonSymbolizer symbolizer = this.sf.polygonSymbolizer(this.getId(), (Expression)this.ff.property((String)null), this.sf.description(Text.text((String)TYPE), null), Units.PIXEL, stroke, fill, this.fillTranslateDisplacement(), (Expression)this.ff.literal(0));
        MBFilter filter = this.getFilter();
        Rule rule = this.sf.rule(this.getId(), null, null, 0.0, Double.POSITIVE_INFINITY, Arrays.asList(symbolizer), filter.filter());
        return Collections.singletonList(this.sf.featureTypeStyle(this.getId(), this.sf.description(Text.text((String)("MBStyle " + this.getId())), Text.text((String)("Generated for " + this.getSourceLayer()))), null, Collections.emptySet(), filter.semanticTypeIdentifiers(), Arrays.asList(rule)));
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public static enum FillTranslateAnchor {
        MAP,
        VIEWPORT;

    }
}

