/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.sprite;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.mbstyle.sprite.MBSpriteException;
import org.geotools.util.logging.Logging;
import org.json.simple.JSONObject;

public class SpriteIndex {
    private final String spriteIndexUrl;
    private final JSONObject json;
    private final Map<String, IconInfo> icons;
    private static final Logger LOGGER = Logging.getLogger(SpriteIndex.class);

    public SpriteIndex(String spriteIndexUrl, JSONObject json) {
        this.spriteIndexUrl = spriteIndexUrl;
        this.json = json;
        this.icons = new HashMap<String, IconInfo>();
        for (Object key : this.json.keySet()) {
            if (!(key instanceof String)) continue;
            String iconName = (String)key;
            try {
                IconInfo iconInfo = SpriteIndex.parseIconInfoFromIndex(this.json, iconName);
                this.icons.put(iconName, iconInfo);
            }
            catch (Exception e) {
                LOGGER.warning("Mapbox sprite icon index file " + this.spriteIndexUrl + " contained invalid value for key \"" + iconName + "\". Exception was: " + e.getMessage());
            }
        }
    }

    protected static IconInfo parseIconInfoFromIndex(JSONObject iconIndex, String iconName) {
        if (!iconIndex.containsKey((Object)iconName)) {
            throw new MBSpriteException("Sprite index file does not contain entry for icon with name: " + iconName);
        }
        Object o = iconIndex.get((Object)iconName);
        if (!(o instanceof JSONObject)) {
            throw new MBSpriteException("Error parsing sprite index for \"" + iconName + "\": Expected JSONObject, but is " + o.getClass().getSimpleName());
        }
        return new IconInfo(iconName, (JSONObject)o);
    }

    public ImmutableMap<String, IconInfo> getIcons() {
        return ImmutableMap.copyOf(this.icons);
    }

    public IconInfo getIcon(String iconName) {
        if (!this.icons.containsKey(iconName)) {
            throw new MBSpriteException("Mapbox sprite icon index file " + this.spriteIndexUrl + " does not contain icon with name: " + iconName);
        }
        return this.icons.get(iconName);
    }

    public static class IconInfo {
        private final String iconName;
        private final JSONObject json;

        public IconInfo(String iconName, JSONObject json) {
            this.iconName = iconName;
            this.json = json;
        }

        public int getWidth() {
            return this.intOrException("width");
        }

        public int getHeight() {
            return this.intOrException("height");
        }

        public int getX() {
            return this.intOrException("x");
        }

        public int getY() {
            return this.intOrException("y");
        }

        public int getPixelRatio() {
            return this.intOrException("pixelRatio");
        }

        private int intOrException(String k) {
            if (!this.json.containsKey((Object)k)) {
                throw new MBSpriteException("Mapbox sprite icon with name \"" + this.iconName + "\" is missing required property: " + k);
            }
            Object o = this.json.get((Object)k);
            try {
                if (o instanceof Number) {
                    return ((Number)o).intValue();
                }
                if (o instanceof String) {
                    return Integer.parseInt((String)o);
                }
                throw new IllegalArgumentException();
            }
            catch (Exception e) {
                throw new MBSpriteException("Mapbox sprite icon with name \"" + this.iconName + "\" contains invalid value for property \"" + k + "\". Expected integer, but was: " + o.getClass().getSimpleName(), e);
            }
        }
    }
}

