/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.mbtiles.ExtractMultiBoundsFilterVisitor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.FactoryException;

public class ExtractMultiBoundsFilterVisitorTest {
    private static final String CRS = "EPSG:404000";
    FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();

    @Test
    public void testBoundsSimple() throws FactoryException {
        BBOX bbox = this.FF.bbox((Expression)this.FF.property(""), -10.0, -10.0, 10.0, 10.0, CRS);
        List bounds = ExtractMultiBoundsFilterVisitor.getBounds((Filter)bbox);
        Assert.assertThat((Object)bounds, (Matcher)Matchers.contains((Object[])new Envelope[]{new Envelope(-10.0, 10.0, -10.0, 10.0)}));
    }

    @Test
    public void testBoundsSeparateOr() throws FactoryException {
        BBOX bbox1 = this.FF.bbox((Expression)this.FF.property(""), -10.0, -10.0, 10.0, 10.0, CRS);
        BBOX bbox2 = this.FF.bbox((Expression)this.FF.property(""), 50.0, -10.0, 60.0, 10.0, CRS);
        List bounds = ExtractMultiBoundsFilterVisitor.getBounds((Filter)this.FF.or((Filter)bbox1, (Filter)bbox2));
        Assert.assertThat((Object)bounds, (Matcher)Matchers.contains((Object[])new Envelope[]{new Envelope(-10.0, 10.0, -10.0, 10.0), new Envelope(50.0, 60.0, -10.0, 10.0)}));
    }

    @Test
    public void testBoundsSeparateAnd() throws FactoryException {
        BBOX bbox1 = this.FF.bbox((Expression)this.FF.property(""), -10.0, -10.0, 10.0, 10.0, CRS);
        BBOX bbox2 = this.FF.bbox((Expression)this.FF.property(""), 50.0, -10.0, 60.0, 10.0, CRS);
        List bounds = ExtractMultiBoundsFilterVisitor.getBounds((Filter)this.FF.and((Filter)bbox1, (Filter)bbox2));
        Assert.assertThat((Object)bounds, (Matcher)Matchers.contains((Object[])new Envelope[]{new Envelope()}));
    }

    @Test
    public void testBoundsSeparateOrIntersect() throws FactoryException {
        BBOX bbox1 = this.FF.bbox((Expression)this.FF.property(""), -10.0, -10.0, 10.0, 10.0, CRS);
        BBOX bbox2 = this.FF.bbox((Expression)this.FF.property(""), 50.0, -10.0, 70.0, 10.0, CRS);
        BBOX bbox3 = this.FF.bbox((Expression)this.FF.property(""), 0.0, -10.0, 60.0, 10.0, CRS);
        List bounds = ExtractMultiBoundsFilterVisitor.getBounds((Filter)this.FF.and((Filter)bbox3, (Filter)this.FF.or((Filter)bbox1, (Filter)bbox2)));
        Assert.assertThat((Object)bounds, (Matcher)Matchers.containsInAnyOrder((Object[])new Envelope[]{new Envelope(0.0, 10.0, -10.0, 10.0), new Envelope(50.0, 60.0, -10.0, 10.0)}));
    }

    @Test
    public void testBoundsSeparateOrIntersectFlipped() throws FactoryException {
        BBOX bbox1 = this.FF.bbox((Expression)this.FF.property(""), -10.0, -10.0, 10.0, 10.0, CRS);
        BBOX bbox2 = this.FF.bbox((Expression)this.FF.property(""), 50.0, -10.0, 70.0, 10.0, CRS);
        BBOX bbox3 = this.FF.bbox((Expression)this.FF.property(""), 0.0, -10.0, 60.0, 10.0, CRS);
        List bounds = ExtractMultiBoundsFilterVisitor.getBounds((Filter)this.FF.and((Filter)this.FF.or((Filter)bbox2, (Filter)bbox1), (Filter)bbox3));
        Assert.assertThat((Object)bounds, (Matcher)Matchers.containsInAnyOrder((Object[])new Envelope[]{new Envelope(0.0, 10.0, -10.0, 10.0), new Envelope(50.0, 60.0, -10.0, 10.0)}));
    }

    @Test
    public void testBoundsMultiOrAnd() throws FactoryException {
        BBOX bbox1 = this.FF.bbox((Expression)this.FF.property(""), -10.0, -10.0, 10.0, 10.0, CRS);
        BBOX bbox2 = this.FF.bbox((Expression)this.FF.property(""), 50.0, -10.0, 70.0, 10.0, CRS);
        BBOX bbox3 = this.FF.bbox((Expression)this.FF.property(""), 0.0, -5.0, 5.0, 5.0, CRS);
        BBOX bbox4 = this.FF.bbox((Expression)this.FF.property(""), 45.0, 5.0, 55.0, 15.0, CRS);
        List bounds = ExtractMultiBoundsFilterVisitor.getBounds((Filter)this.FF.and((Filter)this.FF.or((Filter)bbox2, (Filter)bbox1), (Filter)this.FF.or((Filter)bbox3, (Filter)bbox4)));
        Assert.assertThat((Object)bounds, (Matcher)Matchers.containsInAnyOrder((Object[])new Envelope[]{new Envelope(0.0, 5.0, -5.0, 5.0), new Envelope(50.0, 55.0, 5.0, 10.0)}));
    }
}

