/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.mbtiles.MBTilesFile;
import org.geotools.mbtiles.MBTilesGrid;
import org.geotools.mbtiles.MBTilesMetadata;
import org.geotools.mbtiles.MBTilesTile;
import org.geotools.mbtiles.RectangleLong;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;

public class MBTilesFileTest {
    private static final Logger LOGGER = Logging.getLogger(MBTilesFileTest.class);

    @Test
    public void testMBTilesMetaData() throws IOException {
        MBTilesFile file = new MBTilesFile();
        file.init();
        MBTilesMetadata metadata = new MBTilesMetadata();
        metadata.setName("dummy name");
        metadata.setDescription("dummy description");
        metadata.setVersion("dummy version");
        metadata.setBoundsStr("0,0,100,100");
        metadata.setFormatStr("png");
        metadata.setTypeStr("overlay");
        metadata.setMinZoomStr("0");
        metadata.setMaxZoomStr("5");
        file.saveMetaData(metadata);
        MBTilesMetadata metadata2 = file.loadMetaData();
        Assert.assertEquals((Object)metadata.getName(), (Object)metadata2.getName());
        Assert.assertEquals((Object)metadata.getDescription(), (Object)metadata2.getDescription());
        Assert.assertEquals((Object)metadata.getVersion(), (Object)metadata2.getVersion());
        Assert.assertEquals((Object)metadata.getBounds(), (Object)metadata2.getBounds());
        Assert.assertEquals((Object)metadata.getFormat(), (Object)metadata2.getFormat());
        Assert.assertEquals((Object)metadata.getType(), (Object)metadata2.getType());
        Assert.assertEquals((long)metadata.getMinZoom(), (long)metadata2.getMinZoom());
        Assert.assertEquals((long)metadata.getMaxZoom(), (long)metadata2.getMaxZoom());
        file.close();
    }

    @Test
    public void testMBTilesMetadataJPG() {
        MBTilesMetadata m = new MBTilesMetadata();
        m.setFormatStr("jpg");
    }

    @Test
    public void testMBTilesInitTwice() throws IOException {
        MBTilesFile file = new MBTilesFile();
        file.init();
        file.init();
    }

    @Test
    public void testMBTilesWithoutJournal() throws IOException {
        File temp = File.createTempFile("temp2_", ".mbtiles");
        MBTilesFile file = new MBTilesFile(temp, true);
        file.init();
        final File journal = new File(temp.getAbsolutePath() + "-journal");
        final AtomicLong counter = new AtomicLong(0L);
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    if (!journal.exists()) {
                        continue;
                    }
                    counter.incrementAndGet();
                }
            }
        });
        th.start();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                MBTilesTile tile1 = new MBTilesTile(1L, (long)i, (long)j);
                tile1.setData("dummy data 1".getBytes());
                file.saveTile(tile1);
            }
        }
        try {
            th.interrupt();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        try {
            file.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        try {
            temp.delete();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        Assert.assertTrue((counter.get() == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testMBTilesMinMaxZoomLevelMetaData() throws IOException, SQLException {
        MBTilesFile file = new MBTilesFile();
        file.init();
        file.saveMinMaxZoomMetadata(0, 14);
        MBTilesMetadata metadata = file.loadMetaData();
        Assert.assertEquals((long)0L, (long)metadata.getMinZoom());
        Assert.assertEquals((long)14L, (long)metadata.getMaxZoom());
    }

    @Test
    public void testMBTilesTile() throws IOException, SQLException {
        MBTilesFile file = new MBTilesFile();
        file.init();
        MBTilesTile tile1 = new MBTilesTile(1L, 0L, 0L);
        tile1.setData("dummy data 1".getBytes());
        MBTilesTile tile2 = new MBTilesTile(2L, 0L, 1L);
        tile2.setData("dummy data 2".getBytes());
        file.saveTile(tile1);
        file.saveTile(tile2);
        MBTilesTile testTile = file.loadTile(1L, 0L, 0L);
        Assert.assertTrue((boolean)Arrays.equals(tile1.getData(), testTile.getData()));
        testTile = file.loadTile(2L, 0L, 1L);
        Assert.assertTrue((boolean)Arrays.equals(tile2.getData(), testTile.getData()));
        Assert.assertEquals((long)2L, (long)file.numberOfTiles());
        MBTilesFile.TileIterator it = file.tiles();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertNotNull((Object)it.next());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertNotNull((Object)it.next());
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertEquals((long)1L, (long)file.minZoom());
        Assert.assertEquals((long)2L, (long)file.maxZoom());
        Assert.assertEquals((long)2L, (long)file.closestZoom(5L));
        Assert.assertEquals((long)1L, (long)file.closestZoom(1L));
        Assert.assertEquals((long)0L, (long)file.minColumn(1L));
        Assert.assertEquals((long)0L, (long)file.maxColumn(2L));
        Assert.assertEquals((long)0L, (long)file.minRow(1L));
        Assert.assertEquals((long)1L, (long)file.maxRow(2L));
        file.close();
    }

    @Test
    public void testMBTilesGrid() throws IOException, SQLException {
        MBTilesFile file = new MBTilesFile();
        file.init();
        MBTilesGrid grid1 = new MBTilesGrid(1L, 0L, 0L);
        grid1.setGrid("dummy data 1".getBytes());
        grid1.setGridDataKey("key1", "dummy value1");
        grid1.setGridDataKey("key2", "dummy value2");
        MBTilesGrid grid2 = new MBTilesGrid(2L, 0L, 1L);
        grid2.setGridDataKey("key3", "dummy value3");
        grid2.setGridDataKey("key4", "dummy value4");
        grid2.setGrid("dummy data 2".getBytes());
        file.saveGrid(grid1);
        file.saveGrid(grid2);
        MBTilesGrid testGrid = file.loadGrid(1L, 0L, 0L);
        Assert.assertTrue((boolean)Arrays.equals(grid1.getGrid(), testGrid.getGrid()));
        Assert.assertEquals((Object)grid1.getGridDataKey("key1"), (Object)grid1.getGridDataKey("key1"));
        Assert.assertEquals((Object)grid1.getGridDataKey("key2"), (Object)grid1.getGridDataKey("key2"));
        testGrid = file.loadGrid(2L, 0L, 1L);
        Assert.assertTrue((boolean)Arrays.equals(grid2.getGrid(), testGrid.getGrid()));
        Assert.assertEquals((Object)grid2.getGridDataKey("key3"), (Object)grid2.getGridDataKey("key3"));
        Assert.assertEquals((Object)grid2.getGridDataKey("key4"), (Object)grid2.getGridDataKey("key4"));
    }

    @Test
    public void testMBTilesBounds() throws IOException, SQLException {
        MBTilesFile mbTilesFile = new MBTilesFile(new File("./src/test/resources/org/geotools/mbtiles/madagascar.mbtiles"));
        RectangleLong bounds = mbTilesFile.getTileBounds(7L, true);
        Assert.assertEquals((long)79L, (long)bounds.getMinX());
        Assert.assertEquals((long)82L, (long)bounds.getMaxX());
        Assert.assertEquals((long)54L, (long)bounds.getMinY());
        Assert.assertEquals((long)59L, (long)bounds.getMaxY());
        RectangleLong boundsFull = mbTilesFile.getTileBounds(7L, false);
        Assert.assertEquals((long)0L, (long)boundsFull.getMinX());
        Assert.assertEquals((long)127L, (long)boundsFull.getMaxX());
        Assert.assertEquals((long)0L, (long)boundsFull.getMinY());
        Assert.assertEquals((long)127L, (long)boundsFull.getMaxY());
    }

    @Test
    public void testWorldEnvelopeToTiles() throws IOException, SQLException {
        MBTilesFile mbTilesFile = new MBTilesFile(new File("./src/test/resources/org/geotools/mbtiles/madagascar.mbtiles"));
        RectangleLong bounds = mbTilesFile.toTilesRectangle((Envelope)MBTilesFile.WORLD_ENVELOPE, 7L);
        Assert.assertEquals((long)0L, (long)bounds.getMinX());
        Assert.assertEquals((long)128L, (long)bounds.getMaxX());
        Assert.assertEquals((long)0L, (long)bounds.getMinY());
        Assert.assertEquals((long)128L, (long)bounds.getMaxY());
    }

    @Test
    public void testLocalEnvelopeToTiles() throws IOException, SQLException {
        MBTilesFile mbTilesFile = new MBTilesFile(new File("./src/test/resources/org/geotools/mbtiles/madagascar.mbtiles"));
        ReferencedEnvelope envelope = new ReferencedEnvelope(0.0, 5000000.0, 0.0, 5000000.0, MBTilesFile.SPHERICAL_MERCATOR);
        RectangleLong bounds = mbTilesFile.toTilesRectangle((Envelope)envelope, 7L);
        System.out.println(bounds);
        Assert.assertEquals((long)64L, (long)bounds.getMinX());
        Assert.assertEquals((long)79L, (long)bounds.getMaxX());
        Assert.assertEquals((long)64L, (long)bounds.getMinY());
        Assert.assertEquals((long)79L, (long)bounds.getMaxY());
    }
}

