/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.geotools.mbtiles.MBTilesFile;
import org.geotools.mbtiles.MBTilesMetadata;
import org.geotools.mbtiles.MBTilesTile;
import org.geotools.referencing.CRS;
import org.geotools.util.URLs;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MBTilesFileVectorTileTest {
    File dbfile;

    @Before
    public void setUp() {
        this.dbfile = URLs.urlToFile((URL)MBTilesFileVectorTileTest.class.getResource("planet.mbtiles"));
    }

    @Test
    public void testMBTilesMetaData() throws Exception {
        try (MBTilesFile file = new MBTilesFile(this.dbfile);){
            MBTilesMetadata metadata2 = file.loadMetaData();
            Assert.assertEquals((Object)"osm2vectortiles", (Object)metadata2.getName());
            Assert.assertEquals((Object)"Extract from http://osm2vectortiles.org", (Object)metadata2.getDescription());
            Assert.assertEquals((Object)"2.0", (Object)metadata2.getVersion());
            metadata2.getBounds().getLowerCorner().getCoordinate();
            double delta = 1.0E-4;
            Assert.assertEquals((double)-180.0, (double)metadata2.getBounds().getLowerCorner().getOrdinate(0), (double)delta);
            Assert.assertEquals((double)180.0, (double)metadata2.getBounds().getUpperCorner().getOrdinate(0), (double)delta);
            Assert.assertEquals((double)-85.0511, (double)metadata2.getBounds().getLowerCorner().getOrdinate(1), (double)delta);
            Assert.assertEquals((double)85.0511, (double)metadata2.getBounds().getUpperCorner().getOrdinate(1), (double)delta);
            Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326", (boolean)true), (Object)metadata2.getBounds().getCoordinateReferenceSystem());
            Assert.assertEquals((Object)MBTilesMetadata.t_format.PBF, (Object)metadata2.getFormat());
            Assert.assertEquals((Object)MBTilesMetadata.t_type.BASE_LAYER, (Object)metadata2.getType());
            Assert.assertEquals((long)0L, (long)metadata2.getMinZoom());
            Assert.assertEquals((long)5L, (long)metadata2.getMaxZoom());
        }
    }

    @Test
    public void testMBTilesGetTile() throws Exception {
        byte[] expected;
        try (InputStream is = MBTilesFileVectorTileTest.class.getResourceAsStream("tile_data.pbf.gz");){
            expected = IOUtils.toByteArray((InputStream)is);
        }
        try (MBTilesFile file = new MBTilesFile(this.dbfile);){
            MBTilesTile tile = file.loadTile(0L, 0L, 0L);
            Assert.assertThat((Object)tile.getData(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)tile.getData(), (Matcher)CoreMatchers.equalTo((Object)expected));
        }
    }
}

