/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.geotools.mbtiles.VectorLayerMetadata;
import org.geotools.mbtiles.VectorLayersMetadata;
import org.junit.Assert;
import org.junit.Test;

public class VectorLayersMetadataTest {
    @Test
    public void testParseMetadata() throws Exception {
        String json = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("vectorLayers.json"), (Charset)Charset.forName("UTF-8"));
        VectorLayersMetadata layersMetadata = VectorLayersMetadata.parseMetadata((String)json);
        List layers = layersMetadata.getLayers();
        Assert.assertEquals((long)15L, (long)layers.size());
        VectorLayerMetadata water = (VectorLayerMetadata)layers.get(1);
        Assert.assertEquals((Object)"waterway", (Object)water.getId());
        Assert.assertEquals((Object)0, (Object)water.getMinZoom());
        Assert.assertEquals((Object)14, (Object)water.getMaxZoom());
        Assert.assertEquals((Object)"String", water.getFields().get("class"));
        VectorLayerMetadata mountainPeak = (VectorLayerMetadata)layers.get(4);
        Assert.assertEquals((Object)"mountain_peak", (Object)mountainPeak.getId());
        Assert.assertEquals((Object)0, (Object)mountainPeak.getMinZoom());
        Assert.assertEquals((Object)14, (Object)mountainPeak.getMaxZoom());
        Assert.assertEquals((Object)"Number", mountainPeak.getFields().get("rank"));
    }
}

