/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.geotools.mbtiles.VectorLayerMetadata;

class VectorLayersMetadata {
    static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    @JsonProperty(value="vector_layers")
    List<VectorLayerMetadata> layers = new ArrayList<VectorLayerMetadata>();

    VectorLayersMetadata() {
    }

    static VectorLayersMetadata parseMetadata(String json) throws IOException {
        return (VectorLayersMetadata)MAPPER.readValue(json, VectorLayersMetadata.class);
    }

    public List<VectorLayerMetadata> getLayers() {
        return this.layers;
    }

    public void setLayers(List<VectorLayerMetadata> layers) {
        this.layers = layers;
    }

    public LinkedHashMap<String, VectorLayerMetadata> getLayersMap() {
        return this.layers.stream().collect(Collectors.toMap(l -> l.getId(), l -> l, (l1, l2) -> l1, LinkedHashMap::new));
    }
}

