/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbtiles.mosaic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.mbtiles.MBTilesFile;
import org.geotools.mbtiles.MBTilesMetadata;
import org.geotools.mbtiles.MBTilesTile;
import org.geotools.mbtiles.mosaic.MBTilesFormat;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.opengis.coverage.grid.Format;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MBTilesReader
extends AbstractGridCoverage2DReader {
    static final CoordinateReferenceSystem WGS_84;
    protected static final int DEFAULT_TILE_SIZE = 256;
    protected static final int ZOOM_LEVEL_BASE = 2;
    protected MBTilesMetadata metadata;
    protected ReferencedEnvelope bounds;
    protected File sourceFile;

    public MBTilesReader(Object source, Hints hints) throws IOException {
        this.sourceFile = MBTilesFormat.getFileFromSource(source);
        try (MBTilesFile file = new MBTilesFile(this.sourceFile);){
            long maxZoom;
            this.metadata = file.loadMetaData();
            try {
                this.bounds = ReferencedEnvelope.create((Envelope)this.metadata.getBounds(), (CoordinateReferenceSystem)WGS_84).transform(MBTilesFile.SPHERICAL_MERCATOR, true);
            }
            catch (Exception e) {
                this.bounds = null;
            }
            this.originalEnvelope = new GeneralEnvelope((Envelope)(this.bounds == null ? MBTilesFile.WORLD_ENVELOPE : this.bounds));
            try {
                maxZoom = file.maxZoom();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
            long size = Math.round(Math.pow(2.0, maxZoom)) * 256L;
            this.highestRes = new double[]{MBTilesFile.WORLD_ENVELOPE.getSpan(0) / (double)size, MBTilesFile.WORLD_ENVELOPE.getSpan(1) / (double)size};
            this.originalGridRange = new GridEnvelope2D(new Rectangle((int)size, (int)size));
            this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
            this.crs = MBTilesFile.SPHERICAL_MERCATOR;
        }
    }

    public Format getFormat() {
        return new MBTilesFormat();
    }

    public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        try (MBTilesFile file = new MBTilesFile(this.sourceFile);){
            long topTile;
            long bottomTile;
            long rightTile;
            long leftTile;
            ReferencedEnvelope requestedEnvelope = null;
            Rectangle dim = null;
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    ParameterValue param = (ParameterValue)parameters[i];
                    ReferenceIdentifier name = param.getDescriptor().getName();
                    if (!name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) continue;
                    GridGeometry2D gg = (GridGeometry2D)param.getValue();
                    try {
                        requestedEnvelope = ReferencedEnvelope.create((Envelope)gg.getEnvelope(), (CoordinateReferenceSystem)gg.getCoordinateReferenceSystem()).transform(MBTilesFile.SPHERICAL_MERCATOR, true);
                    }
                    catch (Exception e) {
                        requestedEnvelope = null;
                    }
                    dim = gg.getGridRange2D().getBounds();
                }
            }
            if (requestedEnvelope == null) {
                requestedEnvelope = this.bounds;
            }
            long zoomLevel = 0L;
            if (requestedEnvelope != null && dim != null) {
                double ratioWidth = requestedEnvelope.getSpan(0) / MBTilesFile.WORLD_ENVELOPE.getSpan(0);
                double propWidth = dim.getWidth() / ratioWidth;
                zoomLevel = Math.round(Math.log(propWidth / 256.0) / Math.log(2.0));
            }
            try {
                zoomLevel = file.closestZoom(zoomLevel);
            }
            catch (SQLException e1) {
                throw new IOException(e1);
            }
            long numberOfTiles = Math.round(Math.pow(2.0, zoomLevel));
            double resX = MBTilesFile.WORLD_ENVELOPE.getSpan(0) / (double)numberOfTiles;
            double resY = MBTilesFile.WORLD_ENVELOPE.getSpan(1) / (double)numberOfTiles;
            double offsetX = MBTilesFile.WORLD_ENVELOPE.getMinimum(0);
            double offsetY = MBTilesFile.WORLD_ENVELOPE.getMinimum(1);
            try {
                leftTile = file.minColumn(zoomLevel);
                rightTile = file.maxColumn(zoomLevel);
                bottomTile = file.minRow(zoomLevel);
                topTile = file.maxRow(zoomLevel);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
            if (requestedEnvelope != null) {
                leftTile = Math.max(leftTile, Math.round(Math.floor((requestedEnvelope.getMinimum(0) - offsetX) / resX)));
                bottomTile = Math.max(bottomTile, Math.round(Math.floor((requestedEnvelope.getMinimum(1) - offsetY) / resY)));
                rightTile = Math.max(leftTile, Math.min(rightTile, Math.round(Math.floor((requestedEnvelope.getMaximum(0) - offsetX) / resX))));
                topTile = Math.max(bottomTile, Math.min(topTile, Math.round(Math.floor((requestedEnvelope.getMaximum(1) - offsetY) / resY))));
            }
            int width = (int)(rightTile - leftTile + 1L) * 256;
            int height = (int)(topTile - bottomTile + 1L) * 256;
            ReferencedEnvelope resultEnvelope = new ReferencedEnvelope(offsetX + (double)leftTile * resX, offsetX + (double)(rightTile + 1L) * resX, offsetY + (double)bottomTile * resY, offsetY + (double)(topTile + 1L) * resY, MBTilesFile.SPHERICAL_MERCATOR);
            BufferedImage image = null;
            try (MBTilesFile.TileIterator it = file.tiles(zoomLevel, leftTile, bottomTile, rightTile, topTile);){
                while (it.hasNext()) {
                    MBTilesTile tile = it.next();
                    BufferedImage tileImage = MBTilesReader.readImage(tile.getData(), this.metadata.getFormatStr() == null ? "png" : this.metadata.getFormatStr());
                    if (image == null) {
                        image = this.getStartImage(tileImage, width, height);
                    }
                    int posx = (int)(tile.getTileColumn() - leftTile) * 256;
                    int posy = (int)(topTile - tile.getTileRow()) * 256;
                    image.getRaster().setRect(posx, posy, tileImage.getData());
                }
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
            if (image == null) {
                image = this.getStartImage(width, height);
            }
            GridCoverage2D gridCoverage2D = this.coverageFactory.create((CharSequence)(this.metadata.getName() == null ? "nameless mbtiles" : this.metadata.getName()), (RenderedImage)image, (Envelope)resultEnvelope);
            return gridCoverage2D;
        }
    }

    protected static BufferedImage readImage(byte[] data, String format) throws IOException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(data);){
            BufferedImage bufferedImage;
            block11: {
                ImageInputStream iis = ImageIO.createImageInputStream(bis);
                try {
                    Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(format);
                    ImageReader reader = readers.next();
                    reader.setInput(iis, true);
                    ImageReadParam param = reader.getDefaultReadParam();
                    bufferedImage = reader.read(0, param);
                    if (iis == null) break block11;
                }
                catch (Throwable throwable) {
                    if (iis != null) {
                        try {
                            iis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                iis.close();
            }
            return bufferedImage;
        }
    }

    protected BufferedImage getStartImage(BufferedImage copyFrom, int width, int height) {
        Hashtable<String, Object> properties = null;
        if (copyFrom.getPropertyNames() != null) {
            properties = new Hashtable<String, Object>();
            for (String name : copyFrom.getPropertyNames()) {
                properties.put(name, copyFrom.getProperty(name));
            }
        }
        SampleModel sm = copyFrom.getSampleModel().createCompatibleSampleModel(width, height);
        WritableRaster raster = Raster.createWritableRaster(sm, null);
        BufferedImage image = new BufferedImage(copyFrom.getColorModel(), raster, copyFrom.isAlphaPremultiplied(), properties);
        Graphics2D g2D = (Graphics2D)image.getGraphics();
        Color save = g2D.getColor();
        g2D.setColor(Color.WHITE);
        g2D.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2D.setColor(save);
        return image;
    }

    protected BufferedImage getStartImage(int imageType, int width, int height) {
        if (imageType == 0) {
            imageType = 5;
        }
        BufferedImage image = new BufferedImage(width, height, imageType);
        Graphics2D g2D = (Graphics2D)image.getGraphics();
        Color save = g2D.getColor();
        g2D.setColor(Color.WHITE);
        g2D.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2D.setColor(save);
        return image;
    }

    protected BufferedImage getStartImage(int width, int height) {
        return this.getStartImage(0, width, height);
    }

    static {
        try {
            WGS_84 = CRS.decode((String)"EPSG:4326", (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

