/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.quality;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.geotools.api.metadata.Identifier;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.metadata.quality.Element;
import org.geotools.api.metadata.quality.EvaluationMethodType;
import org.geotools.api.metadata.quality.Result;
import org.geotools.api.util.InternationalString;
import org.geotools.metadata.iso.MetadataEntity;

public class ElementImpl
extends MetadataEntity
implements Element {
    private static final long serialVersionUID = -3542504624077298894L;
    private Collection<InternationalString> namesOfMeasure;
    private Identifier measureIdentification;
    private InternationalString measureDescription;
    private EvaluationMethodType evaluationMethodType;
    private InternationalString evaluationMethodDescription;
    private Citation evaluationProcedure;
    private long date1 = Long.MIN_VALUE;
    private long date2 = Long.MIN_VALUE;
    private Collection<Result> results;

    public ElementImpl() {
    }

    public ElementImpl(Element source) {
        super(source);
    }

    public ElementImpl(Result result) {
        this.setResults(Collections.singleton(result));
    }

    public Collection<InternationalString> getNamesOfMeasure() {
        this.namesOfMeasure = this.nonNullCollection(this.namesOfMeasure, InternationalString.class);
        return this.namesOfMeasure;
    }

    public void setNamesOfMeasure(Collection<? extends InternationalString> newValues) {
        this.namesOfMeasure = this.copyCollection(newValues, this.namesOfMeasure, InternationalString.class);
    }

    public Identifier getMeasureIdentification() {
        return this.measureIdentification;
    }

    public void setMeasureIdentification(Identifier newValue) {
        this.checkWritePermission();
        this.measureIdentification = newValue;
    }

    public InternationalString getMeasureDescription() {
        return this.measureDescription;
    }

    public void setMeasureDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.measureDescription = newValue;
    }

    public EvaluationMethodType getEvaluationMethodType() {
        return this.evaluationMethodType;
    }

    public void setEvaluationMethodType(EvaluationMethodType newValue) {
        this.checkWritePermission();
        this.evaluationMethodType = newValue;
    }

    public InternationalString getEvaluationMethodDescription() {
        return this.evaluationMethodDescription;
    }

    public void setEvaluationMethodDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.evaluationMethodDescription = newValue;
    }

    public Citation getEvaluationProcedure() {
        return this.evaluationProcedure;
    }

    public void setEvaluationProcedure(Citation newValue) {
        this.checkWritePermission();
        this.evaluationProcedure = newValue;
    }

    public Collection<Date> getDates() {
        if (this.date1 == Long.MIN_VALUE) {
            return Collections.emptyList();
        }
        if (this.date2 == Long.MIN_VALUE) {
            return Collections.singleton(new Date(this.date1));
        }
        return Arrays.asList(new Date(this.date1), new Date(this.date2));
    }

    public void setDates(Collection<Date> newValues) {
        this.checkWritePermission();
        this.date2 = Long.MIN_VALUE;
        this.date1 = Long.MIN_VALUE;
        Iterator<Date> it = newValues.iterator();
        if (it.hasNext()) {
            this.date1 = it.next().getTime();
            if (it.hasNext()) {
                this.date2 = it.next().getTime();
                if (it.hasNext()) {
                    throw new IllegalArgumentException("Mismatched array length.");
                }
            }
        }
    }

    public Collection<Result> getResults() {
        this.results = this.nonNullCollection(this.results, Result.class);
        return this.results;
    }

    public void setResults(Collection<? extends Result> newValues) {
        this.results = this.copyCollection(newValues, this.results, Result.class);
    }
}

