/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.BasicDBObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.mongodb.FeatureTypeDBObject;
import org.geotools.data.mongodb.MongoSchemaStore;
import org.geotools.data.mongodb.MongoUtil;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class MongoSchemaFileStore
implements MongoSchemaStore {
    static final String SUFFIX_json = ".json";
    static final String PRE_FIX_HTTP = "http";
    static final String SUFFIX_ZIP = ".zip";
    protected File schemaStoreFile;

    public MongoSchemaFileStore(String uri) throws IOException, URISyntaxException {
        this(new URI(uri));
    }

    public MongoSchemaFileStore(URI uri) throws IOException {
        this(new File(uri));
    }

    public MongoSchemaFileStore(File file) throws IOException {
        this.schemaStoreFile = file;
        MongoSchemaFileStore.validateDirectory(this.schemaStoreFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeSchema(SimpleFeatureType schema) throws IOException {
        if (schema == null) {
            return;
        }
        File schemaFile = this.schemaFile(schema.getTypeName());
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(schemaFile));){
            BasicDBObject dbObject = FeatureTypeDBObject.convert(schema);
            writer.write(dbObject.toJson());
        }
    }

    @Override
    public SimpleFeatureType retrieveSchema(Name name) throws IOException {
        if (name == null) {
            return null;
        }
        File schemaFile = this.schemaFile(name);
        if (!schemaFile.canRead()) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new FileReader(schemaFile));
        return MongoUtil.getSimpleFeatureType(reader, name);
    }

    @Override
    public void deleteSchema(Name name) throws IOException {
        if (name == null) {
            return;
        }
        this.schemaFile(name).delete();
    }

    @Override
    public List<String> typeNames() {
        ArrayList<String> typeNames = new ArrayList<String>();
        File[] files = this.schemaStoreFile.listFiles(new SchemaFilter());
        if (files != null) {
            for (File schemaFile : files) {
                typeNames.add(MongoSchemaFileStore.typeName(schemaFile));
            }
        }
        return typeNames;
    }

    static String typeName(File schemaFile) {
        String typeName = schemaFile.getName();
        return typeName.substring(0, typeName.length() - SUFFIX_json.length());
    }

    File schemaFile(Name name) {
        return this.schemaFile(name.getLocalPart());
    }

    File schemaFile(String typeName) {
        return new File(this.schemaStoreFile, typeName + SUFFIX_json);
    }

    @Override
    public void close() {
    }

    static void validateDirectory(File file) throws IOException {
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Schema store directory does not exist and could not be created: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            if (!File.createTempFile("test", ".tmp", file).delete()) {
                throw new IOException("Unable to write to schema store directory: " + file.getAbsolutePath());
            }
        } else {
            throw new IOException("Specified schema store directory exists but is not a directory: " + file.getAbsolutePath());
        }
    }

    private static class SchemaFilter
    implements FileFilter {
        private SchemaFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(MongoSchemaFileStore.SUFFIX_json);
        }
    }
}

