/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb.complex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.digester.Digester;
import org.geotools.data.DataAccess;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.DataAccessMappingFeatureIterator;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.config.AppSchemaDataAccessDTO;
import org.geotools.data.complex.config.SourceDataStore;
import org.geotools.data.complex.filter.XPath;
import org.geotools.data.complex.spi.CustomImplementationsFinder;
import org.geotools.data.complex.spi.CustomSourceDataStore;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.data.mongodb.MongoDataStore;
import org.geotools.data.mongodb.complex.MongoNestedMapping;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterAttributeExtractor;
import org.opengis.feature.Feature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.xml.sax.helpers.NamespaceSupport;

public final class MongoComplexDataSource
implements CustomSourceDataStore {
    private FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2(null);

    public DataAccess<? extends FeatureType, ? extends Feature> buildDataStore(SourceDataStore dataStoreConfig, AppSchemaDataAccessDTO appSchemaConfig) {
        return null;
    }

    public void configXmlDigesterDataSources(Digester digester) {
    }

    public void configXmlDigesterAttributesMappings(Digester digester) {
    }

    public DataAccessMappingFeatureIterator buildIterator(AppSchemaDataAccess store, FeatureTypeMapping featureTypeMapping, Query query, Transaction transaction) {
        if (featureTypeMapping.getSource() == null || !(featureTypeMapping.getSource().getDataStore() instanceof MongoDataStore)) {
            return null;
        }
        try {
            return new DataAccessMappingFeatureIterator(store, featureTypeMapping, query, false, true);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error creating App-Schema iterator for MongoDB data store.", exception);
        }
    }

    public List<PropertyName> getSurrogatePropertyNames(List<PropertyName> requested, FeatureTypeMapping featureTypeMapping) {
        if (featureTypeMapping.getSource() == null || !(featureTypeMapping.getSource().getDataStore() instanceof MongoDataStore)) {
            return Collections.emptyList();
        }
        ArrayList<PropertyName> properties = new ArrayList<PropertyName>();
        for (PropertyName propertyName : requested) {
            properties.addAll(this.extractJsonPaths(featureTypeMapping, propertyName));
        }
        return properties;
    }

    private List<PropertyName> extractJsonPaths(FeatureTypeMapping featureTypeMapping, PropertyName propertyName) {
        Expression expression = this.findPropertyExpression(featureTypeMapping, propertyName);
        if (expression == null) {
            return Collections.emptyList();
        }
        FilterAttributeExtractor propertiesExtractor = new FilterAttributeExtractor();
        expression.accept((ExpressionVisitor)propertiesExtractor, null);
        return propertiesExtractor.getAttributeNameSet().stream().map(attributeName -> this.filterFactory.property(attributeName)).collect(Collectors.toList());
    }

    private Expression findPropertyExpression(FeatureTypeMapping featureTypeMapping, PropertyName propertyName) {
        XPathUtil.StepList propertySteps = this.buildPropertySteps(featureTypeMapping, propertyName);
        AttributeMapping attributeMapping = this.findAttributeMapping(featureTypeMapping, propertyName, propertySteps);
        if (attributeMapping == null) {
            return null;
        }
        if (attributeMapping instanceof MongoNestedMapping) {
            return CustomImplementationsFinder.find((FeatureTypeMapping)featureTypeMapping, (XPathUtil.StepList)propertySteps, (NestedAttributeMapping)((NestedAttributeMapping)attributeMapping));
        }
        Expression expression = attributeMapping.getSourceExpression();
        return expression == null || expression == Expression.NIL ? attributeMapping.getIdentifierExpression() : expression;
    }

    private XPathUtil.StepList buildPropertySteps(FeatureTypeMapping featureTypeMapping, PropertyName propertyName) {
        NamespaceSupport nameSpaces = propertyName.getNamespaceContext();
        if (nameSpaces == null) {
            nameSpaces = featureTypeMapping.getNamespaces();
        }
        return XPath.steps((AttributeDescriptor)featureTypeMapping.getTargetFeature(), (String)propertyName.getPropertyName(), (NamespaceSupport)nameSpaces);
    }

    private AttributeMapping findAttributeMapping(FeatureTypeMapping featureTypeMapping, PropertyName propertyName, XPathUtil.StepList propertySteps) {
        for (AttributeMapping attributeMapping : featureTypeMapping.getAttributeMappings()) {
            XPathUtil.StepList attributeSteps = attributeMapping.getTargetXPath();
            if (!(propertySteps == null ? AppSchemaDataAccess.matchProperty((String)propertyName.getPropertyName(), (XPathUtil.StepList)attributeSteps) : AppSchemaDataAccess.matchProperty((XPathUtil.StepList)propertySteps, (XPathUtil.StepList)attributeSteps))) continue;
            return attributeMapping;
        }
        return null;
    }
}

