/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MongoSchemaInitParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> ids;
    private int maxObjects = 1;

    private MongoSchemaInitParams(List<String> ids, Integer maxObjects) {
        this.ids = ids != null ? ids : Collections.emptyList();
        this.maxObjects = maxObjects;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public void setIds(List<String> ids) {
        this.ids = ids;
    }

    public int getMaxObjects() {
        return this.maxObjects;
    }

    public void setMaxObjects(int maxObjects) {
        this.maxObjects = maxObjects;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> ids;
        private int maxObjects = 1;

        private Builder() {
        }

        public Builder ids(String ... ids) {
            this.ids = Arrays.asList(ids);
            return this;
        }

        public Builder maxObjects(int maxObjects) {
            this.maxObjects = maxObjects;
            return this;
        }

        public MongoSchemaInitParams build() {
            return new MongoSchemaInitParams(this.ids, this.maxObjects);
        }
    }
}

