/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb.complex;

import com.mongodb.DBObject;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.FeatureListener;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.complex.AppSchemaDataAccess;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.MappingFeatureCollection;
import org.geotools.data.complex.MappingFeatureSource;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.util.XPathUtil;
import org.geotools.data.memory.MemoryFeatureCollection;
import org.geotools.data.mongodb.MongoFeature;
import org.geotools.data.mongodb.complex.CollectionLinkFunction;
import org.geotools.data.mongodb.complex.MongoCollectionFeature;
import org.geotools.data.mongodb.complex.MongoComplexUtilities;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.xml.sax.helpers.NamespaceSupport;

public class MongoNestedMapping
extends NestedAttributeMapping {
    public MongoNestedMapping(Expression idExpression, Expression parentExpression, XPathUtil.StepList targetXPath, boolean isMultiValued, Map<Name, Expression> clientProperties, Expression sourceElement, XPathUtil.StepList sourcePath, NamespaceSupport namespaces) throws IOException {
        super(idExpression, parentExpression, targetXPath, isMultiValued, clientProperties, sourceElement, sourcePath, namespaces);
    }

    public List<Feature> getFeatures(Object source, Object foreignKeyValue, List<Object> idValues, CoordinateReferenceSystem reprojection, Object feature, List<PropertyName> selectedProperties, boolean includeMandatory, int resolveDepth, Integer resolveTimeOut) throws IOException {
        List collection;
        if (!(foreignKeyValue instanceof CollectionLinkFunction.LinkCollection)) {
            throw new RuntimeException("MongoDB nesting only supports foreign keys of 'CollectionLink' type.");
        }
        CollectionLinkFunction.LinkCollection linkCollection = (CollectionLinkFunction.LinkCollection)foreignKeyValue;
        Object collectionPath = linkCollection.getCollectionPath();
        if (feature instanceof MongoCollectionFeature) {
            String parentPath = ((MongoCollectionFeature)((Object)feature)).getCollectionPath();
            collectionPath = parentPath + "." + (String)collectionPath;
        }
        if ((collection = this.getSubCollection(feature, (String)collectionPath)) == null) {
            return Collections.emptyList();
        }
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        for (int i = 0; i < collection.size(); ++i) {
            features.add((SimpleFeature)MongoCollectionFeature.build(feature, (String)collectionPath, i));
        }
        MappingFeatureSource fSource = this.buildMappingFeatureSource(feature, features);
        ArrayList<Feature> matchingFeatures = new ArrayList<Feature>();
        FeatureCollection fCollection = fSource.getFeatures(Query.ALL);
        if (fCollection instanceof MappingFeatureCollection) {
            try (FeatureIterator iterator = fCollection.features();){
                while (iterator.hasNext()) {
                    Feature nestedFeature = iterator.next();
                    String parentPath = MongoComplexUtilities.resolvePath((Feature)feature, linkCollection.getCollectionPath());
                    MongoComplexUtilities.setParentPath(nestedFeature, parentPath);
                    matchingFeatures.add(nestedFeature);
                }
            }
        }
        return matchingFeatures;
    }

    private MappingFeatureSource buildMappingFeatureSource(Object feature, List<SimpleFeature> features) throws IOException {
        MappingFeatureSource originalFeatureSource = (MappingFeatureSource)this.getMappingSource(feature);
        FeatureTypeMapping mapping = originalFeatureSource.getMapping();
        AppSchemaDataAccess dataAccess = (AppSchemaDataAccess)originalFeatureSource.getDataStore();
        MemoryFeatureCollection collection = new MemoryFeatureCollection(null);
        collection.addAll(features);
        MongoStaticFeatureSource staticSource = new MongoStaticFeatureSource(collection, mapping.getSource());
        FeatureTypeMapping staticMapping = new FeatureTypeMapping(staticSource, mapping.getTargetFeature(), mapping.getDefaultGeometryXPath(), mapping.getAttributeMappings(), mapping.getNamespaces(), mapping.isDenormalised());
        return new MappingFeatureSource(dataAccess, staticMapping);
    }

    private List getSubCollection(Object feature, String collectionPath) {
        if (!(feature instanceof Feature)) {
            throw MongoComplexUtilities.invalidFeature(feature, collectionPath);
        }
        Feature f = (Feature)feature;
        Feature extracted = MongoComplexUtilities.extractFeature(feature, collectionPath);
        if (extracted instanceof MongoFeature) {
            MongoFeature mongoFeature = (MongoFeature)extracted;
            DBObject mongoObject = mongoFeature.getMongoObject();
            Supplier<GeometryCoordinateSequenceTransformer> transformer = MongoComplexUtilities.getTransformer(f, mongoFeature);
            return this.getSubCollection(mongoObject, collectionPath, Collections.emptyMap(), transformer);
        }
        if (extracted instanceof MongoCollectionFeature) {
            MongoCollectionFeature collectionFeature = (MongoCollectionFeature)extracted;
            MongoFeature mongoFeature = collectionFeature.getMongoFeature();
            Supplier<GeometryCoordinateSequenceTransformer> transformer = MongoComplexUtilities.getTransformer(f, mongoFeature);
            return this.getSubCollection(mongoFeature.getMongoObject(), collectionPath, collectionFeature.getCollectionsIndexes(), transformer);
        }
        throw new RuntimeException("MongoDB nesting only works with MongoDB features.");
    }

    private List getSubCollection(DBObject mongoObject, String collectionPath, Map<String, Integer> collectionsIndexes, Supplier<GeometryCoordinateSequenceTransformer> transformer) {
        Object value = MongoComplexUtilities.getValue(mongoObject, collectionsIndexes, collectionPath, transformer);
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof List) {
            return (List)value;
        }
        throw new RuntimeException("Could not extract collection from path.");
    }

    private static final class MongoStaticFeatureSource<T extends FeatureType, F extends Feature>
    implements FeatureSource<T, F> {
        private final FeatureCollection<T, F> features;
        private final FeatureSource<T, F> originalFeatureSource;

        public MongoStaticFeatureSource(FeatureCollection<T, F> features, FeatureSource<T, F> originalFeatureSource) {
            this.features = features;
            this.originalFeatureSource = originalFeatureSource;
        }

        public Name getName() {
            return this.originalFeatureSource.getName();
        }

        public ResourceInfo getInfo() {
            return this.originalFeatureSource.getInfo();
        }

        public DataAccess<T, F> getDataStore() {
            return this.originalFeatureSource.getDataStore();
        }

        public QueryCapabilities getQueryCapabilities() {
            return this.originalFeatureSource.getQueryCapabilities();
        }

        public void addFeatureListener(FeatureListener listener) {
        }

        public void removeFeatureListener(FeatureListener listener) {
        }

        public FeatureCollection<T, F> getFeatures(Filter filter) throws IOException {
            return this.features;
        }

        public FeatureCollection<T, F> getFeatures(Query query) throws IOException {
            return this.features;
        }

        public FeatureCollection<T, F> getFeatures() throws IOException {
            return this.features;
        }

        public T getSchema() {
            return (T)this.originalFeatureSource.getSchema();
        }

        public ReferencedEnvelope getBounds() throws IOException {
            return this.features.getBounds();
        }

        public ReferencedEnvelope getBounds(Query query) throws IOException {
            return this.features.getBounds();
        }

        public int getCount(Query query) throws IOException {
            return this.features.size();
        }

        public Set<RenderingHints.Key> getSupportedHints() {
            return this.originalFeatureSource.getSupportedHints();
        }
    }
}

