/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.io.CoverageReadRequest;
import org.geotools.coverage.io.RasterLayout;
import org.geotools.coverage.io.ReadType;
import org.geotools.coverage.io.SpatialRequestHelper;
import org.geotools.coverage.io.netcdf.NetCDFSource;
import org.geotools.coverage.io.range.RangeType;
import org.geotools.coverage.io.util.DateRangeTreeSet;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.imageio.netcdf.VariableAdapter;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

class NetCDFRequest
extends CoverageReadRequest {
    private static final Logger LOGGER = Logging.getLogger(NetCDFRequest.class);
    Interpolation interpolation = Interpolation.getInstance((int)0);
    NetCDFSource source;
    ReadType readType = ReadType.DIRECT_READ;
    SpatialRequestHelper spatialRequestHelper;
    CoverageReadRequest originalRequest = null;
    String name = null;

    public NetCDFRequest(NetCDFSource source, CoverageReadRequest request) throws IOException {
        this.source = source;
        this.originalRequest = request;
        this.name = source.getName(null).toString();
        this.checkRequest(request);
        this.spatialRequestHelper = new SpatialRequestHelper();
        BoundingBox requestedBBox = request.getGeographicArea();
        Rectangle requestedRasterArea = request.getRasterArea();
        MathTransform2D requestedG2W = request.getGridToWorldTransform();
        this.spatialRequestHelper.setRequestedBBox(requestedBBox);
        this.spatialRequestHelper.setRequestedRasterArea(requestedRasterArea);
        this.spatialRequestHelper.setRequestedGridToWorld((AffineTransform)requestedG2W);
        this.initInputCoverageProperties();
    }

    private void initInputCoverageProperties() throws IOException {
        VariableAdapter.UnidataSpatialDomain spatialDomain = (VariableAdapter.UnidataSpatialDomain)this.source.getSpatialDomain();
        Set<? extends RasterLayout> rasterElements = spatialDomain.getRasterElements(false, null);
        GridGeometry2D gridGeometry2D = spatialDomain.getGridGeometry();
        AffineTransform gridToCRS = (AffineTransform)gridGeometry2D.getGridToCRS();
        double[] coverageFullResolution = CoverageUtilities.getResolution((AffineTransform)gridToCRS);
        MathTransform raster2Model = gridGeometry2D.getGridToCRS();
        ReferencedEnvelope bbox = spatialDomain.getReferencedEnvelope();
        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(bbox);
        CoordinateReferenceSystem spatialReferenceSystem2D = spatialDomain.getCoordinateReferenceSystem2D();
        this.rasterArea = rasterElements.iterator().next().toRectangle();
        SpatialRequestHelper.CoverageProperties properties = new SpatialRequestHelper.CoverageProperties();
        properties.setCrs2D(spatialReferenceSystem2D);
        properties.setFullResolution(coverageFullResolution);
        properties.setBbox(referencedEnvelope);
        ReferencedEnvelope wgs84Envelope = new ReferencedEnvelope(bbox);
        try {
            wgs84Envelope = wgs84Envelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
        }
        catch (FactoryException | TransformException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        properties.setGeographicBBox(wgs84Envelope);
        properties.setGeographicCRS2D(wgs84Envelope.getCoordinateReferenceSystem());
        properties.setGridToWorld2D((MathTransform2D)raster2Model);
        properties.setRasterArea(this.rasterArea);
        this.spatialRequestHelper.setCoverageProperties(properties);
        this.spatialRequestHelper.prepare();
    }

    private void checkRequest(CoverageReadRequest request) throws IOException {
        RangeType range;
        BoundingBox requestedBoundingBox = request.getGeographicArea();
        Rectangle requestedRasterArea = request.getRasterArea();
        VariableAdapter.UnidataSpatialDomain horizontalDomain = (VariableAdapter.UnidataSpatialDomain)this.source.getSpatialDomain();
        VariableAdapter.UnidataTemporalDomain temporalDomain = (VariableAdapter.UnidataTemporalDomain)this.source.getTemporalDomain();
        VariableAdapter.UnidataVerticalDomain verticalDomain = (VariableAdapter.UnidataVerticalDomain)this.source.getVerticalDomain();
        if (requestedRasterArea == null || requestedBoundingBox == null) {
            boolean bothNull = true;
            if (requestedRasterArea == null) {
                requestedRasterArea = horizontalDomain.getGridGeometry().getGridRange2D().getBounds();
            } else {
                bothNull = false;
            }
            if (requestedBoundingBox == null) {
                requestedBoundingBox = horizontalDomain.getReferencedEnvelope();
            } else {
                bothNull = false;
            }
            if (bothNull) {
                try {
                    request.setDomainSubset(requestedRasterArea, horizontalDomain.getGridGeometry().getGridToCRS2D(), horizontalDomain.getCoordinateReferenceSystem2D());
                }
                catch (TransformException e) {
                    request.setDomainSubset(requestedRasterArea, ReferencedEnvelope.reference((Envelope)requestedBoundingBox));
                    LOGGER.log(Level.SEVERE, "Transform exception while setting the domain subset to: " + String.valueOf(requestedRasterArea), e);
                }
            } else {
                request.setDomainSubset(requestedRasterArea, ReferencedEnvelope.reference((Envelope)requestedBoundingBox));
            }
        }
        SortedSet temporalSubset = request.getTemporalSubset();
        if (temporalDomain != null && temporalSubset.isEmpty() && NetCDFUtilities.getParameterBehaviour(NetCDFUtilities.TIME_DIM) == NetCDFUtilities.ParameterBehaviour.DO_NOTHING) {
            SortedSet<DateRange> temporalExtent = temporalDomain.getTemporalExtent();
            if (temporalExtent != null) {
                temporalSubset = new DateRangeTreeSet(temporalExtent);
            }
            request.setTemporalSubset(temporalSubset);
        }
        HashSet<Object> verticalSubset = request.getVerticalSubset();
        if (verticalDomain != null) {
            SortedSet<NumberRange<Double>> verticalExtent = verticalDomain.getVerticalExtent();
            if (verticalSubset.isEmpty() && NetCDFUtilities.getParameterBehaviour(NetCDFUtilities.ELEVATION_DIM) == NetCDFUtilities.ParameterBehaviour.DO_NOTHING) {
                if (verticalExtent != null) {
                    verticalSubset = new HashSet<NumberRange<Double>>(verticalExtent);
                }
                request.setVerticalSubset((Set)verticalSubset);
            } else {
                NumberRange requestedVerticalEnv = (NumberRange)verticalSubset.iterator().next();
                if (verticalExtent != null && !verticalExtent.isEmpty() && !((NumberRange)verticalExtent.iterator().next()).contains((Range)requestedVerticalEnv)) {
                    NumberRange nearestEnvelope = (NumberRange)verticalExtent.iterator().next();
                    double minimumDistance = Math.abs(nearestEnvelope.getMinimum() - requestedVerticalEnv.getMinimum());
                    for (NumberRange numberRange : verticalExtent) {
                        double distance = Math.abs(numberRange.getMinimum() - requestedVerticalEnv.getMinimum());
                        if (!(distance < minimumDistance)) continue;
                        nearestEnvelope = numberRange;
                        minimumDistance = distance;
                    }
                    verticalSubset = new HashSet(1);
                    verticalSubset.add((NumberRange<Double>)nearestEnvelope);
                    request.setVerticalSubset(verticalSubset);
                }
            }
        }
        if ((range = request.getRangeSubset()) == null) {
            request.setRangeSubset(this.source.getRangeType(null));
        }
    }

    ReadType getReadType() {
        return this.readType;
    }

    Interpolation getInterpolation() {
        return this.interpolation;
    }

    public String toString() {
        return "NetCDFRequest [interpolation=" + String.valueOf(this.interpolation) + ", source=" + String.valueOf((Object)this.source) + ", readType=" + String.valueOf(this.readType) + ", spatialRequestHelper=" + String.valueOf(this.spatialRequestHelper) + ", originalRequest=" + String.valueOf(this.originalRequest) + ", name=" + this.name + "]";
    }
}

