/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.util.Converters;

public class H2MigrateConfiguration {
    private String indexStoreName;
    private File mosaicDirectory;
    private boolean failureIgnored;
    private int concurrency;
    private File logDirectory;
    private Properties sourceStoreConfiguration;
    private String[] coverageNames;
    private Properties targetStoreConfiguration;
    private String[] indexTables;

    public static DataStore getDataStore(Properties configuration) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        DataStore dataStore = DataStoreFinder.getDataStore((Map)DataUtilities.toConnectionParameters((Properties)configuration));
        if (dataStore == null) {
            String spiClass = (String)configuration.get("SPI");
            DataStoreFactorySpi spi = (DataStoreFactorySpi)Class.forName(spiClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Map datastoreParams = Utils.filterDataStoreParams((Properties)configuration, (DataStoreFactorySpi)spi);
            return spi.createDataStore(datastoreParams);
        }
        return null;
    }

    public void setMosaicPath(String mosaicPath) {
        this.mosaicDirectory = new File(mosaicPath);
        if (!this.mosaicDirectory.exists() && !this.mosaicDirectory.isDirectory()) {
            throw new ConfigurationException("Mosaic directory does not exist or is not a directory " + String.valueOf(this.mosaicDirectory));
        }
    }

    public void setTargetStoreConfiguration(String configPath) {
        Properties properties;
        this.targetStoreConfiguration = properties = this.loadStoreProperties(configPath);
    }

    public void setSourceStoreConfiguration(String configPath) {
        Properties properties;
        this.sourceStoreConfiguration = properties = this.loadStoreProperties(configPath);
    }

    public Properties loadStoreProperties(String configPath) {
        File configFile = new File(configPath);
        if (!configFile.exists() || !configFile.isFile()) {
            throw new ConfigurationException("Target store configuration file does not exist: " + configPath);
        }
        Properties properties = new Properties();
        try (FileInputStream is = new FileInputStream(configFile);){
            properties.load(is);
        }
        catch (IOException e) {
            throw new ConfigurationException("Could not load the store configuration from: " + configPath, e);
        }
        try {
            DataStore dataStore = H2MigrateConfiguration.getDataStore(properties);
            if (dataStore == null) {
                throw new ConfigurationException("No datastore could be loaded with the given properties, make sure you have all the required jars for it in the classpath. Tried to use: " + configPath);
            }
            dataStore.dispose();
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to load data store from configuration at " + configPath + ": " + e.getMessage(), e);
        }
        return properties;
    }

    public void setFailureIgnored(boolean failureIgnored) {
        this.failureIgnored = failureIgnored;
    }

    public boolean isFailureIgnored() {
        return this.failureIgnored;
    }

    public void setConcurrency(String concurrencySpec) {
        Integer c = (Integer)Converters.convert((Object)concurrencySpec, Integer.class);
        if (c == null) {
            throw new ConfigurationException("Invalid concurrency level " + concurrencySpec);
        }
        this.setConcurrency(c);
    }

    public void setConcurrency(int concurrency) {
        if (concurrency < 1) {
            throw new ConfigurationException("Invalid concurrency level, must be a positive number " + concurrency);
        }
        this.concurrency = concurrency;
    }

    public void setLogDirectory(String logDirectoryPath) {
        this.logDirectory = new File(logDirectoryPath);
        if (!this.logDirectory.exists() && !this.logDirectory.isDirectory()) {
            throw new ConfigurationException("Invalid log file location, does not exist or it's not a directory " + logDirectoryPath);
        }
    }

    public File getLogDirectory() {
        return this.logDirectory;
    }

    public void setMosaicDirectory(File mosaicDirectory) {
        this.mosaicDirectory = mosaicDirectory;
    }

    public File getMosaicDirectory() {
        return this.mosaicDirectory;
    }

    public Properties getTargetStoreConfiguration() {
        return this.targetStoreConfiguration;
    }

    public Properties getSourceStoreConfiguration() {
        return this.sourceStoreConfiguration;
    }

    public int getConcurrency() {
        return this.concurrency <= 0 ? 1 : this.concurrency;
    }

    public void setCoverageNames(String[] coverageNames) {
        this.coverageNames = coverageNames;
    }

    public String[] getCoverageNames() {
        return this.coverageNames;
    }

    public void setIndexStoreName(String indexStoreName) {
        this.indexStoreName = indexStoreName;
    }

    public String getIndexStoreName() {
        return this.indexStoreName;
    }

    public String[] getIndexTables() {
        return this.indexTables;
    }

    public void setIndexTables(String[] indexTables) {
        this.indexTables = indexTables;
    }

    public static class ConfigurationException
    extends RuntimeException {
        public ConfigurationException(String message) {
            super(message);
        }

        public ConfigurationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

