/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf;

import it.geosolutions.imageio.core.CoreCommonImageMetadata;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class NetCDFImageMetadata
extends CoreCommonImageMetadata {
    static final Logger LOGGER = Logging.getLogger(NetCDFImageMetadata.class);
    public static final String nativeMetadataFormatName = "it_geosolutions_imageioimpl_plugins_netcdf_image_1.0";
    public static final String nativeMetadataFormatClassName = NetCDFImageMetadata.class.getName();

    public NetCDFImageMetadata(String variableName, SampleModel sm, ColorModel cm, CoordinateReferenceSystem crs) {
        super(true, nativeMetadataFormatName, nativeMetadataFormatClassName, null, null);
        this.setDatasetName(variableName);
        this.setWidth(sm.getWidth());
        this.setHeight(sm.getHeight());
        this.setTileWidth(sm.getWidth());
        this.setTileHeight(1);
        this.setColorModel(cm);
        this.setSampleModel(sm);
        this.setNumBands(sm.getNumBands());
        try {
            if (crs != null) {
                this.setProjection(((ReferenceIdentifier)crs.getIdentifiers().iterator().next()).toString());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Could not add the projection information into the metadata", e);
        }
    }
}

