/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf;

import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.HarvestedSource;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.coverage.io.CoverageAccess;
import org.geotools.coverage.io.CoverageReadRequest;
import org.geotools.coverage.io.CoverageResponse;
import org.geotools.coverage.io.CoverageSource;
import org.geotools.coverage.io.Driver;
import org.geotools.coverage.io.FileDriver;
import org.geotools.coverage.io.GridCoverageResponse;
import org.geotools.coverage.io.RasterLayout;
import org.geotools.coverage.io.catalog.CoverageSlicesCatalog;
import org.geotools.coverage.io.catalog.CoverageSlicesCatalogSource;
import org.geotools.coverage.io.netcdf.ConvertersHack;
import org.geotools.coverage.io.netcdf.NetCDFAccess;
import org.geotools.coverage.io.netcdf.NetCDFDriver;
import org.geotools.coverage.io.netcdf.NetCDFFileResourceInfo;
import org.geotools.coverage.io.netcdf.NetCDFFormat;
import org.geotools.coverage.io.netcdf.NetCDFSource;
import org.geotools.coverage.io.util.DateRangeTreeSet;
import org.geotools.coverage.io.util.DoubleRangeTreeSet;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.data.DataSourceException;
import org.geotools.data.ResourceInfo;
import org.geotools.feature.NameImpl;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.imageio.netcdf.NetCDFImageReader;
import org.geotools.imageio.netcdf.VariableAdapter;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public class NetCDFReader
extends AbstractGridCoverage2DReader
implements StructuredGridCoverage2DReader {
    static final String UNSPECIFIED = "_UN$PECIFIED_";
    static final String DOMAIN_SUFFIX = "_DOMAIN";
    static final String HAS_PREFIX = "HAS_";
    private static final String MINIMUM_SUFFIX = "_MAXIMUM";
    private static final String MAXIMUM_SUFFIX = "_MINIMUM";
    private static final String DATATYPE_SUFFIX = "_DATATYPE";
    private static final Logger LOGGER = Logging.getLogger(NetCDFReader.class);
    static FileDriver DRIVER = new NetCDFDriver();
    private CoverageAccess access = null;
    private List<Name> names = null;
    private Set<String> setNames = null;
    private URL sourceURL;
    String defaultName = null;
    private SoftValueHashMap<String, CoverageSource> coverages = new SoftValueHashMap();

    public NetCDFReader(Object input, Hints uHints) throws DataSourceException {
        super(input, uHints);
        this.sourceURL = this.checkSource(input);
        if (!DRIVER.canProcess(Driver.DriverCapabilities.CONNECT, this.sourceURL, null)) {
            throw new DataSourceException("unable to connect to the specified source " + this.sourceURL);
        }
        try {
            this.access = (NetCDFAccess)DRIVER.process(Driver.DriverCapabilities.CONNECT, this.sourceURL, null, uHints, null);
        }
        catch (IOException e) {
            throw new DataSourceException("Unable to connect", (Throwable)e);
        }
        if (this.access == null) {
            throw new DataSourceException("Unable to connect");
        }
        LOGGER.info("ACCEPTED: " + this.source.toString());
        this.names = this.access.getNames(null);
        this.setNames = new TreeSet<String>();
        for (Name name : this.names) {
            String nameString = name.toString();
            if (this.defaultName == null) {
                this.defaultName = nameString;
            }
            this.setNames.add(nameString);
        }
    }

    private URL checkSource(Object input) {
        URL sourceURL = null;
        if (input instanceof URL) {
            sourceURL = (URL)input;
        } else if (input instanceof File) {
            sourceURL = URLs.fileToUrl((File)((File)input));
        }
        return sourceURL;
    }

    public Format getFormat() {
        return new NetCDFFormat();
    }

    public String[] getMetadataNames(String coverageName) {
        this.checkIsSupported(coverageName);
        ArrayList<String> metadataNames = new ArrayList<String>();
        metadataNames.add("HAS_TIME_DOMAIN");
        metadataNames.add("TIME_DOMAIN");
        metadataNames.add("TIME_DOMAIN_MINIMUM");
        metadataNames.add("TIME_DOMAIN_MAXIMUM");
        metadataNames.add("TIME_DOMAIN_RESOLUTION");
        metadataNames.add("TIME_DOMAIN_DATATYPE");
        metadataNames.add("HAS_ELEVATION_DOMAIN");
        metadataNames.add("ELEVATION_DOMAIN");
        metadataNames.add("ELEVATION_DOMAIN_MINIMUM");
        metadataNames.add("ELEVATION_DOMAIN_MAXIMUM");
        metadataNames.add("ELEVATION_DOMAIN_RESOLUTION");
        metadataNames.add("ELEVATION_DOMAIN_DATATYPE");
        this.addAdditionalMetadata(metadataNames, coverageName);
        return metadataNames.toArray(new String[metadataNames.size()]);
    }

    private void addAdditionalMetadata(List<String> metadataNames, String coverageName) {
        NetCDFSource source = null;
        try {
            source = (NetCDFSource)this.getGridCoverageSource(coverageName);
            List domains = source.getAdditionalDomains();
            if (domains != null && !domains.isEmpty()) {
                for (CoverageSource.AdditionalDomain domain : domains) {
                    String domainName = domain.getName().toUpperCase();
                    metadataNames.add(HAS_PREFIX + domainName + DOMAIN_SUFFIX);
                    metadataNames.add(domainName + DOMAIN_SUFFIX);
                    metadataNames.add(domainName + DOMAIN_SUFFIX + MINIMUM_SUFFIX);
                    metadataNames.add(domainName + DOMAIN_SUFFIX + MAXIMUM_SUFFIX);
                    metadataNames.add(domainName + DOMAIN_SUFFIX + DATATYPE_SUFFIX);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getMetadataValue(String coverageName, String name) {
        String value = null;
        NetCDFSource source = null;
        try {
            boolean hasElevationDomain;
            source = (NetCDFSource)this.getGridCoverageSource(coverageName);
            CoverageSource.TemporalDomain timeDomain = source.getTemporalDomain();
            CoverageSource.VerticalDomain verticalDomain = source.getVerticalDomain();
            List additionalDomains = source.getAdditionalDomains();
            boolean hasAdditionalDomains = additionalDomains != null && !additionalDomains.isEmpty();
            boolean hasTimeDomain = timeDomain != null;
            boolean bl = hasElevationDomain = verticalDomain != null;
            if (name.equalsIgnoreCase("HAS_ELEVATION_DOMAIN")) {
                return String.valueOf(hasElevationDomain);
            }
            if (name.equalsIgnoreCase("HAS_TIME_DOMAIN")) {
                return String.valueOf(hasTimeDomain);
            }
            if (name.equalsIgnoreCase("TIME_DOMAIN_RESOLUTION")) {
                return null;
            }
            if (name.equalsIgnoreCase("ELEVATION_DOMAIN_RESOLUTION")) {
                return null;
            }
            if (hasTimeDomain) {
                if (name.equalsIgnoreCase("time_domain")) {
                    return this.parseDomain(name, timeDomain);
                }
                if (name.equalsIgnoreCase("time_domain_minimum") || name.equalsIgnoreCase("time_domain_maximum")) {
                    return this.parseDomain(name, timeDomain);
                }
                if (name.equalsIgnoreCase("time_domain_datatype")) {
                    return this.parseDomain(name, timeDomain);
                }
            }
            if (hasElevationDomain) {
                if (name.equalsIgnoreCase("elevation_domain")) {
                    return this.parseDomain(name, verticalDomain);
                }
                if (name.equalsIgnoreCase("elevation_domain_minimum") || name.equalsIgnoreCase("elevation_domain_maximum")) {
                    return this.parseDomain(name, verticalDomain);
                }
                if (name.equalsIgnoreCase("elevation_domain_datatype")) {
                    return this.parseDomain(name, verticalDomain);
                }
            }
            if (hasAdditionalDomains) {
                if (name.startsWith(HAS_PREFIX)) {
                    String substring = name.substring(HAS_PREFIX.length(), name.length() - DOMAIN_SUFFIX.length());
                    for (CoverageSource.AdditionalDomain additionalDomain : additionalDomains) {
                        if (!additionalDomain.getName().toUpperCase().contains(substring)) continue;
                        return "true";
                    }
                    return "false";
                }
                if (name.contains(DATATYPE_SUFFIX)) {
                    for (CoverageSource.AdditionalDomain additionalDomain : additionalDomains) {
                        if (!name.toUpperCase().startsWith(additionalDomain.getName().toUpperCase() + DOMAIN_SUFFIX + DATATYPE_SUFFIX)) continue;
                        return this.parseDomain(name, additionalDomain);
                    }
                } else if (name.contains(DOMAIN_SUFFIX)) {
                    for (CoverageSource.AdditionalDomain additionalDomain : additionalDomains) {
                        if (!name.toUpperCase().startsWith(additionalDomain.getName().toUpperCase() + DOMAIN_SUFFIX)) continue;
                        return this.parseDomain(name, additionalDomain);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    public String[] getGridCoverageNames() {
        return this.setNames.toArray(new String[this.setNames.size()]);
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters(String coverageName) throws IOException {
        NetCDFSource source = (NetCDFSource)this.getGridCoverageSource(coverageName);
        if (source != null) {
            return source.getDynamicParameters();
        }
        return null;
    }

    public int getGridCoverageCount() {
        return this.setNames.size();
    }

    private String parseDomain(String name, Object domain) throws IOException {
        name = name.toLowerCase();
        if (domain instanceof CoverageSource.VerticalDomain) {
            CoverageSource.VerticalDomain verticalDomain = (CoverageSource.VerticalDomain)domain;
            if (name.endsWith("domain")) {
                SortedSet verticalElements = verticalDomain.getVerticalElements(true, null);
                return this.buildVerticalList(verticalElements);
            }
            if (name.endsWith("datatype")) {
                return Double.class.getName();
            }
            SortedSet verticalElements = verticalDomain.getVerticalElements(false, null);
            NumberRange overall = (NumberRange)verticalElements.iterator().next();
            if (name.endsWith("maximum")) {
                return Double.toString(overall.getMaximum());
            }
            if (name.endsWith("minimum")) {
                return Double.toString(overall.getMinimum());
            }
            throw new IllegalArgumentException("Unsupported metadata name");
        }
        if (domain instanceof CoverageSource.TemporalDomain) {
            CoverageSource.TemporalDomain temporalDomain = (CoverageSource.TemporalDomain)domain;
            if (name.endsWith("domain")) {
                SortedSet temporalElements = temporalDomain.getTemporalElements(true, null);
                return this.buildTemporalList(temporalElements);
            }
            if (name.endsWith("datatype")) {
                return Date.class.getName();
            }
            SortedSet temporalElements = temporalDomain.getTemporalElements(false, null);
            DateRange overall = (DateRange)temporalElements.iterator().next();
            if (name.endsWith("maximum")) {
                return ConvertersHack.convert(overall.getMaxValue(), String.class);
            }
            if (name.endsWith("minimum")) {
                return ConvertersHack.convert(overall.getMinValue(), String.class);
            }
            throw new IllegalArgumentException("Unsupported metadata name");
        }
        if (domain instanceof CoverageSource.AdditionalDomain) {
            CoverageSource.AdditionalDomain additionalDomain = (CoverageSource.AdditionalDomain)domain;
            if (name.endsWith("domain")) {
                Set elements = additionalDomain.getElements(false, null);
                return this.buildElementsList(elements);
            }
            if (name.endsWith("datatype")) {
                switch (additionalDomain.getType()) {
                    case NUMBER: {
                        return Double.class.getName();
                    }
                    case DATE: {
                        return Date.class.getName();
                    }
                }
                return String.class.getName();
            }
            Set elements = additionalDomain.getElements(true, null);
            Range range = (Range)elements.iterator().next();
            if (name.endsWith("maximum")) {
                return ConvertersHack.convert(range.getMaxValue(), String.class);
            }
            if (name.endsWith("minimum")) {
                return ConvertersHack.convert(range.getMinValue(), String.class);
            }
            throw new IllegalArgumentException("Unsupported metadata name");
        }
        throw new IllegalArgumentException("Unsupported domain ");
    }

    private String buildTemporalList(SortedSet<? extends DateRange> temporalElements) {
        Iterator iterator = temporalElements.iterator();
        StringBuilder buff = new StringBuilder("");
        while (iterator.hasNext()) {
            DateRange range = (DateRange)iterator.next();
            buff.append(ConvertersHack.convert(range.getMinValue(), String.class) + "/" + ConvertersHack.convert(range.getMaxValue(), String.class));
            if (!iterator.hasNext()) continue;
            buff.append(",");
        }
        return buff.toString();
    }

    private String buildVerticalList(SortedSet<? extends NumberRange<Double>> verticalElements) {
        Iterator iterator = verticalElements.iterator();
        LinkedHashSet<String> ranges = new LinkedHashSet<String>();
        while (iterator.hasNext()) {
            NumberRange range = (NumberRange)iterator.next();
            ranges.add(range.getMinValue() + "/" + range.getMaxValue());
        }
        return this.buildResultsString(ranges);
    }

    private String buildElementsList(Set<Object> elements) {
        Iterator<Object> iterator = elements.iterator();
        LinkedHashSet<String> ranges = new LinkedHashSet<String>();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            ranges.add(ConvertersHack.convert(value, String.class));
        }
        return this.buildResultsString(ranges);
    }

    public GridCoverage2D read(String coverageName, GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        CoverageReadRequest request;
        CoverageSource gridSource = this.getGridCoverageSource(coverageName);
        CoverageResponse result = gridSource.read(request = this.setupCoverageRequest(parameters, gridSource), null);
        Collection results = result.getResults(null);
        if (results == null || results.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("No results have been found");
            }
            return null;
        }
        GridCoverageResponse resp = (GridCoverageResponse)results.iterator().next();
        return resp.getGridCoverage2D();
    }

    private CoverageReadRequest setupCoverageRequest(GeneralParameterValue[] params, CoverageSource gridSource) throws IOException {
        CoverageReadRequest request = new CoverageReadRequest();
        if (params != null) {
            for (GeneralParameterValue gParam : params) {
                if (!(gParam instanceof ParameterValue)) continue;
                ParameterValue param = (ParameterValue)gParam;
                ReferenceIdentifier name = param.getDescriptor().getName();
                try {
                    this.extractParameter(param, name, request, gridSource);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
        return request;
    }

    private void extractParameter(ParameterValue<?> param, ReferenceIdentifier name, CoverageReadRequest request, CoverageSource gridSource) throws MismatchedDimensionException, InvalidGridGeometryException, TransformException, IOException {
        if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) {
            Object value = param.getValue();
            if (value == null) {
                return;
            }
            GridGeometry2D gg = (GridGeometry2D)value;
            request.setDomainSubset((Rectangle)gg.getGridRange2D(), gg.getGridToCRS2D(), gg.getCoordinateReferenceSystem());
            return;
        }
        if (name.equals(ImageMosaicFormat.TIME.getName())) {
            Object value = param.getValue();
            if (value == null) {
                return;
            }
            List dates = (List)value;
            if (dates != null && !dates.isEmpty()) {
                DateRangeTreeSet requestedTemporalSubset = new DateRangeTreeSet();
                for (Object val : dates) {
                    if (val instanceof Date) {
                        requestedTemporalSubset.add(new DateRange((Date)val, (Date)val));
                        continue;
                    }
                    if (!(val instanceof DateRange)) continue;
                    requestedTemporalSubset.add((DateRange)val);
                }
                request.setTemporalSubset((SortedSet)requestedTemporalSubset);
            }
            return;
        }
        if (name.equals(ImageMosaicFormat.ELEVATION.getName())) {
            Object value = param.getValue();
            if (value == null) {
                return;
            }
            List values = (List)value;
            if (!values.isEmpty()) {
                DoubleRangeTreeSet verticalSubset = new DoubleRangeTreeSet();
                for (Object val : values) {
                    if (val instanceof Number) {
                        verticalSubset.add(new NumberRange(Double.class, (Number)((Number)val).doubleValue(), (Number)((Number)val).doubleValue()));
                        continue;
                    }
                    if (!(val instanceof NumberRange)) continue;
                    verticalSubset.add((NumberRange)val);
                }
                request.setVerticalSubset((Set)verticalSubset);
            }
            return;
        }
        if (name.equals(ImageMosaicFormat.FILTER.getName())) {
            Object value = param.getValue();
            if (value == null) {
                return;
            }
            request.setFilter((Filter)value);
            return;
        }
        if (name.equals(ImageMosaicFormat.BANDS.getName())) {
            request.setBands((int[])param.getValue());
            return;
        }
        String paramName = name.getCode();
        if (((NetCDFSource)gridSource).isParameterSupported(name)) {
            Object value = param.getValue();
            if (value == null) {
                return;
            }
            HashSet<Object> values = new HashSet<Object>();
            if (value instanceof Collection) {
                values.addAll((Collection)value);
            } else {
                values.add(value);
            }
            HashMap domainsSubset = request.getAdditionalDomainsSubset();
            if (domainsSubset == null) {
                domainsSubset = new HashMap();
                request.setAdditionalDomainsSubset(domainsSubset);
            }
            domainsSubset.put(paramName, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoverageSource getGridCoverageSource(String coverageName) throws IOException {
        this.checkIsSupported(coverageName);
        SoftValueHashMap<String, CoverageSource> softValueHashMap = this.coverages;
        synchronized (softValueHashMap) {
            if (this.coverages.containsKey((Object)coverageName)) {
                return (CoverageSource)this.coverages.get((Object)coverageName);
            }
            CoverageSource source = this.access.access((Name)new NameImpl(coverageName), null, CoverageAccess.AccessType.READ_ONLY, null, null);
            this.coverages.put((Object)coverageName, (Object)source);
            return source;
        }
    }

    private void checkIsSupported(String coverageName) {
        if (!this.setNames.contains(coverageName)) {
            throw new IllegalArgumentException("the specified coverage is not available: " + coverageName);
        }
    }

    public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        if (!this.names.isEmpty()) {
            if (this.names.size() > 1) {
                throw new IllegalArgumentException("You need to specify a coverageName");
            }
            return this.read(this.names.get(0).toString(), parameters);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        block8: {
            super.dispose();
            NetCDFReader netCDFReader = this;
            synchronized (netCDFReader) {
                if (this.coverages != null && !this.coverages.isEmpty()) {
                    for (String key : this.coverages.keySet()) {
                        CoverageSource sourceCov = (CoverageSource)this.coverages.get((Object)key);
                        sourceCov.dispose();
                    }
                    this.coverages.clear();
                }
                this.coverages = null;
            }
            if (this.access != null) {
                try {
                    this.access.dispose();
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block8;
                    LOGGER.log(Level.FINE, t.getLocalizedMessage(), t);
                }
            }
        }
    }

    private String buildResultsString(Set<String> result) {
        if (result.size() <= 0) {
            return "";
        }
        StringBuilder buff = new StringBuilder();
        Iterator<String> it = result.iterator();
        while (it.hasNext()) {
            buff.append(ConvertersHack.convert(it.next(), String.class));
            if (!it.hasNext()) continue;
            buff.append(",");
        }
        return buff.toString();
    }

    private String checkUnspecifiedCoverage(String coverageName) {
        if (coverageName.equalsIgnoreCase(UNSPECIFIED)) {
            if (this.defaultName == null) {
                throw new IllegalArgumentException("coverageName not specified and no defaultName for " + this.sourceURL);
            }
            return this.defaultName;
        }
        if (!this.setNames.contains(coverageName)) {
            throw new IllegalArgumentException("coverageName " + coverageName + " not found for " + this.sourceURL);
        }
        return coverageName;
    }

    public GeneralEnvelope getOriginalEnvelope() {
        return this.getOriginalEnvelope(UNSPECIFIED);
    }

    public GeneralEnvelope getOriginalEnvelope(String coverageName) {
        coverageName = this.checkUnspecifiedCoverage(coverageName);
        try {
            CoverageSource source = this.getGridCoverageSource(coverageName);
            VariableAdapter.UnidataSpatialDomain spatialDomain = (VariableAdapter.UnidataSpatialDomain)source.getSpatialDomain();
            GeneralEnvelope generalEnvelope = new GeneralEnvelope((Envelope)spatialDomain.getReferencedEnvelope());
            generalEnvelope.setCoordinateReferenceSystem(spatialDomain.getCoordinateReferenceSystem2D());
            return generalEnvelope;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GridEnvelope getOriginalGridRange() {
        return this.getOriginalGridRange(UNSPECIFIED);
    }

    public GridEnvelope getOriginalGridRange(String coverageName) {
        coverageName = this.checkUnspecifiedCoverage(coverageName);
        try {
            CoverageSource source = this.getGridCoverageSource(coverageName);
            VariableAdapter.UnidataSpatialDomain spatialDomain = (VariableAdapter.UnidataSpatialDomain)source.getSpatialDomain();
            return spatialDomain.getGridGeometry().getGridRange2D();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public double[] getReadingResolutions(OverviewPolicy policy, double[] requestedResolution) {
        try {
            return this.getReadingResolutions(UNSPECIFIED, policy, requestedResolution);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public double[] getReadingResolutions(String coverageName, OverviewPolicy policy, double[] requestedResolution) throws IOException {
        coverageName = this.checkUnspecifiedCoverage(coverageName);
        CoverageSource source = this.getGridCoverageSource(coverageName);
        VariableAdapter.UnidataSpatialDomain spatialDomain = (VariableAdapter.UnidataSpatialDomain)source.getSpatialDomain();
        GridGeometry2D gridGeometry2D = spatialDomain.getGridGeometry();
        AffineTransform gridToCRS = (AffineTransform)gridGeometry2D.getGridToCRS();
        return CoverageUtilities.getResolution((AffineTransform)gridToCRS);
    }

    public double[][] getResolutionLevels() throws IOException {
        return this.getResolutionLevels(UNSPECIFIED);
    }

    public double[][] getResolutionLevels(String coverageName) throws IOException {
        coverageName = this.checkUnspecifiedCoverage(coverageName);
        double[][] res = new double[1][2];
        double[] readRes = this.getReadingResolutions(coverageName, null, null);
        res[0][0] = readRes[0];
        res[0][1] = readRes[1];
        return res;
    }

    public ImageLayout getImageLayout() throws IOException {
        return this.getImageLayout(UNSPECIFIED);
    }

    public ImageLayout getImageLayout(String coverageName) throws IOException {
        coverageName = this.checkUnspecifiedCoverage(coverageName);
        try {
            CoverageSource source = this.getGridCoverageSource(coverageName);
            VariableAdapter.UnidataSpatialDomain spatialDomain = (VariableAdapter.UnidataSpatialDomain)source.getSpatialDomain();
            GridEnvelope2D gridRange = spatialDomain.getGridGeometry().getGridRange2D();
            RasterLayout rasterElement = spatialDomain.getRasterElements(false, null).iterator().next();
            NetCDFImageReader reader = (NetCDFImageReader)((NetCDFAccess)this.access).reader;
            int dataType = 5;
            VariableAdapter descriptor = reader.getCoverageDescriptor((Name)new NameImpl(coverageName));
            if (descriptor != null) {
                dataType = descriptor.getSampleModel().getDataType();
            }
            BandedSampleModel sampleModel = new BandedSampleModel(dataType, (int)gridRange.getWidth(), (int)gridRange.getHeight(), 1);
            ColorModel colorModel = ImageIOUtilities.createColorModel((SampleModel)sampleModel);
            Rectangle rect = rasterElement.toRectangle();
            ImageLayout layout = new ImageLayout(rect.x, rect.y, rect.width, rect.height);
            layout.setSampleModel((SampleModel)sampleModel);
            layout.setColorModel(colorModel);
            return layout;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.getCoordinateReferenceSystem(UNSPECIFIED);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem(String coverageName) {
        coverageName = this.checkUnspecifiedCoverage(coverageName);
        try {
            CoverageSource source = this.getGridCoverageSource(coverageName);
            VariableAdapter.UnidataSpatialDomain spatialDomain = (VariableAdapter.UnidataSpatialDomain)source.getSpatialDomain();
            return spatialDomain.getCoordinateReferenceSystem2D();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MathTransform getOriginalGridToWorld(PixelInCell pixInCell) {
        return this.getOriginalGridToWorld(UNSPECIFIED, pixInCell);
    }

    public MathTransform getOriginalGridToWorld(String coverageName, PixelInCell pixInCell) {
        coverageName = this.checkUnspecifiedCoverage(coverageName);
        try {
            CoverageSource source = this.getGridCoverageSource(coverageName);
            VariableAdapter.UnidataSpatialDomain spatialDomain = (VariableAdapter.UnidataSpatialDomain)source.getSpatialDomain();
            MathTransform2D gridToWorld = spatialDomain.getGridToWorldTransform(null);
            if (pixInCell == PixelInCell.CELL_CENTER) {
                return gridToWorld;
            }
            if (gridToWorld instanceof AffineTransform) {
                AffineTransform tr = new AffineTransform((AffineTransform)gridToWorld);
                tr.concatenate(AffineTransform.getTranslateInstance(-0.5, -0.5));
                return ProjectiveTransform.create((AffineTransform)tr);
            }
            if (gridToWorld instanceof IdentityTransform) {
                AffineTransform tr = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                tr.concatenate(AffineTransform.getTranslateInstance(-0.5, -0.5));
                return ProjectiveTransform.create((AffineTransform)tr);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException("This reader's grid to world transform is invalid!");
    }

    public GranuleSource getGranules(String coverageName, boolean readOnly) throws IOException, UnsupportedOperationException {
        NetCDFImageReader reader = (NetCDFImageReader)((NetCDFAccess)this.access).reader;
        CoverageSlicesCatalog catalog = reader.getCatalog();
        return new CoverageSlicesCatalogSource(catalog, coverageName);
    }

    public boolean isReadOnly() {
        return true;
    }

    public void createCoverage(String coverageName, SimpleFeatureType schema) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("This operation is not supported on this reader");
    }

    public List<HarvestedSource> harvest(String defaultCoverage, Object source, Hints hints) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("This operation is not supported on this reader");
    }

    public List<DimensionDescriptor> getDimensionDescriptors(String coverageName) throws IOException {
        CoverageSource source = this.getGridCoverageSource(coverageName);
        return source.getDimensionDescriptors();
    }

    public boolean removeCoverage(String coverageName, boolean forceDelete) throws IOException, UnsupportedOperationException {
        NameImpl name;
        if (this.setNames.contains(coverageName)) {
            this.setNames.remove(coverageName);
        }
        if (!this.names.contains(name = new NameImpl(coverageName))) {
            return false;
        }
        this.access.delete((Name)name, null, this.hints);
        if (Objects.equals(this.defaultName, coverageName)) {
            Iterator<Name> iterator = this.names.iterator();
            this.defaultName = iterator.hasNext() ? iterator.next().toString() : null;
        }
        if (forceDelete) {
            this.delete(true);
        }
        return true;
    }

    public void delete(boolean deleteData) throws IOException {
        ((NetCDFAccess)this.access).purge();
        if (deleteData) {
            this.dispose();
            File file = URLs.urlToFile((URL)this.sourceURL);
            if (file != null && file.exists()) {
                file.delete();
            }
        }
    }

    public ResourceInfo getInfo(String coverageName) {
        String name = this.checkUnspecifiedCoverage(coverageName);
        return new NetCDFFileResourceInfo(this, name, ((NetCDFAccess)this.access).reader.getCatalog(), this.sourceURL);
    }
}

