/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;

class TemporalConverterFactoryHack
implements ConverterFactory {
    TemporalConverterFactoryHack() {
    }

    public Converter createConverter(Class source, Class target, Hints hints) {
        if (Date.class.isAssignableFrom(source) && String.class.equals((Object)target)) {
            final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            return new Converter(){

                public Object convert(Object source, Class target) throws Exception {
                    if (source instanceof Date) {
                        return df.format((Date)source);
                    }
                    return null;
                }
            };
        }
        if (Calendar.class.isAssignableFrom(source) && String.class.equals((Object)target)) {
            final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            return new Converter(){

                public Object convert(Object source, Class target) throws Exception {
                    if (source instanceof Calendar) {
                        return df.format(((Calendar)source).getTime());
                    }
                    return null;
                }
            };
        }
        if (XMLGregorianCalendar.class.isAssignableFrom(source) && String.class.equals((Object)target)) {
            final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            return new Converter(){

                public Object convert(Object source, Class target) throws Exception {
                    if (source instanceof XMLGregorianCalendar) {
                        return df.format(((XMLGregorianCalendar)source).toGregorianCalendar(TimeZone.getTimeZone("GMT"), Locale.getDefault(), null).getTime());
                    }
                    return null;
                }
            };
        }
        return null;
    }
}

