/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf.crs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.measure.Units;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.operation.DefiningConversion;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.InternationalString;
import si.uom.SI;
import tech.units.indriya.AbstractUnit;

public class ProjectionBuilder {
    private static final String NAME = "name";
    private static final String DEFAULT_DATUM_NAME = "unknown";
    public static final String AXIS_UNIT = "axisUnit";
    private static final MathTransformFactory mtFactory;
    public static final EllipsoidalCS DEFAULT_ELLIPSOIDAL_CS;
    private static final Logger LOGGER;

    public static CoordinateReferenceSystem createProjection(String projectionName, String code, Double semiMajor, Double inverseFlattening, Map<String, Double> params) throws FactoryException {
        ParameterValueGroup parameters = ProjectionBuilder.getProjectionParameters(projectionName);
        Ellipsoid ellipsoid = ProjectionBuilder.createEllipsoid(semiMajor, inverseFlattening);
        Set<String> keys = params.keySet();
        for (String key : keys) {
            parameters.parameter(key).setValue((Object)params.get(key));
        }
        return ProjectionBuilder.buildCRS(ProjectionBuilder.buildProperties(projectionName, Citations.EPSG, code), parameters, ellipsoid);
    }

    public static ParameterValueGroup getProjectionParameters(String projectionName) throws NoSuchIdentifierException {
        return mtFactory.getDefaultParameters(projectionName);
    }

    public static void updateEllipsoidParams(ParameterValueGroup parameters, Ellipsoid ellipsoid) {
        Utilities.ensureNonNull((String)"ellipsoid", (Object)ellipsoid);
        Utilities.ensureNonNull((String)"parameters", (Object)parameters);
        double semiMajor = ellipsoid.getSemiMajorAxis();
        double inverseFlattening = ellipsoid.getInverseFlattening();
        parameters.parameter(NetCDFUtilities.SEMI_MINOR).setValue(semiMajor * (1.0 - 1.0 / inverseFlattening));
        parameters.parameter(NetCDFUtilities.SEMI_MAJOR).setValue(semiMajor);
    }

    public static DefiningConversion createConversionFromBase(String name, MathTransform transform) {
        return new DefiningConversion(Collections.singletonMap(NAME, name), (OperationMethod)new DefaultOperationMethod(transform), transform);
    }

    static Map<String, Object> buildProperties(String name, Citation authority, String code) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(NAME, name);
        props.put("identifiers", new NamedIdentifier(authority, code));
        return props;
    }

    private static Ellipsoid createEllipsoid(Double semiMajor, Double inverseFlattening) {
        HashMap<String, Number> ellipsoidParams = new HashMap<String, Number>();
        ellipsoidParams.put(NetCDFUtilities.SEMI_MAJOR, semiMajor);
        if (!Double.isInfinite(inverseFlattening)) {
            ellipsoidParams.put("inverse_flattening", inverseFlattening);
        }
        return ProjectionBuilder.createEllipsoid(DEFAULT_DATUM_NAME, ellipsoidParams);
    }

    public static GeodeticDatum createGeodeticDatum(String name, Ellipsoid ellipsoid) {
        return new DefaultGeodeticDatum(name, ellipsoid, (PrimeMeridian)DefaultPrimeMeridian.GREENWICH);
    }

    public static GeographicCRS createGeographicCRS(String name, GeodeticDatum datum) {
        return ProjectionBuilder.createGeographicCRS(name, datum, DEFAULT_ELLIPSOIDAL_CS);
    }

    public static GeographicCRS createGeographicCRS(String name, GeodeticDatum datum, EllipsoidalCS ellipsoidalCS) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(NAME, name);
        return new DefaultGeographicCRS(props, datum, ellipsoidalCS);
    }

    public static ProjectedCRS createProjectedCRS(Map<String, ?> props, GeographicCRS baseCRS, DefiningConversion conversionFromBase, MathTransform transform) {
        return new DefaultProjectedCRS(props, (Conversion)conversionFromBase, baseCRS, transform, (CartesianCS)DefaultCartesianCS.PROJECTED);
    }

    public static ProjectedCRS createProjectedCRS(Map<String, ?> props, GeographicCRS baseCRS, DefiningConversion conversionFromBase, MathTransform transform, CartesianCS derivedCS) {
        return new DefaultProjectedCRS(props, (Conversion)conversionFromBase, baseCRS, transform, derivedCS);
    }

    public static Ellipsoid createEllipsoid(String name, Map<String, Number> ellipsoidParams) {
        Number semiMajor = 6371229.0;
        Number semiMinor = null;
        Number inverseFlattening = Double.NEGATIVE_INFINITY;
        if (ellipsoidParams != null && !ellipsoidParams.isEmpty()) {
            if (ellipsoidParams.containsKey(NetCDFUtilities.SEMI_MAJOR)) {
                semiMajor = ellipsoidParams.get(NetCDFUtilities.SEMI_MAJOR);
            }
            if (ellipsoidParams.containsKey(NetCDFUtilities.SEMI_MINOR)) {
                semiMinor = ellipsoidParams.get(NetCDFUtilities.SEMI_MINOR);
            }
            if (ellipsoidParams.containsKey("inverse_flattening")) {
                inverseFlattening = ellipsoidParams.get("inverse_flattening");
            }
        }
        if (semiMinor != null) {
            return DefaultEllipsoid.createEllipsoid((String)name, (double)semiMajor, (double)semiMinor.doubleValue(), (Unit)Units.METRE);
        }
        return DefaultEllipsoid.createFlattenedSphere((String)name, (double)semiMajor, (double)inverseFlattening, (Unit)Units.METRE);
    }

    public static CoordinateReferenceSystem buildCRS(Map<String, ?> props, ParameterValueGroup parameters, Ellipsoid ellipsoid) throws NoSuchIdentifierException, FactoryException {
        OperationMethod opMethod;
        ProjectionBuilder.updateEllipsoidParams(parameters, ellipsoid);
        GeodeticDatum datum = ProjectionBuilder.createGeodeticDatum(DEFAULT_DATUM_NAME, ellipsoid);
        GeographicCRS baseCRS = ProjectionBuilder.createGeographicCRS(DEFAULT_DATUM_NAME, datum);
        String name = DEFAULT_DATUM_NAME;
        Unit unit = ProjectionBuilder.getUnit(props);
        if (props != null && !props.isEmpty() && props.containsKey(NAME)) {
            name = (String)props.get(NAME);
        }
        DefiningConversion conversionFromBase = ProjectionBuilder.getConversion(parameters, name);
        AbstractCS derivedCS = ProjectionBuilder.createCoordinateSystem(name, unit);
        MathTransform transform = mtFactory.createBaseToDerived((CoordinateReferenceSystem)baseCRS, parameters, (CoordinateSystem)derivedCS);
        OperationMethod method = conversionFromBase.getMethod();
        if (!(method instanceof MathTransformProvider) && (opMethod = mtFactory.getLastMethodUsed()) instanceof MathTransformProvider) {
            HashMap copy = new HashMap(props);
            copy.put("conversionType", ((MathTransformProvider)opMethod).getOperationType());
            props = copy;
        }
        if (derivedCS instanceof DefaultCartesianCS) {
            return ProjectionBuilder.createProjectedCRS(props, baseCRS, conversionFromBase, transform, (CartesianCS)derivedCS);
        }
        DefaultCoordinateSystemAxis axis1 = new DefaultCoordinateSystemAxis((InternationalString)new SimpleInternationalString(name + " axis 0"), "0", AxisDirection.OTHER, AbstractUnit.ONE);
        DefaultCoordinateSystemAxis axis2 = new DefaultCoordinateSystemAxis((InternationalString)new SimpleInternationalString(name + " axis 1"), "1", AxisDirection.OTHER, AbstractUnit.ONE);
        AbstractCS cs = new AbstractCS(Collections.singletonMap(NAME, name), new CoordinateSystemAxis[]{axis1, axis2});
        CRSFactory factory = ReferencingFactoryFinder.getCRSFactory(null);
        DefiningConversion conversion = new DefiningConversion(Collections.singletonMap(NAME, method.getName().getCode()), method, transform);
        return factory.createDerivedCRS(Collections.singletonMap(NAME, name), (CoordinateReferenceSystem)baseCRS, (Conversion)conversion, (CoordinateSystem)cs);
    }

    public static DefiningConversion getConversion(ParameterValueGroup parameters, String name) {
        OperationMethod method = null;
        ReferenceIdentifier id = parameters.getDescriptor().getName();
        if (id != null && id.getCode() != null) {
            for (OperationMethod m : mtFactory.getAvailableMethods(Operation.class)) {
                if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)m, (String)id.getCode())) continue;
                method = m;
                break;
            }
        }
        if (method != null) {
            return new DefiningConversion(Collections.singletonMap(NAME, name), method, parameters);
        }
        return new DefiningConversion(name, parameters);
    }

    private static AbstractCS createCoordinateSystem(String name, Unit unit) {
        if (SI.METRE.isCompatible(unit) || AbstractUnit.ONE.equals(unit)) {
            return new DefaultCartesianCS(name, (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Vocabulary.formatInternational((int)55), "E", AxisDirection.EAST, unit), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Vocabulary.formatInternational((int)150), "N", AxisDirection.NORTH, unit));
        }
        if (SI.RADIAN.isCompatible(unit)) {
            return new DefaultEllipsoidalCS(name, DefaultGeographicCRS.WGS84.getAxis(0), DefaultGeographicCRS.WGS84.getAxis(1));
        }
        throw new IllegalArgumentException("No support for axis unit " + unit);
    }

    private static Unit getUnit(Map<String, ?> props) {
        Unit unit;
        block3: {
            unit = Units.METRE;
            if (props != null && !props.isEmpty() && props.containsKey(AXIS_UNIT)) {
                String axisUnit = (String)props.remove(AXIS_UNIT);
                try {
                    unit = axisUnit.equals("degrees") ? Units.DEGREE_ANGLE : Units.parseUnit((String)axisUnit);
                }
                catch (UnsupportedOperationException | MeasurementParseException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block3;
                    LOGGER.warning("Unabe to parse the specified axis unit: " + axisUnit + "Falling back on \"m (meter)\" as default for this projection's coordinate axis unit");
                }
            }
        }
        return unit;
    }

    public static MathTransform createTransform(ParameterValueGroup parameters) throws NoSuchIdentifierException, FactoryException {
        return mtFactory.createParameterizedTransform(parameters);
    }

    public static ParameterValueGroup getDefaultparameters(String projectionName) throws NoSuchIdentifierException {
        Utilities.ensureNonNull((String)"projectionName", (Object)projectionName);
        return mtFactory.getDefaultParameters(projectionName);
    }

    static {
        DEFAULT_ELLIPSOIDAL_CS = DefaultEllipsoidalCS.GEODETIC_2D.usingUnit(Units.DEGREE_ANGLE);
        Hints hints = GeoTools.getDefaultHints().clone();
        mtFactory = ReferencingFactoryFinder.getMathTransformFactory((Hints)hints);
        LOGGER = Logging.getLogger(ProjectionBuilder.class);
    }
}

