/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf.tools;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.geotools.imageio.netcdf.NetCDFImageReaderSpi;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.logging.Logging;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPathFactory;

public class CreateIndexer {
    private static final String ELEVATION_ATTRIB_TYPE_FLOAT = "java.lang.Float";
    private static final String ELEVATION_ATTRIB_TYPE_DOUBLE = "java.lang.Double";
    private static final String TIME_ATTRIB_TYPE = "java.util.Date";
    static final Logger LOGGER = Logging.getLogger(CreateIndexer.class);

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static void main(String[] args) throws JDOMException, IOException, TransformerException {
        if (args.length < 1) {
            System.out.println("Usage: java -jar CreateIndexer /path/to/sampleFile.nc [-P /path/to/netcdfprojectionsfile]\n [-cd [=create sample_datastore.properties]]\n [/path/to/optional/outputFolder]\n");
            System.exit(1);
        }
        int numArgs = args.length;
        String sampleFilePath = args[0];
        boolean hasProjection = false;
        int nextArgs = 1;
        boolean createDatastoreProperties = false;
        if (numArgs > nextArgs && args[nextArgs].equalsIgnoreCase("-p")) {
            hasProjection = true;
            ++nextArgs;
        }
        if (hasProjection) {
            String projectionFilePath = args[nextArgs++];
            System.out.println("Setting netcdf.projections.file = " + projectionFilePath);
            System.setProperty("netcdf.projections.file", projectionFilePath);
        }
        if (numArgs > nextArgs && args[nextArgs].equalsIgnoreCase("-cd")) {
            createDatastoreProperties = true;
            ++nextArgs;
        }
        String providedOutputPath = null;
        if (numArgs > nextArgs) {
            providedOutputPath = args[nextArgs++];
        }
        if (!hasProjection) {
            System.out.println("No custom projections will be supported");
        }
        System.setProperty("org.geotools.netcdf.quickscan", "TRUE");
        File sampleFile = new File(sampleFilePath);
        File temp = File.createTempFile("XML", "NC");
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        System.setProperty("NETCDF_DATA_DIR", temp.getAbsolutePath());
        System.out.println("Reading sample file: " + sampleFilePath);
        ImageReader reader = new NetCDFImageReaderSpi().createReaderInstance();
        reader.setInput(sampleFile);
        reader.dispose();
        File[] files = temp.listFiles((FileFilter)FileFilterUtils.directoryFileFilter());
        if (files == null) {
            System.out.println("Could not list files in " + temp);
            System.exit(2);
        }
        files = files[0].listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)"xml"));
        File auxiliaryFile = files[0];
        String parentFolder = CreateIndexer.setOuputFolder(providedOutputPath, sampleFile);
        String indexerFilePath = parentFolder + File.separatorChar + "indexer.xml";
        String auxiliaryFilePath = parentFolder + File.separatorChar + "_auxiliary.xml";
        String datastorePath = parentFolder + File.separatorChar + "datastore.properties";
        File finalAuxFile = new File(auxiliaryFilePath);
        CreateIndexer.formatAuxiliaryXml(auxiliaryFile, finalAuxFile);
        System.out.println("Grabbing the generated xml: " + finalAuxFile);
        SAXBuilder saxBuilder = new SAXBuilder();
        Document doc = saxBuilder.build(finalAuxFile);
        Element root = doc.getRootElement();
        HashSet<String> timeAttributes = new HashSet<String>();
        HashSet<String> elevationAttributes = new HashSet<String>();
        CreateIndexer.getAttributes(timeAttributes, elevationAttributes, root);
        StringBuilder builder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        builder.append("<Indexer>\n");
        CreateIndexer.setDomains(timeAttributes, elevationAttributes, builder);
        boolean longNameFound = CreateIndexer.setCoverages(root, builder);
        CreateIndexer.setParameters(auxiliaryFilePath, builder, longNameFound);
        CreateIndexer.writeIndexer(builder.toString(), indexerFilePath);
        System.out.println("Deleting temporary folder");
        if (!FileUtils.deleteQuietly((File)temp)) {
            System.out.println("Unable to delete folder: " + temp);
        }
        if (createDatastoreProperties) {
            CreateIndexer.writeDatastorePropertyFile(datastorePath);
        }
        System.out.println("DONE!!");
    }

    private static void writeDatastorePropertyFile(String datastorePath) throws IOException {
        System.out.println("Writing the sample datastore.properties: " + datastorePath);
        try (PrintWriter out = new PrintWriter(new File(datastorePath));){
            out.write("SPI=org.geotools.data.postgis.PostgisNGDataStoreFactory\n");
            out.write("host=localhost\n");
            out.write("port=5432\n");
            out.write("database=sampledb\n");
            out.write("user=postgres\n");
            out.write("passwd=postgres\n");
            out.write("schema=myschema\n");
            out.write("Estimated\\ extends=false\n");
            out.write("Loose\\ bbox=true\n");
            out.write("driver=org.postgresql.Driver");
            out.flush();
        }
    }

    private static String setOuputFolder(String providedOutputPath, File sampleFile) {
        String outputPath = FilenameUtils.getFullPathNoEndSeparator((String)sampleFile.getAbsolutePath());
        if (providedOutputPath != null) {
            outputPath = providedOutputPath;
            System.out.println("Output folder has been specified: " + outputPath);
            File outputFolder = new File(outputPath);
            if (!outputFolder.exists()) {
                System.out.println("Creating it");
                outputFolder.mkdirs();
            }
        } else {
            System.out.println("Output folder hasn't been specified. The files will be created beside the sample file, at: " + outputPath);
        }
        return outputPath;
    }

    private static void writeIndexer(String xml, String indexerFilePath) throws FileNotFoundException {
        System.out.println("Writing the indexer.xml: " + indexerFilePath);
        try (PrintWriter out = new PrintWriter(indexerFilePath);){
            out.println(xml);
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void formatAuxiliaryXml(File auxiliaryFile, File finalAuxFile) throws FileNotFoundException, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StreamResult result = new StreamResult(new StringWriter());
        FileInputStream is = null;
        PrintWriter out = null;
        try {
            is = new FileInputStream(auxiliaryFile);
            transformer.transform(new StreamSource(is), result);
            String xmlString = result.getWriter().toString();
            out = new PrintWriter(finalAuxFile);
            out.println(xmlString);
            out.flush();
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void setParameters(String auxiliaryFilePath, StringBuilder builder, boolean longNameFound) {
        builder.append("  <parameters>\n");
        builder.append("    <parameter name=\"AuxiliaryFile\" value=\"" + auxiliaryFilePath + "\" />\n");
        builder.append("    <parameter name=\"AbsolutePath\" value=\"true\" />\n");
        if (longNameFound) {
            builder.append("    <parameter name=\"WrapStore\" value=\"true\" />\n");
        }
        builder.append("  </parameters>\n");
        builder.append("</Indexer>\n");
    }

    private static boolean setCoverages(Element root, StringBuilder builder) throws JDOMException {
        builder.append("  <coverages>\n");
        List coverages = XPathFactory.instance().compile("coverages/coverage").evaluate((Object)root);
        boolean longName = false;
        for (Object cov : coverages) {
            if (!(cov instanceof Element) || !CreateIndexer.setCoverage((Element)cov, builder)) continue;
            longName = true;
        }
        builder.append("  </coverages>\n");
        return longName;
    }

    private static boolean setCoverage(Element cov, StringBuilder builder) throws JDOMException {
        builder.append("    <coverage>\n");
        Element name = (Element)XPathFactory.instance().compile("name").evaluateFirst((Object)cov);
        String coverageName = name.getText();
        builder.append("      <name>" + coverageName + "</name>\n");
        Element schema = (Element)XPathFactory.instance().compile("schema").evaluateFirst((Object)cov);
        String schemaName = schema.getAttributeValue("name");
        builder.append("      <schema name=\"" + schemaName + "\" >\n");
        Element schemaAttributesElement = (Element)XPathFactory.instance().compile("attributes").evaluateFirst((Object)schema);
        String schemaAttribs = schemaAttributesElement.getText();
        schemaAttribs = schemaAttribs.replace("imageindex:Integer", "imageindex:Integer,location:String");
        builder.append("        <attributes>" + schemaAttribs + "</attributes>\n");
        builder.append("      </schema>\n");
        CreateIndexer.addDomainsToCoverage(schemaAttribs, builder);
        builder.append("    </coverage>\n");
        return coverageName.length() > 62;
    }

    private static void addDomainsToCoverage(String schemaAttribs, StringBuilder builder) {
        String[] schemaAttributesValues;
        HashSet<String> domains = new HashSet<String>();
        for (String schemaAttr : schemaAttributesValues = schemaAttribs.split(",")) {
            String[] nameTypePair;
            if (schemaAttr.contains(TIME_ATTRIB_TYPE)) {
                nameTypePair = schemaAttr.split(":");
                domains.add(nameTypePair[0]);
            }
            if (!schemaAttr.contains(ELEVATION_ATTRIB_TYPE_FLOAT) && !schemaAttr.contains(ELEVATION_ATTRIB_TYPE_DOUBLE)) continue;
            nameTypePair = schemaAttr.split(":");
            domains.add(nameTypePair[0]);
        }
        if (!domains.isEmpty()) {
            builder.append("      <domains>\n");
            Iterator it = domains.iterator();
            while (it.hasNext()) {
                builder.append("        <domain ref=\"" + (String)it.next() + "\" />\n");
            }
            builder.append("      </domains>\n");
        }
    }

    private static void getAttributes(Set<String> timeAttributes, Set<String> elevationAttributes, Element root) throws JDOMException {
        List schemaAttributes = XPathFactory.instance().compile("coverages/coverage/schema/attributes").evaluate((Object)root);
        for (Object e : schemaAttributes) {
            String[] attribs;
            if (!(e instanceof Element)) continue;
            String attributes = ((Element)e).getText();
            for (String attrib : attribs = attributes.split(",")) {
                String name;
                String[] nameTypePair;
                if (attrib.contains(TIME_ATTRIB_TYPE)) {
                    nameTypePair = attrib.split(":");
                    name = nameTypePair[0];
                    if (timeAttributes.contains(name)) continue;
                    timeAttributes.add(name);
                    continue;
                }
                if (!attrib.contains(ELEVATION_ATTRIB_TYPE_FLOAT) && !attrib.contains(ELEVATION_ATTRIB_TYPE_DOUBLE) || elevationAttributes.contains(name = (nameTypePair = attrib.split(":"))[0])) continue;
                elevationAttributes.add(name);
            }
        }
    }

    private static void setDomains(Set<String> timeAttributes, Set<String> elevationAttributes, StringBuilder builder) {
        builder.append("  <domains>\n");
        for (String timeDomain : timeAttributes) {
            CreateIndexer.setDomain(builder, timeDomain);
        }
        for (String elevationDomain : elevationAttributes) {
            CreateIndexer.setDomain(builder, elevationDomain);
        }
        builder.append("  </domains>\n");
    }

    private static void setDomain(StringBuilder builder, String domain) {
        builder.append("    <domain name=\"" + domain + "\">\n");
        builder.append("      <attributes><attribute>" + domain + "</attribute></attributes>\n");
        builder.append("    </domain>\n");
    }
}

