/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.io.netcdf.crs.NetCDFProjection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.imageio.netcdf.cv.CoordinateVariable;
import org.geotools.imageio.netcdf.utilities.NetCDFCRSUtilities;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;

class NetCDFGeoreferenceManager {
    private static final Logger LOGGER = Logging.getLogger(NetCDFGeoreferenceManager.class);
    private boolean hasSingleBBox = true;
    private BBoxGetter bbox;
    private Map<String, CoordinateVariable<?>> coordinatesVariables;
    static final String DEFAULT = "Default";
    private boolean needsFlipping = false;
    private NetcdfDataset dataset;
    private DimensionMapper dimensionMapper;
    private boolean isLonLat;

    public boolean isNeedsFlipping() {
        return this.needsFlipping;
    }

    public void setNeedsFlipping(boolean needsFlipping) {
        this.needsFlipping = needsFlipping;
    }

    public boolean isLonLat() {
        return this.isLonLat;
    }

    public boolean isHasSingleBBox() {
        return this.hasSingleBBox;
    }

    public void setHasSingleBBox(boolean hasSingleBBox) {
        this.hasSingleBBox = hasSingleBBox;
    }

    public CoordinateVariable<?> getCoordinateVariable(String name) {
        return this.coordinatesVariables.get(name);
    }

    public Collection<CoordinateVariable<?>> getCoordinatesVariables() {
        return this.coordinatesVariables.values();
    }

    public void dispose() {
        if (this.coordinatesVariables != null) {
            this.coordinatesVariables.clear();
        }
        this.bbox.dispose();
    }

    public ReferencedEnvelope getBoundingBox(String shortName) {
        return this.bbox.getBBox(this.hasSingleBBox ? DEFAULT : shortName);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem(String shortName) {
        ReferencedEnvelope envelope = this.getBoundingBox(shortName);
        if (envelope != null) {
            return envelope.getCoordinateReferenceSystem();
        }
        throw new IllegalArgumentException("Unable to find a CRS for the provided variable: " + shortName);
    }

    private String getCoordinatesForVariable(String shortName) {
        Variable var = this.dataset.findVariable(null, shortName);
        if (var != null) {
            Attribute attribute = var.findAttribute("coordinates");
            if (attribute != null) {
                return attribute.getStringValue();
            }
            return var.getDimensionsString();
        }
        return null;
    }

    public Collection<CoordinateVariable<?>> getCoordinatesVariables(String shortName) {
        if (this.hasSingleBBox) {
            return this.coordinatesVariables.values();
        }
        String coordinates = this.getCoordinatesForVariable(shortName);
        String[] coords = coordinates.split(" ");
        ArrayList coordVar = new ArrayList();
        for (String coord : coords) {
            coordVar.add(this.coordinatesVariables.get(coord));
        }
        return coordVar;
    }

    public DimensionMapper getDimensionMapper() {
        return this.dimensionMapper;
    }

    public NetCDFGeoreferenceManager(NetcdfDataset dataset) {
        this.dataset = dataset;
        this.initCoordinates();
        try {
            this.initBBox();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (FactoryException fe) {
            throw new RuntimeException(fe);
        }
    }

    private void initCoordinates() {
        HashMap coordinates = new HashMap();
        Set<String> unsupported = NetCDFUtilities.getUnsupportedDimensions();
        Set<String> ignored = NetCDFUtilities.getIgnoredDimensions();
        for (CoordinateAxis axis : this.dataset.getCoordinateAxes()) {
            int axisDimensions = axis.getDimensions().size();
            if (axisDimensions <= 0 || axisDimensions >= 3) continue;
            String axisName = axis.getFullName();
            if (axis.getAxisType() != null) {
                coordinates.put(axisName, CoordinateVariable.create(axis));
                continue;
            }
            if (unsupported.contains(axisName)) {
                axis.setAxisType(AxisType.GeoZ);
                coordinates.put(axisName, CoordinateVariable.create(axis));
                continue;
            }
            if ("time".equals(axisName)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Detected unparseable unit string in time axis: '" + axis.getUnitsString() + "'.");
                }
                axis.setAxisType(AxisType.Time);
                coordinates.put(axisName, CoordinateVariable.create(axis));
                continue;
            }
            if (ignored.contains(axisName)) continue;
            LOGGER.warning("Unsupported axis: " + axis + " in input: " + this.dataset.getLocation() + " has been found");
        }
        this.coordinatesVariables = coordinates;
        this.dimensionMapper = new DimensionMapper(coordinates);
    }

    private void initBBox() throws IOException, FactoryException {
        this.bbox = this.hasSingleBBox ? new BBoxGetter() : new MultipleBBoxGetter();
    }

    private void getCoordinate(CoordinateVariable<?> cv, double[] coordinate) throws IOException {
        if (cv.isRegular()) {
            coordinate[0] = cv.getStart() - cv.getIncrement() / 2.0;
            coordinate[1] = coordinate[0] + cv.getIncrement() * (double)cv.getSize();
        } else {
            double min = ((Number)cv.getMinimum()).doubleValue();
            double max = ((Number)cv.getMaximum()).doubleValue();
            double incr = (max - min) / (double)(cv.getSize() - 1L);
            coordinate[0] = min - incr / 2.0;
            coordinate[1] = max + incr / 2.0;
        }
    }

    class DimensionMapper {
        private Map<String, String> dimensions;

        public Map<String, String> getDimensions() {
            return this.dimensions;
        }

        public Set<String> getDimensionNames() {
            return this.dimensions.keySet();
        }

        public String getDimension(String coordinateVariableName) {
            return this.dimensions.get(coordinateVariableName);
        }

        public DimensionMapper(Map<String, CoordinateVariable<?>> coordinates) {
            int coordinates2Dx = 0;
            int coordinates2Dy = 0;
            this.dimensions = new HashMap<String, String>();
            TreeSet<String> coordinateKeys = new TreeSet<String>(coordinates.keySet());
            block6: for (String key : coordinateKeys) {
                CoordinateVariable<?> cv = NetCDFGeoreferenceManager.this.getCoordinateVariable(key);
                if (cv != null) {
                    String name = cv.getName();
                    AxisType axisType = cv.getAxisType();
                    switch (axisType) {
                        case GeoX: 
                        case Lon: {
                            ++coordinates2Dx;
                            continue block6;
                        }
                        case GeoY: 
                        case Lat: {
                            ++coordinates2Dy;
                            continue block6;
                        }
                        case Height: 
                        case Pressure: 
                        case RadialElevation: 
                        case RadialDistance: 
                        case GeoZ: {
                            if (NetCDFCRSUtilities.VERTICAL_AXIS_NAMES.contains(name) && !this.dimensions.containsKey(NetCDFUtilities.ELEVATION_DIM)) {
                                this.dimensions.put(NetCDFUtilities.ELEVATION_DIM, name);
                                break;
                            }
                            this.dimensions.put(name.toUpperCase(), name);
                            break;
                        }
                        case Time: {
                            if (!this.dimensions.containsKey(NetCDFUtilities.TIME_DIM)) {
                                this.dimensions.put(NetCDFUtilities.TIME_DIM, name);
                                break;
                            }
                            this.dimensions.put(name.toUpperCase(), name);
                            break;
                        }
                        default: {
                            this.dimensions.put(name.toUpperCase(), name);
                            break;
                        }
                    }
                    continue;
                }
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("Null coordinate variable: '" + key + "' while processing input: " + NetCDFGeoreferenceManager.this.dataset.getLocation());
            }
            if (coordinates2Dx + coordinates2Dy > 2) {
                if (coordinates2Dx != coordinates2Dy) {
                    throw new IllegalArgumentException("number of x/lon coordinates must match number of y/lat coordinates");
                }
                NetCDFGeoreferenceManager.this.setHasSingleBBox(false);
            }
        }

        public void remap(String dimension, String name) {
            this.dimensions.put(dimension, name);
        }
    }

    class MultipleBBoxGetter
    extends BBoxGetter {
        @Override
        protected void init() throws FactoryException, IOException {
            NetCDFGeoreferenceManager.this.isLonLat = false;
            CoordinatesManager manager = new CoordinatesManager();
            for (CoordinateVariable<?> cv : NetCDFGeoreferenceManager.this.getCoordinatesVariables()) {
                if (!cv.isNumeric()) continue;
                AxisType type = cv.getAxisType();
                switch (type) {
                    case GeoY: 
                    case Lat: {
                        manager.setYLat(cv);
                        break;
                    }
                    case GeoX: 
                    case Lon: {
                        manager.setXlon(cv);
                        break;
                    }
                }
            }
            CoordinateReferenceSystem crs = NetCDFCRSUtilities.WGS84;
            List variables = NetCDFGeoreferenceManager.this.dataset.getVariables();
            for (Variable var : variables) {
                Attribute gridMappingAttribute = var.findAttribute("grid_mapping");
                String coordinates = manager.getCoordinateNames(var);
                if (coordinates == null || this.boundingBoxes.containsKey(coordinates)) continue;
                crs = this.lookForCrs(crs, gridMappingAttribute, var);
                ReferencedEnvelope boundingBox = manager.computeEnvelope(coordinates, crs);
                this.boundingBoxes.put(coordinates, boundingBox);
            }
            manager.dispose();
        }

        @Override
        public ReferencedEnvelope getBBox(String shortName) {
            String coordinates = NetCDFGeoreferenceManager.this.getCoordinatesForVariable(shortName);
            if (coordinates != null) {
                return (ReferencedEnvelope)this.boundingBoxes.get(coordinates);
            }
            throw new IllegalArgumentException("Unable to find an envelope for the provided variable: " + shortName);
        }

        private CoordinateReferenceSystem lookForCrs(CoordinateReferenceSystem crs, Attribute gridMappingAttribute, Variable var) throws FactoryException {
            if (gridMappingAttribute != null) {
                Variable mapping;
                String gridMappingName = gridMappingAttribute.getStringValue();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("The variable refers to gridMapping: " + gridMappingName);
                }
                if ((mapping = NetCDFGeoreferenceManager.this.dataset.findVariable(null, gridMappingName)) != null) {
                    CoordinateReferenceSystem localCrs = NetCDFProjection.parseProjection(mapping);
                    if (localCrs != null) {
                        crs = NetCDFProjection.lookupForCustomEpsg(localCrs);
                    }
                } else if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("The specified variable " + var.getFullName() + " declares a gridMapping = " + gridMappingName + " but that mapping doesn't exist.");
                }
            }
            return crs;
        }

        class CoordinatesManager {
            private Map<String, double[]> xLonCoords = new HashMap<String, double[]>();
            private Map<String, double[]> yLatCoords = new HashMap<String, double[]>();

            CoordinatesManager() {
            }

            public void setYLat(CoordinateVariable<?> cv) throws IOException {
                double[] yLat = new double[2];
                NetCDFGeoreferenceManager.this.getCoordinate(cv, yLat);
                if (yLat[1] > yLat[0]) {
                    NetCDFGeoreferenceManager.this.setNeedsFlipping(true);
                } else {
                    NetCDFGeoreferenceManager.this.setNeedsFlipping(false);
                }
                this.yLatCoords.put(cv.getName(), yLat);
            }

            public void setXlon(CoordinateVariable<?> cv) throws IOException {
                double[] xLon = new double[2];
                NetCDFGeoreferenceManager.this.getCoordinate(cv, xLon);
                this.xLonCoords.put(cv.getName(), xLon);
            }

            public ReferencedEnvelope computeEnvelope(String coordinates, CoordinateReferenceSystem crs) {
                Utilities.ensureNonNull((String)"coordinates", (Object)coordinates);
                String[] coords = coordinates.split(" ");
                double[] xLon = null;
                double[] yLat = null;
                for (String coord : coords) {
                    if (this.xLonCoords.containsKey(coord)) {
                        xLon = this.xLonCoords.get(coord);
                        continue;
                    }
                    if (!this.yLatCoords.containsKey(coord)) continue;
                    yLat = this.yLatCoords.get(coord);
                }
                if (xLon == null || yLat == null) {
                    throw new IllegalArgumentException("Unable to initialize the boundingBox due to missing coordinates ");
                }
                return new ReferencedEnvelope((double)xLon[0], (double)xLon[1], (double)yLat[0], (double)yLat[1], crs);
            }

            public String getCoordinateNames(Variable var) {
                String dimensions;
                String coordinates = null;
                Attribute coordinatesAttribute = var.findAttribute("coordinates");
                boolean hasXLon = false;
                boolean hasYLat = false;
                if (coordinatesAttribute != null) {
                    coordinates = coordinatesAttribute.getStringValue();
                } else if (!(var instanceof CoordinateAxis) && (dimensions = var.getDimensionsString()) != null && !dimensions.isEmpty()) {
                    coordinates = dimensions;
                }
                if (coordinates != null) {
                    for (String coord : coordinates.split(" ")) {
                        if (this.xLonCoords.containsKey(coord)) {
                            hasXLon = true;
                            continue;
                        }
                        if (!this.yLatCoords.containsKey(coord)) continue;
                        hasYLat = true;
                    }
                }
                return hasXLon && hasYLat ? coordinates : null;
            }

            public void dispose() {
                if (this.xLonCoords != null) {
                    this.xLonCoords.clear();
                    this.xLonCoords = null;
                }
                if (this.yLatCoords != null) {
                    this.yLatCoords.clear();
                    this.yLatCoords = null;
                }
            }
        }
    }

    class BBoxGetter {
        protected Map<String, ReferencedEnvelope> boundingBoxes = new HashMap<String, ReferencedEnvelope>();

        public BBoxGetter() throws FactoryException, IOException {
            this.init();
        }

        protected void init() throws FactoryException, IOException {
            double[] xLon = new double[2];
            double[] yLat = new double[2];
            int set = 0;
            NetCDFGeoreferenceManager.this.isLonLat = false;
            HashMap<String, Object> crsProperties = new HashMap<String, Object>();
            String axisUnit = null;
            for (CoordinateVariable<?> cv : NetCDFGeoreferenceManager.this.getCoordinatesVariables()) {
                if (cv.isNumeric()) {
                    AxisType type = cv.getAxisType();
                    switch (type) {
                        case GeoY: 
                        case Lat: {
                            NetCDFGeoreferenceManager.this.getCoordinate(cv, yLat);
                            if (yLat[1] > yLat[0]) {
                                NetCDFGeoreferenceManager.this.setNeedsFlipping(true);
                            } else {
                                NetCDFGeoreferenceManager.this.setNeedsFlipping(false);
                            }
                            set = (byte)(set + 1);
                            break;
                        }
                        case GeoX: 
                        case Lon: {
                            NetCDFGeoreferenceManager.this.getCoordinate(cv, xLon);
                            set = (byte)(set + 1);
                            break;
                        }
                    }
                    switch (type) {
                        case Lat: 
                        case Lon: {
                            NetCDFGeoreferenceManager.this.isLonLat = true;
                            break;
                        }
                        case GeoY: 
                        case GeoX: {
                            axisUnit = cv.getUnit();
                            break;
                        }
                    }
                }
                if (set != 2) continue;
                break;
            }
            if (set != 2) {
                throw new IllegalStateException("Unable to create envelope for this dataset");
            }
            if (!NetCDFCRSUtilities.isConvertAxisKm() && axisUnit != null) {
                crsProperties.put("axisUnit", axisUnit);
            }
            CoordinateReferenceSystem crs = NetCDFCRSUtilities.WGS84;
            if (!NetCDFGeoreferenceManager.this.isLonLat) {
                CoordinateReferenceSystem defaultCrs = NetCDFProjection.lookForDatasetCRS(NetCDFGeoreferenceManager.this.dataset);
                CoordinateReferenceSystem localCrs = NetCDFProjection.lookForVariableCRS(NetCDFGeoreferenceManager.this.dataset, defaultCrs, crsProperties);
                if (localCrs != null) {
                    crs = NetCDFProjection.lookupForCustomEpsg(localCrs);
                }
            }
            ReferencedEnvelope boundingBox = new ReferencedEnvelope(xLon[0], xLon[1], yLat[0], yLat[1], crs);
            this.boundingBoxes.put(NetCDFGeoreferenceManager.DEFAULT, boundingBox);
        }

        public void dispose() {
            if (this.boundingBoxes != null) {
                this.boundingBoxes.clear();
            }
        }

        public ReferencedEnvelope getBBox(String bboxName) {
            return this.boundingBoxes.get(bboxName);
        }
    }
}

