/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.MeasurementParseException;
import javax.measure.format.UnitFormat;
import org.geotools.util.GeoToolsUnitFormat;
import org.geotools.util.logging.Logging;
import si.uom.NonSI;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.function.LogConverter;

public class NetCDFUnitFormat {
    static final Logger LOGGER = Logging.getLogger(NetCDFUnitFormat.class);
    private static SimpleUnitFormat FORMAT;
    private static Map<String, String> REPLACEMENTS;
    public static final String NETCDF_UNIT_ALIASES = "netcdf-unit-aliases.properties";
    public static final String NETCDF_UNIT_REPLACEMENTS = "netcdf-unit-replacements.properties";
    private static Map<String, String> CONTENT_REPLACEMENTS;

    public static void reset() {
        Map<String, String> replacements = NetCDFUnitFormat.loadBuiltInConfigFile(NETCDF_UNIT_REPLACEMENTS);
        NetCDFUnitFormat.setReplacements(replacements);
        Map<String, String> aliases = NetCDFUnitFormat.loadBuiltInConfigFile(NETCDF_UNIT_ALIASES);
        NetCDFUnitFormat.setAliases(aliases);
    }

    public static void setReplacements(Map<String, String> replacements) {
        REPLACEMENTS = new LinkedHashMap<String, String>(replacements);
    }

    public static LinkedHashMap<String, String> loadPropertiesOrdered(InputStream is) {
        try {
            final LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            Properties props = new Properties(){

                @Override
                public Object put(Object key, Object value) {
                    result.put((String)key, (String)value);
                    return super.put(key, value);
                }
            };
            props.load(new InputStreamReader(is, StandardCharsets.UTF_8));
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load the build-in config file: netcdf-unit-aliases.properties" + e);
        }
    }

    private static Map<String, String> loadBuiltInConfigFile(String fileName) {
        return NetCDFUnitFormat.loadPropertiesOrdered(NetCDFUnitFormat.class.getResourceAsStream(fileName));
    }

    public static void setAliases(Map<String, String> aliases) {
        SimpleUnitFormat format = AbstractNetCDFUnitFormat.getNewInstance();
        Unit bel = AbstractUnit.ONE.transform((UnitConverter)new LogConverter(10.0));
        format.alias(bel.divide(10.0), "dB");
        for (Unit unit : NonSI.getInstance().getUnits()) {
            if (unit.getSymbol() == null || !NetCDFUnitFormat.unknownSymbol(format, unit.getSymbol())) continue;
            format.alias(unit, unit.getSymbol());
        }
        format.label(AbstractUnit.ONE, "unitless");
        for (Map.Entry entry : aliases.entrySet()) {
            try {
                format.alias(format.parse((CharSequence)entry.getValue()), (String)entry.getKey());
            }
            catch (MeasurementParseException ex) {
                LOGGER.log(Level.WARNING, "Failed to parse " + (String)entry.getKey() + " -> " + (String)entry.getValue() + ", skipped.", ex);
            }
        }
        FORMAT = format;
    }

    private static boolean unknownSymbol(SimpleUnitFormat format, String symbol) {
        try {
            format.parse((CharSequence)symbol);
            return false;
        }
        catch (MeasurementParseException e) {
            return true;
        }
    }

    public static Unit<?> parse(String spec) {
        boolean replaced = false;
        for (Map.Entry<String, String> entry : REPLACEMENTS.entrySet()) {
            replaced = spec.equals(entry.getKey());
            spec = spec.replace(entry.getKey(), entry.getValue());
            if (!replaced) continue;
            break;
        }
        if (!replaced) {
            for (Map.Entry<String, String> entry : CONTENT_REPLACEMENTS.entrySet()) {
                spec = spec.replace(entry.getKey(), entry.getValue());
            }
        }
        try {
            return FORMAT.parse((CharSequence)spec);
        }
        catch (MeasurementParseException e) {
            throw new MeasurementParseException("Failed to parse " + spec, (CharSequence)e.getParsedString(), e.getPosition());
        }
    }

    public static String format(Unit<?> unit) {
        return FORMAT.format(unit);
    }

    private NetCDFUnitFormat() {
    }

    static {
        CONTENT_REPLACEMENTS = new LinkedHashMap(){
            {
                this.put(" ", "*");
                this.put("-", "^-");
                this.put(".", "*");
            }
        };
        NetCDFUnitFormat.reset();
    }

    public static abstract class AbstractNetCDFUnitFormat
    extends GeoToolsUnitFormat {
        public static SimpleUnitFormat getNewInstance() {
            return new InternalFormat();
        }

        static class InternalFormat
        extends GeoToolsUnitFormat.BaseGT2Format {
            public InternalFormat() {
                super.initUnits((UnitFormat)SimpleUnitFormat.getInstance());
            }
        }
    }
}

