/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf;

import it.geosolutions.imageio.stream.eraf.EnhancedRandomAccessFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public class Slice2DIndex {
    public static final int DEFAULT_INDEX = -1;
    private int[] index;
    private final String variableName;

    public Slice2DIndex(String variableName) {
        this(new int[0], variableName);
    }

    public Slice2DIndex(int[] index, String variableName) {
        Utilities.ensureNonNull((String)"variableName", (Object)variableName);
        Utilities.ensureNonNull((String)"index", (Object)index);
        this.index = index;
        this.variableName = variableName;
    }

    public int getNIndex(int n) {
        return this.index.length > 0 ? this.index[n] : -1;
    }

    public int getNCount() {
        return this.index.length;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String toString() {
        return "UnidataVariableIndex [index=" + Arrays.toString(this.index) + ", variableName=" + this.variableName + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (int i = 0; i < this.index.length; ++i) {
            result = 31 * result + this.index[i];
        }
        result = 31 * result + (this.variableName == null ? 0 : this.variableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Slice2DIndex other = (Slice2DIndex)obj;
        if (this.variableName == null ? other.variableName != null : !this.variableName.equals(other.variableName)) {
            return false;
        }
        if (this.index == null) {
            return other.index == null;
        }
        if (other.index == null) {
            return this.index == null;
        }
        if (this.index.length != other.index.length) {
            return false;
        }
        for (int i = 0; i < this.index.length; ++i) {
            if (this.index[i] == other.index[i]) continue;
            return false;
        }
        return true;
    }

    public static class Slice2DIndexManager {
        static final Logger LOGGER = Logging.getLogger(Slice2DIndexManager.class);
        private static final long ADDRESS_SIZE = 8L;
        private static long ADDRESS_POSITION = 4L;
        private EnhancedRandomAccessFile raf;
        private File file;
        private int numberOfRecords;
        private Throwable tracer;

        public Slice2DIndexManager(File file) {
            this.file = file;
        }

        public void open() throws IOException {
            this.raf = new EnhancedRandomAccessFile(this.file, "r");
            this.raf.setByteOrder(ByteOrder.BIG_ENDIAN);
            this.numberOfRecords = this.raf.readInt();
            if (NetCDFUtilities.TRACE_ENABLED.booleanValue()) {
                this.tracer = new Exception();
                this.tracer.fillInStackTrace();
            }
        }

        public synchronized Slice2DIndex getSlice2DIndex(int imageIndex) throws IOException {
            int[] index;
            long addressPosition = ADDRESS_POSITION + (long)imageIndex * 8L;
            this.raf.seek(addressPosition);
            long dataPosition = this.raf.readLong();
            long endDataPosition = this.raf.readLong();
            this.raf.seek(dataPosition);
            int nextValue = this.raf.readInt();
            if (nextValue < 0) {
                int dimensions = -nextValue;
                index = new int[dimensions];
                for (int i = 0; i < dimensions; ++i) {
                    index[i] = this.raf.readInt();
                }
            } else {
                index = new int[2];
                index[1] = nextValue;
                index[0] = this.raf.readInt();
            }
            int stringSize = (int)(endDataPosition - this.raf.getFilePointer());
            byte[] stringBytes = new byte[stringSize];
            this.raf.read(stringBytes);
            String varName = new String(stringBytes);
            return new Slice2DIndex(index, varName);
        }

        public void dispose() throws IOException {
            if (this.raf != null) {
                this.raf.close();
                this.raf = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void writeIndexFile(File file, List<Slice2DIndex> indexList) throws IOException {
            try (RandomAccessFile raf = null;){
                raf = new RandomAccessFile(file, "rw");
                int size = indexList.size();
                raf.writeInt(size);
                long dataPosition = ADDRESS_POSITION + (long)(size + 1) * 8L;
                long[] pointer = new long[size];
                raf.seek(dataPosition);
                for (int i = 0; i < size; ++i) {
                    long pos;
                    Slice2DIndex sliceNDIndex = indexList.get(i);
                    pointer[i] = pos = raf.getFilePointer();
                    raf.writeInt(-sliceNDIndex.getNCount());
                    for (int j = 0; j < sliceNDIndex.getNCount(); ++j) {
                        raf.writeInt(sliceNDIndex.getNIndex(j));
                    }
                    raf.write(sliceNDIndex.getVariableName().getBytes());
                }
                long dataEnd = raf.getFilePointer();
                raf.seek(ADDRESS_POSITION);
                for (long address : pointer) {
                    raf.writeLong(address);
                }
                raf.writeLong(dataEnd);
            }
        }

        public int getNumberOfRecords() throws IOException {
            return this.numberOfRecords;
        }

        protected void finalize() throws Throwable {
            if (this.raf != null) {
                LOGGER.warning("There is code leaving slice index managers open, this might cause issues with file deletion on Windows!");
                if (NetCDFUtilities.TRACE_ENABLED.booleanValue()) {
                    LOGGER.log(Level.WARNING, "The unclosed slice index managers originated on this stack trace", this.tracer);
                }
                this.dispose();
            }
        }
    }
}

