/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf.cv;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.imageio.netcdf.cv.CoordinateHandlerFinder;
import org.geotools.imageio.netcdf.cv.CoordinateHandlerSpi;
import org.geotools.imageio.netcdf.cv.NumericCoordinateVariable;
import org.geotools.imageio.netcdf.cv.TimeCoordinateVariable;
import org.geotools.imageio.netcdf.utilities.NetCDFCRSUtilities;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis2D;

public abstract class CoordinateVariable<T> {
    private static final double KM_TO_M = 1000.0;
    private static final Logger LOGGER = Logging.getLogger(CoordinateVariable.class);
    protected final Class<T> binding;
    protected final CoordinateAxis coordinateAxis;
    private CoordinateReferenceSystem crs;
    private double conversionFactor = Double.NaN;
    private boolean convertAxis = false;
    private AxisHelper<T> axisHelper;

    public static Class<?> suggestBinding(CoordinateAxis coordinateAxis) {
        Utilities.ensureNonNull((String)"coordinateAxis", (Object)coordinateAxis);
        AxisType axisType = coordinateAxis.getAxisType();
        switch (axisType) {
            case GeoX: 
            case GeoY: 
            case GeoZ: 
            case Height: 
            case Lat: 
            case Lon: 
            case Pressure: 
            case Spectral: {
                DataType dataType = coordinateAxis.getDataType();
                Attribute scaleFactor = coordinateAxis.findAttribute("scale_factor");
                Attribute offsetFactor = coordinateAxis.findAttribute("offset");
                if (scaleFactor != null || offsetFactor != null) {
                    return Double.class;
                }
                switch (dataType) {
                    case DOUBLE: {
                        return Double.class;
                    }
                    case BYTE: {
                        return Byte.class;
                    }
                    case FLOAT: {
                        return Float.class;
                    }
                    case INT: {
                        return Integer.class;
                    }
                    case LONG: {
                        return Long.class;
                    }
                    case SHORT: {
                        return Short.class;
                    }
                }
                break;
            }
            case Time: 
            case RunTime: {
                LOGGER.log(Level.FINE, "Date mapping for axis:" + coordinateAxis.toString());
                return Date.class;
            }
        }
        LOGGER.log(Level.FINE, "Unable to find mapping for axis:" + coordinateAxis.toString());
        return null;
    }

    public static CoordinateVariable<?> create(CoordinateAxis coordinateAxis) {
        Utilities.ensureNonNull((String)"coordinateAxis", (Object)coordinateAxis);
        AxisType axisType = coordinateAxis.getAxisType();
        if (coordinateAxis.isNumeric()) {
            switch (axisType) {
                case GeoX: 
                case GeoY: 
                case GeoZ: 
                case Height: 
                case Lat: 
                case Lon: 
                case Pressure: 
                case Spectral: {
                    return new NumericCoordinateVariable(CoordinateVariable.suggestBinding(coordinateAxis), coordinateAxis);
                }
                case Time: 
                case RunTime: {
                    return new TimeCoordinateVariable(coordinateAxis);
                }
            }
            throw new IllegalArgumentException("Unsupported axis type: " + axisType + " for coordinate variable: " + coordinateAxis.toStringDebug());
        }
        if (NetCDFUtilities.isCheckCoordinatePlugins()) {
            CoordinateHandlerSpi.CoordinateHandler handler;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Checking for registered coordinate plugins");
            }
            if ((handler = CoordinateHandlerFinder.findHandler(coordinateAxis)) != null) {
                return handler.createCoordinateVariable(coordinateAxis);
            }
        }
        throw new IllegalArgumentException("Unable to process non numeric coordinate variable: " + coordinateAxis.toString());
    }

    public CoordinateVariable(Class<T> binding, CoordinateAxis coordinateAxis) {
        Utilities.ensureNonNull((String)"coordinateAxis", (Object)coordinateAxis);
        Utilities.ensureNonNull((String)"binding", binding);
        this.binding = binding;
        this.coordinateAxis = coordinateAxis;
        this.conversionFactor = 1.0;
        AxisType axisType = coordinateAxis.getAxisType();
        if (NetCDFCRSUtilities.isConvertAxisKm() && (axisType == AxisType.GeoX || axisType == AxisType.GeoY) && coordinateAxis.getUnitsString().equalsIgnoreCase("km")) {
            this.conversionFactor = 1000.0;
            this.convertAxis = true;
        }
    }

    protected void init() {
        this.axisHelper = !this.coordinateAxis.isNumeric() || !(this.coordinateAxis instanceof CoordinateAxis1D) || this.coordinateAxis.hasMissing() && !AxisType.Time.equals((Object)this.coordinateAxis.getAxisType()) ? new CoordinateAxisGeneralHelper() : new CoordinateAxis1DNumericHelper();
    }

    protected boolean isMissing(Object val) {
        if (val instanceof Number) {
            return this.coordinateAxis.isMissing(((Number)val).doubleValue());
        }
        return val == null;
    }

    public Class<T> getType() {
        return this.binding;
    }

    public String getUnit() {
        return this.coordinateAxis.getUnitsString();
    }

    public CoordinateAxis unwrap() {
        return this.coordinateAxis;
    }

    public AxisType getAxisType() {
        return this.coordinateAxis.getAxisType();
    }

    public String getName() {
        return this.coordinateAxis.getShortName();
    }

    public long getSize() throws IOException {
        return this.axisHelper.getSize();
    }

    public boolean isRegular() {
        return this.coordinateAxis instanceof CoordinateAxis1D && ((CoordinateAxis1D)this.coordinateAxis).isRegular();
    }

    public double getIncrement() {
        if (!(this.coordinateAxis instanceof CoordinateAxis1D)) {
            return Double.NaN;
        }
        return this.convertAxis ? ((CoordinateAxis1D)this.coordinateAxis).getIncrement() * this.conversionFactor : ((CoordinateAxis1D)this.coordinateAxis).getIncrement();
    }

    public double getStart() {
        if (!(this.coordinateAxis instanceof CoordinateAxis1D)) {
            return Double.NaN;
        }
        return this.convertAxis ? ((CoordinateAxis1D)this.coordinateAxis).getStart() * this.conversionFactor : ((CoordinateAxis1D)this.coordinateAxis).getStart();
    }

    public T getMinimum() throws IOException {
        return this.axisHelper.getMinimum();
    }

    public T getMaximum() throws IOException {
        return this.axisHelper.getMaximum();
    }

    public T read(Map<String, Integer> indexMap) throws IndexOutOfBoundsException {
        return this.axisHelper.get(indexMap);
    }

    public List<T> read() throws IndexOutOfBoundsException {
        return this.axisHelper.getAll();
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        if (this.crs == null) {
            this.crs = this.buildCoordinateReferenceSystem();
        }
        return this.crs;
    }

    public abstract boolean isNumeric();

    protected abstract T convertValue(Object var1);

    protected abstract CoordinateReferenceSystem buildCoordinateReferenceSystem();

    public String toString() {
        try {
            return "CoordinateVariable [binding=" + this.binding + ", coordinateAxis=" + this.coordinateAxis + ", getType()=" + this.getType() + ", getUnit()=" + this.getUnit() + ", getAxisType()=" + this.getAxisType() + ", getName()=" + this.getName() + ", getSize()=" + this.getSize() + ", isRegular()=" + this.isRegular() + ", getIncrement()=" + this.getIncrement() + ", getStart()=" + this.getStart() + ", isNumeric()=" + this.isNumeric() + ", getMinimum()=" + this.getMinimum() + ", getMaximum()=" + this.getMaximum() + "]";
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected class CoordinateAxisGeneralHelper
    implements AxisHelper<T> {
        private List<T> convertedData = new ArrayList();
        private SortedSet<T> orderedSet = new TreeSet();

        public CoordinateAxisGeneralHelper() {
            Array data;
            try {
                data = CoordinateVariable.this.coordinateAxis.read();
            }
            catch (IOException ioe) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Error reading coordinate values ", ioe);
                }
                throw new IllegalStateException(ioe);
            }
            if (data instanceof ArrayChar) {
                ArrayChar.StringIterator it = ((ArrayChar)data).getStringIterator();
                while (it.hasNext()) {
                    String val = it.next();
                    if (val != null && !val.isEmpty()) {
                        Object convertedVal = CoordinateVariable.this.convertValue(val);
                        this.orderedSet.add(convertedVal);
                        this.convertedData.add(convertedVal);
                        continue;
                    }
                    this.convertedData.add(null);
                }
            } else {
                IndexIterator it = data.getIndexIterator();
                while (it.hasNext()) {
                    Object val = it.next();
                    if (!CoordinateVariable.this.isMissing(val)) {
                        Object convertedVal = CoordinateVariable.this.convertValue(val);
                        this.orderedSet.add(convertedVal);
                        this.convertedData.add(convertedVal);
                        continue;
                    }
                    this.convertedData.add(null);
                }
            }
        }

        @Override
        public synchronized T get(Map<String, Integer> indexMap) {
            int i = indexMap.get(CoordinateVariable.this.coordinateAxis.getFullName());
            int j = CoordinateVariable.this.coordinateAxis instanceof CoordinateAxis2D ? indexMap.get(CoordinateVariable.this.coordinateAxis.getDimension(0).getFullName()) : 0;
            return this.convertedData.get(i + (j != 0 ? j * CoordinateVariable.this.coordinateAxis.getDimension(1).getLength() : 0));
        }

        @Override
        public int getSize() {
            return this.orderedSet.size();
        }

        @Override
        public T getMinimum() {
            return this.orderedSet.first();
        }

        @Override
        public T getMaximum() {
            return this.orderedSet.last();
        }

        @Override
        public List<T> getAll() {
            return new ArrayList(this.orderedSet);
        }
    }

    protected class CoordinateAxis1DNumericHelper
    implements AxisHelper<T> {
        private CoordinateAxis1D axis1D;

        public CoordinateAxis1DNumericHelper() {
            this.axis1D = (CoordinateAxis1D)CoordinateVariable.this.coordinateAxis;
        }

        @Override
        public synchronized T get(Map<String, Integer> indexMap) {
            return CoordinateVariable.this.convertValue(this.axis1D.getCoordValue(indexMap.get(CoordinateVariable.this.coordinateAxis.getFullName()).intValue()));
        }

        @Override
        public int getSize() {
            return this.axis1D.getShape(0);
        }

        @Override
        public T getMinimum() {
            return CoordinateVariable.this.convertValue(this.axis1D.getMinValue());
        }

        @Override
        public T getMaximum() {
            return CoordinateVariable.this.convertValue(this.axis1D.getMaxValue());
        }

        @Override
        public List<T> getAll() {
            return new AbstractList<T>(){

                @Override
                public T get(int index) {
                    return CoordinateVariable.this.convertValue(CoordinateAxis1DNumericHelper.this.axis1D.getCoordValue(index));
                }

                @Override
                public int size() {
                    return CoordinateAxis1DNumericHelper.this.axis1D.getShape(0);
                }
            };
        }
    }

    protected static interface AxisHelper<T> {
        public int getSize();

        public T get(Map<String, Integer> var1);

        public List<T> getAll();

        public T getMinimum();

        public T getMaximum();
    }
}

