/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf.utilities;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;

class RuntimeExtractor
extends PropertiesCollector {
    private static final Logger LOGGER = Logging.getLogger(RuntimeExtractor.class);
    Date date;
    String type = null;

    public RuntimeExtractor(PropertiesCollectorSPI spi, List<String> propertyNames, String type) {
        super(spi, propertyNames);
        this.type = type;
    }

    public void setProperties(SimpleFeature feature) {
        for (String propertyName : this.getPropertyNames()) {
            feature.setAttribute(propertyName, (Object)this.date);
        }
    }

    public void setProperties(Map<String, Object> map) {
        throw new UnsupportedOperationException();
    }

    public RuntimeExtractor collect(File file) {
        super.collect(file);
        if (this.type.equalsIgnoreCase(RuntimeType.MODIFY_TIME.toString())) {
            this.date = new Date(file.lastModified());
        }
        return this;
    }

    public RuntimeExtractor collect(URL url) {
        super.collect(url);
        if (this.type.equalsIgnoreCase(RuntimeType.MODIFY_TIME.toString())) {
            String warningMessage = null;
            try {
                URLConnection connection = url.openConnection();
                long lastModified = connection.getHeaderFieldDate("Last-Modified", -1L);
                if (lastModified != -1L) {
                    this.date = new Date(lastModified);
                } else {
                    this.date = new Date();
                    warningMessage = "Unable to extract the last modified date from the provided url " + url;
                }
            }
            catch (IOException ioe) {
                warningMessage = "Unable to extract the last modified date from the provided url " + url + " due to " + ioe.getLocalizedMessage();
            }
            if (warningMessage != null && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(warningMessage);
            }
        }
        return this;
    }

    static enum RuntimeType {
        MODIFY_TIME;

    }
}

