/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.netcdf;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.api.data.CloseableIterator;
import org.geotools.api.data.FileGroupProvider;
import org.geotools.api.data.FileResourceInfo;
import org.geotools.api.data.Query;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.api.geometry.Bounds;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.io.catalog.CoverageSlice;
import org.geotools.coverage.io.catalog.CoverageSlicesCatalog;
import org.geotools.coverage.io.netcdf.NetCDFReader;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.DefaultResourceInfo;
import org.geotools.filter.SortByImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.URLs;

class NetCDFFileResourceInfo
extends DefaultResourceInfo
implements FileResourceInfo {
    private NetCDFReader reader;
    private String coverageName;
    CoverageSlicesCatalog slicesCatalog;
    private URL sourceURL;

    public NetCDFFileResourceInfo(NetCDFReader reader, String coverageName, CoverageSlicesCatalog slicesCatalog, URL sourceURL) {
        this.reader = reader;
        this.slicesCatalog = slicesCatalog;
        this.coverageName = coverageName;
        this.sourceURL = sourceURL;
    }

    public CloseableIterator<FileGroupProvider.FileGroup> getFiles(Query query) {
        List fc = null;
        try {
            Query updatedQuery;
            boolean sharedCatalog = this.slicesCatalog instanceof CoverageSlicesCatalog.WrappedCoverageSlicesCatalog;
            Query query2 = updatedQuery = query != null && sharedCatalog ? query : new Query();
            if (sharedCatalog) {
                ArrayList<SortByImpl> clauses = new ArrayList<SortByImpl>(1);
                clauses.add(new SortByImpl(FeatureUtilities.DEFAULT_FILTER_FACTORY.property("location"), SortOrder.ASCENDING));
                SortBy[] sb = clauses.toArray(new SortBy[0]);
                boolean isSortBySupported = this.slicesCatalog.getQueryCapabilities(this.coverageName).supportsSorting(sb);
                if (isSortBySupported) {
                    updatedQuery.setSortBy(sb);
                }
            }
            updatedQuery.setTypeName(this.coverageName);
            fc = this.slicesCatalog.getGranules(updatedQuery);
            return sharedCatalog ? new WrappedCoverageSlicesToFileGroupIterator(fc) : new SimpleCoverageSlicesToFileGroupIterator(fc);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    class SimpleCoverageSlicesToFileGroupIterator
    implements CloseableIterator<FileGroupProvider.FileGroup> {
        protected List<CoverageSlice> slices = null;
        protected Iterator<CoverageSlice> slicesIterator;

        public SimpleCoverageSlicesToFileGroupIterator(List<CoverageSlice> slices) {
            this.slices = slices;
            this.slicesIterator = slices.iterator();
        }

        public boolean hasNext() {
            return this.slicesIterator.hasNext();
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove operation isn't supported");
        }

        public FileGroupProvider.FileGroup next() {
            File file = null;
            if (!(NetCDFFileResourceInfo.this.sourceURL == null || (file = URLs.urlToFile((URL)NetCDFFileResourceInfo.this.sourceURL)) != null && file.exists())) {
                throw new IllegalArgumentException("Unable to get a FileGroup on top of file:  " + file);
            }
            while (this.slicesIterator.hasNext()) {
                this.slicesIterator.next();
            }
            try {
                return this.buildFileGroupOnSlices(file);
            }
            catch (IOException e) {
                throw new RuntimeException("Exception occurred while populating the fileGroup:", e);
            }
        }

        private FileGroupProvider.FileGroup buildFileGroupOnSlices(File file) throws IOException {
            List supportFiles = null;
            Map<String, Object> metadataMap = this.computeSlicesMetadata(this.slices);
            metadataMap.put("BOUNDINGBOX", new ReferencedEnvelope((Bounds)NetCDFFileResourceInfo.this.reader.getOriginalEnvelope(NetCDFFileResourceInfo.this.coverageName)));
            return new FileGroupProvider.FileGroup(file, supportFiles, metadataMap);
        }

        protected Map<String, Object> computeSlicesMetadata(List<CoverageSlice> slices) throws IOException {
            HashMap<String, Object> metadataMap = null;
            List<DimensionDescriptor> dimensionDescriptors = NetCDFFileResourceInfo.this.reader.getDimensionDescriptors(NetCDFFileResourceInfo.this.coverageName);
            if (dimensionDescriptors != null && !dimensionDescriptors.isEmpty()) {
                metadataMap = new HashMap<String, Object>();
                for (DimensionDescriptor descriptor : dimensionDescriptors) {
                    String attribute = descriptor.getStartAttribute();
                    String name = descriptor.getName();
                    Comparable max = null;
                    Comparable min = null;
                    Comparable val = null;
                    for (CoverageSlice slice : slices) {
                        val = (Comparable)slice.getOriginator().getAttribute(attribute);
                        if (min == null) {
                            min = val;
                        }
                        if (max == null) {
                            max = val;
                        }
                        int minCheck = min.compareTo(val);
                        int maxCheck = max.compareTo(val);
                        min = minCheck < 0 ? min : val;
                        max = maxCheck > 0 ? max : val;
                    }
                    this.addMetadaElement(name, min, max, metadataMap);
                }
            }
            return metadataMap;
        }

        protected void addMetadaElement(String name, Comparable min, Comparable max, Map<String, Object> metadataMap) {
            if ("TIME".equalsIgnoreCase(name) || min instanceof Date) {
                metadataMap.put(name.toUpperCase(), new DateRange((Date)min, (Date)max));
            } else if ("ELEVATION".equalsIgnoreCase(name) || min instanceof Number) {
                metadataMap.put(name.toUpperCase(), NumberRange.create((double)((Number)((Object)min)).doubleValue(), (boolean)true, (double)((Number)((Object)max)).doubleValue(), (boolean)true));
            } else {
                metadataMap.put(name, new Range(String.class, (Comparable)((Object)((String)((Object)min))), (Comparable)((Object)((String)((Object)max)))));
            }
        }

        public void close() throws IOException {
        }
    }

    class WrappedCoverageSlicesToFileGroupIterator
    extends SimpleCoverageSlicesToFileGroupIterator {
        private File file;
        private String location;
        private CoverageSlice cachedNext;

        public WrappedCoverageSlicesToFileGroupIterator(List<CoverageSlice> slices) {
            super(slices);
            this.cachedNext = null;
            this.file = URLs.urlToFile((URL)NetCDFFileResourceInfo.this.sourceURL);
            this.location = this.file.getAbsolutePath();
        }

        @Override
        public boolean hasNext() {
            return super.hasNext() || this.cachedNext != null;
        }

        @Override
        public FileGroupProvider.FileGroup next() {
            CoverageSlice next = null;
            if (this.cachedNext != null) {
                next = this.cachedNext;
                this.cachedNext = null;
            } else {
                next = (CoverageSlice)this.slicesIterator.next();
            }
            int groupedFeatures = 0;
            ArrayList<CoverageSlice> relevantSlices = new ArrayList<CoverageSlice>();
            relevantSlices.add(next);
            File file = null;
            if (NetCDFFileResourceInfo.this.sourceURL != null && (file = URLs.urlToFile((URL)NetCDFFileResourceInfo.this.sourceURL)) != null && file.exists()) {
                ++groupedFeatures;
            }
            if (groupedFeatures == 0) {
                return null;
            }
            while (this.slicesIterator.hasNext()) {
                next = (CoverageSlice)this.slicesIterator.next();
                relevantSlices.add(next);
                String nextLocation = (String)next.getOriginator().getAttribute("location");
                if (this.location.equalsIgnoreCase(nextLocation)) {
                    ++groupedFeatures;
                    continue;
                }
                this.cachedNext = next;
                break;
            }
            try {
                return this.buildFileGroup(relevantSlices);
            }
            catch (IOException e) {
                throw new RuntimeException("Exception occurred while populating the fileGroup:", e);
            }
        }

        private FileGroupProvider.FileGroup buildFileGroup(List<CoverageSlice> slices) throws IOException {
            List supportFiles = null;
            Map<String, Object> metadataMap = this.computeSlicesMetadata(slices);
            metadataMap.put("BOUNDINGBOX", new ReferencedEnvelope(slices.get(0).getGranuleBBOX()));
            return new FileGroupProvider.FileGroup(this.file, supportFiles, metadataMap);
        }
    }
}

