/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio.netcdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.format.MeasurementParseException;
import org.geotools.measure.BaseUnitFormatter;
import org.geotools.measure.UnitDefinition;
import org.geotools.measure.UnitDefinitions;
import org.geotools.util.logging.Logging;
import si.uom.NonSI;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.function.LogConverter;

public final class NetCDFUnitFormat
extends BaseUnitFormatter {
    private static final Logger LOGGER = Logging.getLogger(NetCDFUnitFormat.class);
    public static final String NETCDF_UNIT_ALIASES = "netcdf-unit-aliases.properties";
    public static final String NETCDF_UNIT_REPLACEMENTS = "netcdf-unit-replacements.properties";
    private static final Map<String, String> CONTENT_REPLACEMENTS = Map.ofEntries(Map.entry(" ", "*"), Map.entry("-", "^-"), Map.entry(".", "*"));
    private static final List<UnitDefinition> UNIT_DEFINITIONS = Stream.of(UnitDefinitions.DIMENSIONLESS, UnitDefinitions.CONSTANTS, UnitDefinitions.SI_BASE, UnitDefinitions.SI_DERIVED, UnitDefinitions.NON_SI, UnitDefinitions.US_CUSTOMARY, UnitDefinitions.GEOTOOLS).flatMap(Collection::stream).collect(Collectors.toUnmodifiableList());
    private static final NetCDFUnitFormat INSTANCE = NetCDFUnitFormat.createWithBuiltInConfig();
    private Map<String, String> REPLACEMENTS;

    public static NetCDFUnitFormat getInstance() {
        return INSTANCE;
    }

    public static NetCDFUnitFormat createWithBuiltInConfig() {
        return new NetCDFUnitFormat(NetCDFUnitFormat.builtInReplacements(), NetCDFUnitFormat.builtInAliases());
    }

    public static NetCDFUnitFormat create(Map<String, String> replacements, Map<String, String> aliases) {
        return new NetCDFUnitFormat(replacements, aliases);
    }

    public static Map<String, String> builtInReplacements() {
        return NetCDFUnitFormat.loadPropertiesOrdered(NetCDFUnitFormat.class.getResourceAsStream(NETCDF_UNIT_REPLACEMENTS));
    }

    public static Map<String, String> builtInAliases() {
        return NetCDFUnitFormat.loadPropertiesOrdered(NetCDFUnitFormat.class.getResourceAsStream(NETCDF_UNIT_ALIASES));
    }

    private NetCDFUnitFormat(Map<String, String> replacements, Map<String, String> aliases) {
        super(UNIT_DEFINITIONS);
        this.setReplacements(replacements);
        this.setAliases(aliases);
    }

    public static LinkedHashMap<String, String> loadPropertiesOrdered(InputStream is) {
        try {
            final LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            Properties props = new Properties(){

                @Override
                public Object put(Object key, Object value) {
                    result.put((String)key, (String)value);
                    return super.put(key, value);
                }
            };
            props.load(new InputStreamReader(is, StandardCharsets.UTF_8));
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load the build-in config file: netcdf-unit-aliases.properties" + e);
        }
    }

    public void setReplacements(Map<String, String> replacements) {
        this.REPLACEMENTS = new LinkedHashMap<String, String>(replacements);
    }

    public void setAliases(Map<String, String> aliases) {
        Unit bel = AbstractUnit.ONE.transform((UnitConverter)new LogConverter(10.0));
        this.addAlias(bel.divide(10.0), "dB");
        for (Unit unit : NonSI.getInstance().getUnits()) {
            if (unit.getSymbol() == null || !this.unknownSymbol(unit.getSymbol())) continue;
            this.addAlias(unit, unit.getSymbol());
        }
        this.addLabel(AbstractUnit.ONE, "unitless");
        for (Map.Entry entry : aliases.entrySet()) {
            try {
                this.addAlias(this.parse((String)entry.getValue()), (String)entry.getKey());
            }
            catch (MeasurementParseException ex) {
                LOGGER.log(Level.WARNING, "Failed to parse " + (String)entry.getKey() + " -> " + (String)entry.getValue() + ", skipped.", ex);
            }
        }
    }

    private boolean unknownSymbol(String symbol) {
        try {
            this.parse(symbol);
            return false;
        }
        catch (MeasurementParseException e) {
            return true;
        }
    }

    public Unit<?> parse(String spec) {
        boolean replaced = false;
        for (Map.Entry<String, String> entry : this.REPLACEMENTS.entrySet()) {
            replaced = spec.equals(entry.getKey());
            spec = spec.replace(entry.getKey(), entry.getValue());
            if (!replaced) continue;
            break;
        }
        if (!replaced) {
            for (Map.Entry<String, String> entry : CONTENT_REPLACEMENTS.entrySet()) {
                spec = spec.replace(entry.getKey(), entry.getValue());
            }
        }
        try {
            return super.parse((CharSequence)spec);
        }
        catch (MeasurementParseException e) {
            throw new MeasurementParseException("Failed to parse " + spec, (CharSequence)e.getParsedString(), e.getPosition());
        }
    }
}

